/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.parsers.ShapeParser;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentSubParser;
import org.elasticsearch.geo.geometry.Circle;
import org.elasticsearch.geo.geometry.Geometry;
import org.elasticsearch.geo.geometry.GeometryCollection;
import org.elasticsearch.geo.geometry.GeometryVisitor;
import org.elasticsearch.geo.geometry.Line;
import org.elasticsearch.geo.geometry.LinearRing;
import org.elasticsearch.geo.geometry.MultiLine;
import org.elasticsearch.geo.geometry.MultiPoint;
import org.elasticsearch.geo.geometry.MultiPolygon;
import org.elasticsearch.geo.geometry.Point;
import org.elasticsearch.geo.geometry.Polygon;
import org.elasticsearch.geo.geometry.Rectangle;
import org.elasticsearch.geo.geometry.ShapeType;

public final class GeoJson {
    private static final ParseField FIELD_TYPE = new ParseField("type", new String[0]);
    private static final ParseField FIELD_COORDINATES = new ParseField("coordinates", new String[0]);
    private static final ParseField FIELD_GEOMETRIES = new ParseField("geometries", new String[0]);
    private static final ParseField FIELD_ORIENTATION = new ParseField("orientation", new String[0]);
    private static final ParseField FIELD_RADIUS = new ParseField("radius", new String[0]);
    private static ConstructingObjectParser<Geometry, ParserContext> PARSER = new ConstructingObjectParser("geojson", true, (a, c) -> {
        String type = (String)a[0];
        CoordinateNode coordinates = (CoordinateNode)a[1];
        List geometries = (List)a[2];
        Boolean orientation = GeoJson.orientationFromString((String)a[3]);
        DistanceUnit.Distance radius = (DistanceUnit.Distance)a[4];
        return GeoJson.createGeometry(type, geometries, coordinates, orientation, c.defaultOrientation, c.coerce, radius);
    });

    private GeoJson() {
    }

    public static Geometry fromXContent(XContentParser parser, boolean rightOrientation, boolean coerce, boolean ignoreZValue) throws IOException {
        try (XContentSubParser subParser = new XContentSubParser(parser);){
            Geometry geometry = (Geometry)PARSER.apply((XContentParser)subParser, (Object)new ParserContext(rightOrientation, coerce, ignoreZValue));
            return geometry;
        }
    }

    public static XContentBuilder toXContent(Geometry geometry, final XContentBuilder builder, final ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD_TYPE.getPreferredName(), GeoJson.getGeoJsonName(geometry));
        geometry.visit((GeometryVisitor)new GeometryVisitor<XContentBuilder, IOException>(){

            public XContentBuilder visit(Circle circle) throws IOException {
                builder.field(FIELD_RADIUS.getPreferredName(), DistanceUnit.METERS.toString(circle.getRadiusMeters()));
                builder.field(ShapeParser.FIELD_COORDINATES.getPreferredName());
                return this.coordinatesToXContent(circle.getLat(), circle.getLon(), circle.getAlt());
            }

            public XContentBuilder visit(GeometryCollection<?> collection) throws IOException {
                builder.startArray(FIELD_GEOMETRIES.getPreferredName());
                for (Geometry g : collection) {
                    GeoJson.toXContent(g, builder, params);
                }
                return builder.endArray();
            }

            public XContentBuilder visit(Line line) throws IOException {
                builder.field(ShapeParser.FIELD_COORDINATES.getPreferredName());
                return this.coordinatesToXContent(line);
            }

            public XContentBuilder visit(LinearRing ring) {
                throw new UnsupportedOperationException("linearRing cannot be serialized using GeoJson");
            }

            public XContentBuilder visit(MultiLine multiLine) throws IOException {
                builder.field(ShapeParser.FIELD_COORDINATES.getPreferredName());
                builder.startArray();
                for (int i = 0; i < multiLine.size(); ++i) {
                    this.coordinatesToXContent((Line)multiLine.get(i));
                }
                return builder.endArray();
            }

            public XContentBuilder visit(MultiPoint multiPoint) throws IOException {
                builder.startArray(ShapeParser.FIELD_COORDINATES.getPreferredName());
                for (int i = 0; i < multiPoint.size(); ++i) {
                    Point p = (Point)multiPoint.get(i);
                    builder.startArray().value(p.getLon()).value(p.getLat());
                    if (p.hasAlt()) {
                        builder.value(p.getAlt());
                    }
                    builder.endArray();
                }
                return builder.endArray();
            }

            public XContentBuilder visit(MultiPolygon multiPolygon) throws IOException {
                builder.startArray(ShapeParser.FIELD_COORDINATES.getPreferredName());
                for (int i = 0; i < multiPolygon.size(); ++i) {
                    builder.startArray();
                    this.coordinatesToXContent((Polygon)multiPolygon.get(i));
                    builder.endArray();
                }
                return builder.endArray();
            }

            public XContentBuilder visit(Point point) throws IOException {
                builder.field(ShapeParser.FIELD_COORDINATES.getPreferredName());
                return this.coordinatesToXContent(point.getLat(), point.getLon(), point.getAlt());
            }

            public XContentBuilder visit(Polygon polygon) throws IOException {
                builder.startArray(ShapeParser.FIELD_COORDINATES.getPreferredName());
                this.coordinatesToXContent((Line)polygon.getPolygon());
                for (int i = 0; i < polygon.getNumberOfHoles(); ++i) {
                    this.coordinatesToXContent((Line)polygon.getHole(i));
                }
                return builder.endArray();
            }

            public XContentBuilder visit(Rectangle rectangle) throws IOException {
                builder.startArray(ShapeParser.FIELD_COORDINATES.getPreferredName());
                this.coordinatesToXContent(rectangle.getMaxLat(), rectangle.getMinLon(), rectangle.getMinAlt());
                this.coordinatesToXContent(rectangle.getMinLat(), rectangle.getMaxLon(), rectangle.getMaxAlt());
                return builder.endArray();
            }

            private XContentBuilder coordinatesToXContent(double lat, double lon, double alt) throws IOException {
                builder.startArray().value(lon).value(lat);
                if (!Double.isNaN(alt)) {
                    builder.value(alt);
                }
                return builder.endArray();
            }

            private XContentBuilder coordinatesToXContent(Line line) throws IOException {
                builder.startArray();
                for (int i = 0; i < line.length(); ++i) {
                    builder.startArray().value(line.getLon(i)).value(line.getLat(i));
                    if (line.hasAlt()) {
                        builder.value(line.getAlt(i));
                    }
                    builder.endArray();
                }
                return builder.endArray();
            }

            private XContentBuilder coordinatesToXContent(Polygon polygon) throws IOException {
                this.coordinatesToXContent((Line)polygon.getPolygon());
                for (int i = 0; i < polygon.getNumberOfHoles(); ++i) {
                    this.coordinatesToXContent((Line)polygon.getHole(i));
                }
                return builder;
            }
        });
        return builder.endObject();
    }

    private static Geometry createGeometry(String type, List<Geometry> geometries, CoordinateNode coordinates, Boolean orientation, boolean defaultOrientation, boolean coerce, DistanceUnit.Distance radius) {
        ShapeType shapeType = ShapeType.forName((String)type);
        if (shapeType == ShapeType.GEOMETRYCOLLECTION) {
            if (geometries == null) {
                throw new ElasticsearchParseException("geometries not included", new Object[0]);
            }
            if (coordinates != null) {
                throw new ElasticsearchParseException("parameter coordinates is not supported for type " + type, new Object[0]);
            }
            GeoJson.verifyNulls(type, null, orientation, radius);
            return new GeometryCollection(geometries);
        }
        if (coordinates == null) {
            throw new ElasticsearchParseException("coordinates not included", new Object[0]);
        }
        switch (shapeType) {
            case CIRCLE: {
                if (radius == null) {
                    throw new ElasticsearchParseException("radius is not specified", new Object[0]);
                }
                GeoJson.verifyNulls(type, geometries, orientation, null);
                Point point = coordinates.asPoint();
                return new Circle(point.getLat(), point.getLon(), point.getAlt(), radius.convert((DistanceUnit)DistanceUnit.METERS).value);
            }
            case POINT: {
                GeoJson.verifyNulls(type, geometries, orientation, radius);
                return coordinates.asPoint();
            }
            case MULTIPOINT: {
                GeoJson.verifyNulls(type, geometries, orientation, radius);
                return coordinates.asMultiPoint();
            }
            case LINESTRING: {
                GeoJson.verifyNulls(type, geometries, orientation, radius);
                return coordinates.asLineString(coerce);
            }
            case MULTILINESTRING: {
                GeoJson.verifyNulls(type, geometries, orientation, radius);
                return coordinates.asMultiLineString(coerce);
            }
            case POLYGON: {
                GeoJson.verifyNulls(type, geometries, null, radius);
                return coordinates.asPolygon(orientation != null ? orientation : defaultOrientation, coerce);
            }
            case MULTIPOLYGON: {
                GeoJson.verifyNulls(type, geometries, null, radius);
                return coordinates.asMultiPolygon(orientation != null ? orientation : defaultOrientation, coerce);
            }
            case ENVELOPE: {
                GeoJson.verifyNulls(type, geometries, orientation, radius);
                return coordinates.asRectangle();
            }
        }
        throw new ElasticsearchParseException("unsuppoted shape type " + type, new Object[0]);
    }

    private static void verifyNulls(String type, List<Geometry> geometries, Boolean orientation, DistanceUnit.Distance radius) {
        if (geometries != null) {
            throw new ElasticsearchParseException("parameter geometries is not supported for type " + type, new Object[0]);
        }
        if (orientation != null) {
            throw new ElasticsearchParseException("parameter orientation is not supported for type " + type, new Object[0]);
        }
        if (radius != null) {
            throw new ElasticsearchParseException("parameter radius is not supported for type " + type, new Object[0]);
        }
    }

    private static CoordinateNode parseCoordinates(XContentParser parser, boolean ignoreZValue) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.START_ARRAY && token != XContentParser.Token.END_ARRAY && token != XContentParser.Token.VALUE_NULL) {
            return new CoordinateNode(GeoJson.parseCoordinate(parser, ignoreZValue));
        }
        if (token == XContentParser.Token.VALUE_NULL) {
            throw new IllegalArgumentException("coordinates cannot contain NULL values)");
        }
        ArrayList<CoordinateNode> nodes = new ArrayList<CoordinateNode>();
        while (token != XContentParser.Token.END_ARRAY) {
            CoordinateNode node = GeoJson.parseCoordinates(parser, ignoreZValue);
            if (!nodes.isEmpty() && ((CoordinateNode)nodes.get(0)).numDimensions() != node.numDimensions()) {
                throw new ElasticsearchParseException("Exception parsing coordinates: number of dimensions do not match", new Object[0]);
            }
            nodes.add(node);
            token = parser.nextToken();
        }
        return new CoordinateNode(nodes);
    }

    private static Point parseCoordinate(XContentParser parser, boolean ignoreZValue) throws IOException {
        if (parser.currentToken() != XContentParser.Token.VALUE_NUMBER) {
            throw new ElasticsearchParseException("geo coordinates must be numbers", new Object[0]);
        }
        double lon = parser.doubleValue();
        if (parser.nextToken() != XContentParser.Token.VALUE_NUMBER) {
            throw new ElasticsearchParseException("geo coordinates must be numbers", new Object[0]);
        }
        double lat = parser.doubleValue();
        XContentParser.Token token = parser.nextToken();
        double alt = Double.NaN;
        if (token == XContentParser.Token.VALUE_NUMBER) {
            alt = GeoPoint.assertZValue(ignoreZValue, parser.doubleValue());
            parser.nextToken();
        }
        if (parser.currentToken() == XContentParser.Token.VALUE_NUMBER) {
            throw new ElasticsearchParseException("geo coordinates greater than 3 dimensions are not supported", new Object[0]);
        }
        return new Point(lat, lon, alt);
    }

    private static Boolean orientationFromString(String orientation) {
        if (orientation == null) {
            return null;
        }
        switch (orientation = orientation.toLowerCase(Locale.ROOT)) {
            case "right": 
            case "counterclockwise": 
            case "ccw": {
                return true;
            }
            case "left": 
            case "clockwise": 
            case "cw": {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown orientation [" + orientation + "]");
    }

    public static String getGeoJsonName(Geometry geometry) {
        return (String)geometry.visit((GeometryVisitor)new GeometryVisitor<String, RuntimeException>(){

            public String visit(Circle circle) {
                return "Circle";
            }

            public String visit(GeometryCollection<?> collection) {
                return "GeometryCollection";
            }

            public String visit(Line line) {
                return "LineString";
            }

            public String visit(LinearRing ring) {
                throw new UnsupportedOperationException("line ring cannot be serialized using GeoJson");
            }

            public String visit(MultiLine multiLine) {
                return "MultiLineString";
            }

            public String visit(MultiPoint multiPoint) {
                return "MultiPoint";
            }

            public String visit(MultiPolygon multiPolygon) {
                return "MultiPolygon";
            }

            public String visit(Point point) {
                return "Point";
            }

            public String visit(Polygon polygon) {
                return "Polygon";
            }

            public String visit(Rectangle rectangle) {
                return "Envelope";
            }
        });
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD_TYPE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> GeoJson.parseCoordinates(p, c.ignoreZValue), FIELD_COORDINATES, ObjectParser.ValueType.VALUE_ARRAY);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), PARSER, FIELD_GEOMETRIES);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FIELD_ORIENTATION);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> DistanceUnit.Distance.parseDistance(p.text()), FIELD_RADIUS, ObjectParser.ValueType.STRING);
    }

    private static class CoordinateNode
    implements ToXContentObject {
        public final Point coordinate;
        public final List<CoordinateNode> children;

        CoordinateNode(Point coordinate) {
            this.coordinate = coordinate;
            this.children = null;
        }

        CoordinateNode(List<CoordinateNode> children) {
            this.children = children;
            this.coordinate = null;
        }

        public boolean isEmpty() {
            return this.coordinate == null && (this.children == null || this.children.isEmpty());
        }

        protected int numDimensions() {
            if (this.isEmpty()) {
                throw new ElasticsearchException("attempting to get number of dimensions on an empty coordinate node", new Object[0]);
            }
            if (this.coordinate != null) {
                return this.coordinate.hasAlt() ? 3 : 2;
            }
            return this.children.get(0).numDimensions();
        }

        public Point asPoint() {
            if (this.children != null) {
                throw new ElasticsearchException("expected a single points but got a list", new Object[0]);
            }
            return this.coordinate;
        }

        public MultiPoint asMultiPoint() {
            if (this.coordinate != null) {
                throw new ElasticsearchException("expected a list of points but got a point", new Object[0]);
            }
            ArrayList<Point> points = new ArrayList<Point>();
            for (CoordinateNode node : this.children) {
                points.add(node.asPoint());
            }
            return new MultiPoint(points);
        }

        private double[][] asLineComponents(boolean orientation, boolean coerce) {
            int resultSize;
            boolean needsClosing;
            if (this.coordinate != null) {
                throw new ElasticsearchException("expected a list of points but got a point", new Object[0]);
            }
            if (this.children.size() < 2) {
                throw new ElasticsearchException("not enough points to build a line", new Object[0]);
            }
            if (coerce && !this.children.get(0).asPoint().equals((Object)this.children.get(this.children.size() - 1).asPoint())) {
                needsClosing = true;
                resultSize = this.children.size() + 1;
            } else {
                needsClosing = false;
                resultSize = this.children.size();
            }
            double[] lats = new double[resultSize];
            double[] lons = new double[resultSize];
            double[] alts = this.numDimensions() == 3 ? new double[resultSize] : null;
            int i = orientation ? 0 : lats.length - 1;
            for (CoordinateNode node : this.children) {
                Point point = node.asPoint();
                lats[i] = point.getLat();
                lons[i] = point.getLon();
                if (alts != null) {
                    alts[i] = point.getAlt();
                }
                i = orientation ? i + 1 : i - 1;
            }
            if (needsClosing) {
                lats[resultSize - 1] = lats[0];
                lons[resultSize - 1] = lons[0];
                if (alts != null) {
                    alts[resultSize - 1] = alts[0];
                }
            }
            double[][] components = new double[][]{lats, lons, alts};
            return components;
        }

        public Line asLineString(boolean coerce) {
            double[][] components = this.asLineComponents(true, coerce);
            return new Line(components[0], components[1], components[2]);
        }

        public LinearRing asLinearRing(boolean orientation, boolean coerce) {
            double[][] components = this.asLineComponents(orientation, coerce);
            return new LinearRing(components[0], components[1], components[2]);
        }

        public MultiLine asMultiLineString(boolean coerce) {
            if (this.coordinate != null) {
                throw new ElasticsearchException("expected a list of points but got a point", new Object[0]);
            }
            ArrayList<Line> lines = new ArrayList<Line>();
            for (CoordinateNode node : this.children) {
                lines.add(node.asLineString(coerce));
            }
            return new MultiLine(lines);
        }

        public Polygon asPolygon(boolean orientation, boolean coerce) {
            if (this.coordinate != null) {
                throw new ElasticsearchException("expected a list of points but got a point", new Object[0]);
            }
            ArrayList<LinearRing> lines = new ArrayList<LinearRing>();
            for (CoordinateNode node : this.children) {
                lines.add(node.asLinearRing(orientation, coerce));
            }
            if (lines.size() == 1) {
                return new Polygon((LinearRing)lines.get(0));
            }
            LinearRing shell = (LinearRing)lines.remove(0);
            return new Polygon(shell, lines);
        }

        public MultiPolygon asMultiPolygon(boolean orientation, boolean coerce) {
            if (this.coordinate != null) {
                throw new ElasticsearchException("expected a list of points but got a point", new Object[0]);
            }
            ArrayList<Polygon> polygons = new ArrayList<Polygon>();
            for (CoordinateNode node : this.children) {
                polygons.add(node.asPolygon(orientation, coerce));
            }
            return new MultiPolygon(polygons);
        }

        public Rectangle asRectangle() {
            if (this.children.size() != 2) {
                throw new ElasticsearchParseException("invalid number of points [{}] provided for geo_shape [{}] when expecting an array of 2 coordinates", this.children.size(), ShapeType.ENVELOPE);
            }
            Point uL = this.children.get((int)0).coordinate;
            Point lR = this.children.get((int)1).coordinate;
            return new Rectangle(lR.getLat(), uL.getLat(), uL.getLon(), lR.getLon());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.children == null) {
                builder.startArray().value(this.coordinate.getLon()).value(this.coordinate.getLat()).endArray();
            } else {
                builder.startArray();
                for (CoordinateNode child : this.children) {
                    child.toXContent(builder, params);
                }
                builder.endArray();
            }
            return builder;
        }
    }

    private static class ParserContext {
        public final boolean defaultOrientation;
        public final boolean coerce;
        public final boolean ignoreZValue;

        ParserContext(boolean defaultOrientation, boolean coerce, boolean ignoreZValue) {
            this.defaultOrientation = defaultOrientation;
            this.coerce = coerce;
            this.ignoreZValue = ignoreZValue;
        }
    }
}

