/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.broadcast;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestActions;

public class BroadcastResponse
extends ActionResponse
implements ToXContentObject {
    public static final DefaultShardOperationFailedException[] EMPTY = new DefaultShardOperationFailedException[0];
    private static final ParseField _SHARDS_FIELD = new ParseField("_shards", new String[0]);
    private static final ParseField TOTAL_FIELD = new ParseField("total", new String[0]);
    private static final ParseField SUCCESSFUL_FIELD = new ParseField("successful", new String[0]);
    private static final ParseField FAILED_FIELD = new ParseField("failed", new String[0]);
    private static final ParseField FAILURES_FIELD = new ParseField("failures", new String[0]);
    private int totalShards;
    private int successfulShards;
    private int failedShards;
    private DefaultShardOperationFailedException[] shardFailures = EMPTY;

    protected static <T extends BroadcastResponse> void declareBroadcastFields(ConstructingObjectParser<T, Void> PARSER) {
        ConstructingObjectParser shardsParser = new ConstructingObjectParser("_shards", true, arg -> new BroadcastResponse((Integer)arg[0], (Integer)arg[1], (Integer)arg[2], (List)arg[3]));
        shardsParser.declareInt(ConstructingObjectParser.constructorArg(), TOTAL_FIELD);
        shardsParser.declareInt(ConstructingObjectParser.constructorArg(), SUCCESSFUL_FIELD);
        shardsParser.declareInt(ConstructingObjectParser.constructorArg(), FAILED_FIELD);
        shardsParser.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DefaultShardOperationFailedException.fromXContent(p), FAILURES_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (ContextParser)shardsParser, _SHARDS_FIELD);
    }

    public BroadcastResponse() {
    }

    public BroadcastResponse(int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures) {
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
        this.failedShards = failedShards;
        this.shardFailures = shardFailures == null ? EMPTY : shardFailures.toArray(new DefaultShardOperationFailedException[shardFailures.size()]);
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    public int getSuccessfulShards() {
        return this.successfulShards;
    }

    public int getFailedShards() {
        return this.failedShards;
    }

    public RestStatus getStatus() {
        if (this.failedShards > 0) {
            return this.shardFailures[0].status();
        }
        return RestStatus.OK;
    }

    public DefaultShardOperationFailedException[] getShardFailures() {
        return this.shardFailures;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
        this.failedShards = in.readVInt();
        int size = in.readVInt();
        if (size > 0) {
            this.shardFailures = new DefaultShardOperationFailedException[size];
            for (int i = 0; i < size; ++i) {
                this.shardFailures[i] = DefaultShardOperationFailedException.readShardOperationFailed(in);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.failedShards);
        out.writeVInt(this.shardFailures.length);
        for (DefaultShardOperationFailedException exp : this.shardFailures) {
            exp.writeTo(out);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        RestActions.buildBroadcastShardsHeader(builder, params, this);
        this.addCustomXContentFields(builder, params);
        builder.endObject();
        return builder;
    }

    protected void addCustomXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }
}

