/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.operations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class OperationExtension {
    protected String opID = null;
    protected IConfigurationElement baseElement = null;
    protected String preOperationClass = null;
    protected String postOperationClass = null;
    protected String extensionId;

    public OperationExtension(IConfigurationElement element, String id, String preOp, String postOp) {
        this.baseElement = element;
        this.setUpExtension(id, preOp, postOp);
    }

    private void setUpExtension(String id, String preOp, String postOp) {
        this.opID = id;
        this.preOperationClass = preOp;
        this.postOperationClass = postOp;
        this.extensionId = this.baseElement.getDeclaringExtension().getUniqueIdentifier();
        if (this.extensionId == null) {
            this.extensionId = this.baseElement.getDeclaringExtension().getNamespace();
        }
    }

    public String getOpID() {
        return this.opID;
    }

    public String getPostOperationClass() {
        return this.postOperationClass;
    }

    public String getPreOperationClass() {
        return this.preOperationClass;
    }

    public Object getPostOperation() throws CoreException {
        if (this.postOperationClass == null) {
            return null;
        }
        return this.baseElement.createExecutableExtension("postOperationClass");
    }

    public Object getPreOperation() throws CoreException {
        if (this.preOperationClass == null) {
            return null;
        }
        return this.baseElement.createExecutableExtension("preOperationClass");
    }

    public String getExtensionId() {
        return this.extensionId;
    }

    public IConfigurationElement getBaseElement() {
        return this.baseElement;
    }
}

