/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.uml2sd;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.util.Messages;

public class DrawableToolTip
implements PaintListener {
    private static final int HORIZONTAL_MARGIN = 10;
    private static final int VERTICAL_MARGIN = 10;
    private static final int TEXT_SCALE_MARGIN = 20;
    private static final int SCALE_LENGTH = 100;
    private static final int SHELL_WIDTH = 200;
    private static final int SHELL_HEIGHT = 50;
    private static final int NUMBER_STEPS = 10;
    private static final int BASE_RED_VALUE = 255;
    private static final int BASE_GREEN_BLUE_VALUE = 225;
    private static final int COLOR_STEP = 25;
    private static final int BOUNDS_Y_OFFSET = 26;
    private static final int RECTANGLE_HEIGHT = 11;
    private static final int DEFAULT_LINE_WIDTH = 10;
    private static final int BORDER_LINE_WIDTH = 14;
    private Shell fToolTipShell = null;
    private TmfTimeRange fMinMaxRange;
    private ITmfTimestamp fCurrentValue;
    private static int fHorMargin = 10;
    private static int fVertMargin = 10;
    private static int fTextScaleMargin = 20;
    private static int fScaleLength = 100;
    private String fMessage;
    private Color[] fColors;

    public DrawableToolTip(Composite parent) {
        this.fToolTipShell = new Shell(parent.getShell(), 16384);
        this.fToolTipShell.setLayout((Layout)new RowLayout());
        this.fToolTipShell.setBackground(Display.getDefault().getSystemColor(29));
        this.fToolTipShell.addPaintListener((PaintListener)this);
        this.fToolTipShell.setSize(200, 50);
        this.fToolTipShell.addDisposeListener(e -> {
            int i = 0;
            while (i < this.fColors.length) {
                this.fColors[i].dispose();
                ++i;
            }
        });
        this.fColors = new Color[10];
        int greenBlue = 225;
        int step = 25;
        int i = 0;
        while (i < this.fColors.length) {
            this.fColors[i] = new Color((Device)Display.getDefault(), 255, greenBlue, greenBlue);
            greenBlue -= 25;
            ++i;
        }
    }

    public String getText() {
        return this.fMessage;
    }

    public String getAccessibleText() {
        return this.fCurrentValue.toString();
    }

    protected static int getHorizontalMargin() {
        return fHorMargin;
    }

    protected static void setHorizontalMargin(int margin) {
        fHorMargin = margin;
    }

    protected static int getVerticalMargin() {
        return fVertMargin;
    }

    protected static void setVerticalMargin(int margin) {
        fVertMargin = margin;
    }

    protected static int getTextScaleMargin() {
        return fTextScaleMargin;
    }

    protected static void setTestScaleMargin(int textScaleMargin) {
        fTextScaleMargin = textScaleMargin;
    }

    protected static int getScaleLength() {
        return fScaleLength;
    }

    protected static void setScaleLength(int scaleLength) {
        fScaleLength = scaleLength;
    }

    public void showToolTip(ITmfTimestamp value, ITmfTimestamp min, ITmfTimestamp max) {
        ITmfTimestamp minTime = min;
        ITmfTimestamp maxTime = max;
        if (minTime == null) {
            minTime = TmfTimestamp.BIG_BANG;
        }
        if (maxTime == null) {
            maxTime = TmfTimestamp.BIG_CRUNCH;
        }
        this.fMinMaxRange = new TmfTimeRange(minTime, maxTime);
        this.fCurrentValue = value;
        int w = this.fToolTipShell.getBounds().width;
        int h = this.fToolTipShell.getBounds().height;
        Point hr = Display.getDefault().getCursorLocation();
        this.fToolTipShell.setBounds(hr.x, hr.y + 26, w, h);
        this.fToolTipShell.setVisible(true);
    }

    public void hideToolTip() {
        this.fToolTipShell.setVisible(false);
    }

    public void dispose() {
        this.fToolTipShell.dispose();
    }

    public void paintControl(PaintEvent event) {
        this.fMessage = String.valueOf(Messages.SequenceDiagram_Delta) + " " + this.fCurrentValue.toString();
        Point size = event.gc.textExtent(this.fMessage);
        if (size.x < fScaleLength) {
            size.x = fScaleLength;
        }
        event.gc.drawText(this.fMessage, fHorMargin, fVertMargin, true);
        event.gc.drawLine(fHorMargin, fVertMargin + fTextScaleMargin + size.y, fHorMargin + fScaleLength, fVertMargin + fTextScaleMargin + size.y);
        int step = fScaleLength / 10;
        ITmfTimestamp minMaxdelta = this.fMinMaxRange.getEndTime().getDelta(this.fMinMaxRange.getStartTime());
        double gr = (double)minMaxdelta.getValue() / 10.0;
        ITmfTimestamp delta = this.fCurrentValue.getDelta(this.fMinMaxRange.getStartTime());
        long absDelta = Math.abs(delta.getValue());
        int colIndex = 0;
        if (gr != 0.0) {
            colIndex = Math.round((float)((double)absDelta / gr));
            if (colIndex > this.fColors.length) {
                colIndex = this.fColors.length;
            } else if (colIndex <= 1) {
                colIndex = 1;
            }
        } else {
            colIndex = 1;
        }
        int i = 0;
        while (i <= 10) {
            if (i < 10) {
                event.gc.setBackground(this.fColors[i]);
            }
            if (i < colIndex && i < 10) {
                event.gc.fillRectangle(fHorMargin + i * step, fVertMargin + fTextScaleMargin + size.y - 5, step, 11);
            }
            if (i == 0) {
                event.gc.drawText(Messages.SequenceDiagram_Min, fHorMargin, size.y + 2 * fVertMargin + fTextScaleMargin, true);
            }
            if (i == 0) {
                int len = event.gc.textExtent((String)Messages.SequenceDiagram_Max).x;
                event.gc.drawText(Messages.SequenceDiagram_Max, fHorMargin + fScaleLength - len + 1, size.y + 2 * fVertMargin + fTextScaleMargin, true);
            }
            int lineWidth = 10;
            if (i == 0 || i == 10) {
                lineWidth = 14;
            }
            event.gc.drawLine(fHorMargin + i * step, fVertMargin + fTextScaleMargin + size.y - lineWidth / 2, fHorMargin + i * step, fVertMargin + fTextScaleMargin + size.y + lineWidth / 2);
            ++i;
        }
        this.fToolTipShell.setSize(size.x + 2 * fHorMargin + 2, 2 * size.y + 3 * fVertMargin + fTextScaleMargin);
    }
}

