/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model.timegraph;

import java.util.Collections;
import java.util.List;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;

public class TimeGraphEntryModel
extends TmfTreeDataModel
implements ITimeGraphEntryModel {
    private final long fStartTime;
    private final long fEndTime;
    private final boolean fHasRowModel;

    public TimeGraphEntryModel(long id, long parentId, String name, long startTime, long endTime) {
        this(id, parentId, Collections.singletonList(name), startTime, endTime, true);
    }

    public TimeGraphEntryModel(long id, long parentId, String name, long startTime, long endTime, boolean hasRowModel) {
        this(id, parentId, Collections.singletonList(name), startTime, endTime, hasRowModel);
    }

    public TimeGraphEntryModel(long id, long parentId, List<String> labels, long startTime, long endTime) {
        this(id, parentId, labels, startTime, endTime, true);
    }

    public TimeGraphEntryModel(long id, long parentId, List<String> labels, long startTime, long endTime, boolean hasRowModel) {
        super(id, parentId, labels);
        this.fStartTime = startTime;
        this.fEndTime = endTime;
        this.fHasRowModel = hasRowModel;
    }

    @Override
    public long getStartTime() {
        return this.fStartTime;
    }

    @Override
    public long getEndTime() {
        return this.fEndTime;
    }

    @Override
    public boolean hasRowModel() {
        return this.fHasRowModel;
    }

    @Override
    public String toString() {
        return "<name=" + this.getLabels() + " id=" + this.getId() + " parentId=" + this.getParentId() + " start=" + this.fStartTime + " end=" + this.fEndTime + " hasRowModel=" + this.hasRowModel() + ">";
    }
}

