/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.tools.maintenance;

import java.util.Collection;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleTable;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableIndex;
import org.jkiss.dbeaver.ext.oracle.tools.maintenance.OracleMaintenanceDialog;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.tools.IUserInterfaceTool;

public class OracleToolGatherStatistics
implements IUserInterfaceTool {
    public void execute(IWorkbenchWindow window, IWorkbenchPart activePart, Collection<DBSObject> objects) throws DBException {
        if (!objects.isEmpty()) {
            SQLDialog dialog = new SQLDialog(activePart.getSite(), objects);
            dialog.open();
        }
    }

    static class SQLDialog
    extends OracleMaintenanceDialog<DBSObject> {
        private Spinner samplePercent;

        public SQLDialog(IWorkbenchPartSite partSite, Collection<DBSObject> selectedTables) {
            super(partSite, "Gather statistics", selectedTables);
        }

        protected void generateObjectCommand(List<String> lines, DBSObject object) {
            if (object instanceof OracleTable) {
                OracleTable table = (OracleTable)object;
                String sql = "BEGIN \n DBMS_STATS.GATHER_TABLE_STATS (\n OWNNAME => '" + DBUtils.getQuotedIdentifier((DBSObject)table.getSchema()) + "',\n" + " TABNAME => '" + DBUtils.getQuotedIdentifier((DBSObject)table) + "',\n" + " estimate_percent => " + this.samplePercent.getSelection() + "\n" + " );\n" + "END;";
                lines.add(sql);
            } else if (object instanceof OracleTableIndex) {
                OracleTableIndex index = (OracleTableIndex)object;
                String sql = "ALTER INDEX " + index.getFullyQualifiedName(DBPEvaluationContext.DDL) + " COMPUTE STATISTICS";
                lines.add(sql);
            }
        }

        protected void createControls(Composite parent) {
            Group optionsGroup = UIUtils.createControlGroup((Composite)parent, (String)"Options", (int)1, (int)0, (int)0);
            optionsGroup.setLayoutData((Object)new GridData(768));
            this.samplePercent = UIUtils.createLabelSpinner((Composite)optionsGroup, (String)"Sample Percent", (int)5, (int)0, (int)100);
            this.samplePercent.addSelectionListener(this.SQL_CHANGE_LISTENER);
            this.createObjectsSelector(parent);
        }
    }
}

