/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.struct;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;

public abstract class AbstractObjectReference
implements DBSObjectReference {
    private final String name;
    private final DBSObject container;
    private final String description;
    private final Class<?> objectClass;
    private final DBSObjectType type;

    protected AbstractObjectReference(String name, DBSObject container, String description, Class<?> objectClass, DBSObjectType type) {
        this.name = name;
        this.container = container;
        this.description = description;
        this.objectClass = objectClass;
        this.type = type;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public DBSObject getContainer() {
        return this.container;
    }

    @Override
    public Class<?> getObjectClass() {
        return this.objectClass;
    }

    @Override
    public String getObjectDescription() {
        return this.description;
    }

    @Override
    public DBSObjectType getObjectType() {
        return this.type;
    }

    @Override
    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        DBPDataSource dataSource = this.container.getDataSource();
        if (this.container == dataSource) {
            return DBUtils.getQuotedIdentifier(dataSource, this.name);
        }
        return DBUtils.getFullQualifiedName(dataSource, this.container, this);
    }

    public String toString() {
        return this.getFullyQualifiedName(DBPEvaluationContext.UI);
    }
}

