/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndexColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.ext.generic.model.TableCache;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.utils.CommonUtils;

class IndexCache
extends JDBCCompositeCache<GenericStructContainer, GenericTable, GenericTableIndex, GenericTableIndexColumn> {
    private final GenericMetaObject indexObject;

    IndexCache(TableCache tableCache) {
        super((JDBCStructCache)tableCache, GenericTable.class, GenericUtils.getColumn(tableCache.getDataSource(), "index", "TABLE_NAME"), GenericUtils.getColumn(tableCache.getDataSource(), "index", "INDEX_NAME"));
        this.indexObject = tableCache.getDataSource().getMetaObject("index");
    }

    @NotNull
    protected JDBCStatement prepareObjectsStatement(JDBCSession session, GenericStructContainer owner, GenericTable forParent) throws SQLException {
        try {
            return session.getMetaData().getIndexInfo(owner.getCatalog() == null ? null : owner.getCatalog().getName(), owner.getSchema() == null ? null : owner.getSchema().getName(), forParent == null ? owner.getDataSource().getAllObjectsPattern() : forParent.getName(), false, true).getSourceStatement();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            if (forParent == null) {
                throw new SQLException("Global indexes read not supported", e);
            }
            throw new SQLException(e);
        }
    }

    @Nullable
    protected GenericTableIndex fetchObject(JDBCSession session, GenericStructContainer owner, GenericTable parent, String indexName, JDBCResultSet dbResult) throws SQLException, DBException {
        DBSIndexType indexType;
        boolean isNonUnique = GenericUtils.safeGetBoolean(this.indexObject, (ResultSet)dbResult, "NON_UNIQUE");
        String indexQualifier = GenericUtils.safeGetStringTrimmed(this.indexObject, (ResultSet)dbResult, "INDEX_QUALIFIER");
        long cardinality = GenericUtils.safeGetLong(this.indexObject, (ResultSet)dbResult, "CARDINALITY");
        int indexTypeNum = GenericUtils.safeGetInt(this.indexObject, (ResultSet)dbResult, "TYPE");
        switch (indexTypeNum) {
            case 0: {
                log.debug((Object)("Skip statistics index '" + indexName + "' in '" + DBUtils.getObjectFullName((DBPNamedObject)parent, (DBPEvaluationContext)DBPEvaluationContext.DDL) + "'"));
                return null;
            }
            case 1: {
                indexType = DBSIndexType.CLUSTERED;
                break;
            }
            case 2: {
                indexType = DBSIndexType.HASHED;
                break;
            }
            case 3: {
                indexType = DBSIndexType.OTHER;
                break;
            }
            default: {
                indexType = DBSIndexType.UNKNOWN;
            }
        }
        if (CommonUtils.isEmpty((String)indexName)) {
            indexName = String.valueOf(parent.getName().toUpperCase(Locale.ENGLISH)) + "_INDEX";
        }
        return owner.getDataSource().getMetaModel().createIndexImpl(parent, isNonUnique, indexQualifier, cardinality, indexName, indexType, true);
    }

    @Nullable
    protected GenericTableIndexColumn[] fetchObjectRow(JDBCSession session, GenericTable parent, GenericTableIndex object, JDBCResultSet dbResult) throws SQLException, DBException {
        int ordinalPosition = GenericUtils.safeGetInt(this.indexObject, (ResultSet)dbResult, "ORDINAL_POSITION");
        String columnName = GenericUtils.safeGetStringTrimmed(this.indexObject, (ResultSet)dbResult, "COLUMN_NAME");
        String ascOrDesc = GenericUtils.safeGetStringTrimmed(this.indexObject, (ResultSet)dbResult, "ASC_OR_DESC");
        if (CommonUtils.isEmpty((String)columnName)) {
            return null;
        }
        GenericTableColumn tableColumn = parent.getAttribute(session.getProgressMonitor(), columnName);
        if (tableColumn == null) {
            log.debug((Object)("Column '" + columnName + "' not found in table '" + parent.getName() + "' for index '" + object.getName() + "'"));
            return null;
        }
        return new GenericTableIndexColumn[]{new GenericTableIndexColumn(object, tableColumn, ordinalPosition, !"D".equalsIgnoreCase(ascOrDesc))};
    }

    protected void cacheChildren(DBRProgressMonitor monitor, GenericTableIndex index, List<GenericTableIndexColumn> rows) {
        index.setColumns(rows);
    }
}

