Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _viewUri = require('./view-uri');

var _viewUri2 = _interopRequireDefault(_viewUri);

var REBUILDING = 'rebuilding';
var REBUILD_FAILED = 'rebuild-failed';
var REBUILD_SUCCEEDED = 'rebuild-succeeded';

var IncompatiblePackagesComponent = (function () {
  function IncompatiblePackagesComponent(packageManager) {
    var _this = this;

    _classCallCheck(this, IncompatiblePackagesComponent);

    this.rebuildStatuses = new Map();
    this.rebuildFailureOutputs = new Map();
    this.rebuildInProgress = false;
    this.rebuiltPackageCount = 0;
    this.packageManager = packageManager;
    this.loaded = false;
    _etch2['default'].initialize(this);

    if (this.packageManager.getActivePackages().length > 0) {
      this.populateIncompatiblePackages();
    } else {
      global.setImmediate(this.populateIncompatiblePackages.bind(this));
    }

    this.element.addEventListener('click', function (event) {
      if (event.target === _this.refs.rebuildButton) {
        _this.rebuildIncompatiblePackages();
      } else if (event.target === _this.refs.reloadButton) {
        atom.reload();
      } else if (event.target.classList.contains('view-settings')) {
        atom.workspace.open('atom://config/packages/' + event.target['package'].name);
      }
    });
  }

  _createClass(IncompatiblePackagesComponent, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      if (!this.loaded) {
        return _etch2['default'].dom(
          'div',
          { className: 'incompatible-packages padded' },
          'Loading...'
        );
      }

      return _etch2['default'].dom(
        'div',
        {
          className: 'incompatible-packages padded native-key-bindings',
          tabIndex: '-1'
        },
        this.renderHeading(),
        this.renderIncompatiblePackageList()
      );
    }
  }, {
    key: 'renderHeading',
    value: function renderHeading() {
      if (this.incompatiblePackages.length > 0) {
        if (this.rebuiltPackageCount > 0) {
          var alertClass = this.rebuiltPackageCount === this.incompatiblePackages.length ? 'alert-success icon-check' : 'alert-warning icon-bug';

          return _etch2['default'].dom(
            'div',
            { className: 'alert icon ' + alertClass },
            this.rebuiltPackageCount,
            ' of ',
            this.incompatiblePackages.length,
            ' ',
            'packages were rebuilt successfully. Reload Atom to activate them.',
            _etch2['default'].dom(
              'button',
              { ref: 'reloadButton', className: 'btn pull-right' },
              'Reload Atom'
            )
          );
        } else {
          return _etch2['default'].dom(
            'div',
            { className: 'alert alert-danger icon icon-bug' },
            'Some installed packages could not be loaded because they contain native modules that were compiled for an earlier version of Atom.',
            _etch2['default'].dom(
              'button',
              {
                ref: 'rebuildButton',
                className: 'btn pull-right',
                disabled: this.rebuildInProgress
              },
              'Rebuild Packages'
            )
          );
        }
      } else {
        return _etch2['default'].dom(
          'div',
          { className: 'alert alert-success icon icon-check' },
          'None of your packages contain incompatible native modules.'
        );
      }
    }
  }, {
    key: 'renderIncompatiblePackageList',
    value: function renderIncompatiblePackageList() {
      return _etch2['default'].dom(
        'div',
        null,
        this.incompatiblePackages.map(this.renderIncompatiblePackage.bind(this))
      );
    }
  }, {
    key: 'renderIncompatiblePackage',
    value: function renderIncompatiblePackage(pack) {
      var rebuildStatus = this.rebuildStatuses.get(pack);

      return _etch2['default'].dom(
        'div',
        { className: 'incompatible-package' },
        this.renderRebuildStatusIndicator(rebuildStatus),
        _etch2['default'].dom(
          'button',
          {
            className: 'btn view-settings icon icon-gear pull-right',
            'package': pack
          },
          'Package Settings'
        ),
        _etch2['default'].dom(
          'h4',
          { className: 'heading' },
          pack.name,
          ' ',
          pack.metadata.version
        ),
        rebuildStatus ? this.renderRebuildOutput(pack) : this.renderIncompatibleModules(pack)
      );
    }
  }, {
    key: 'renderRebuildStatusIndicator',
    value: function renderRebuildStatusIndicator(rebuildStatus) {
      if (rebuildStatus === REBUILDING) {
        return _etch2['default'].dom(
          'div',
          { className: 'badge badge-info pull-right icon icon-gear' },
          'Rebuilding'
        );
      } else if (rebuildStatus === REBUILD_SUCCEEDED) {
        return _etch2['default'].dom(
          'div',
          { className: 'badge badge-success pull-right icon icon-check' },
          'Rebuild Succeeded'
        );
      } else if (rebuildStatus === REBUILD_FAILED) {
        return _etch2['default'].dom(
          'div',
          { className: 'badge badge-error pull-right icon icon-x' },
          'Rebuild Failed'
        );
      } else {
        return '';
      }
    }
  }, {
    key: 'renderRebuildOutput',
    value: function renderRebuildOutput(pack) {
      if (this.rebuildStatuses.get(pack) === REBUILD_FAILED) {
        return _etch2['default'].dom(
          'pre',
          null,
          this.rebuildFailureOutputs.get(pack)
        );
      } else {
        return '';
      }
    }
  }, {
    key: 'renderIncompatibleModules',
    value: function renderIncompatibleModules(pack) {
      return _etch2['default'].dom(
        'ul',
        null,
        pack.incompatibleModules.map(function (nativeModule) {
          return _etch2['default'].dom(
            'li',
            null,
            _etch2['default'].dom(
              'div',
              { className: 'icon icon-file-binary' },
              nativeModule.name,
              '@',
              nativeModule.version || 'unknown',
              ' –',
              ' ',
              _etch2['default'].dom(
                'span',
                { className: 'text-warning' },
                nativeModule.error
              )
            )
          );
        })
      );
    }
  }, {
    key: 'populateIncompatiblePackages',
    value: function populateIncompatiblePackages() {
      this.incompatiblePackages = this.packageManager.getLoadedPackages().filter(function (pack) {
        return !pack.isCompatible();
      });

      for (var pack of this.incompatiblePackages) {
        var buildFailureOutput = pack.getBuildFailureOutput();
        if (buildFailureOutput) {
          this.setPackageStatus(pack, REBUILD_FAILED);
          this.setRebuildFailureOutput(pack, buildFailureOutput);
        }
      }

      this.loaded = true;
      _etch2['default'].update(this);
    }
  }, {
    key: 'rebuildIncompatiblePackages',
    value: _asyncToGenerator(function* () {
      this.rebuildInProgress = true;
      var rebuiltPackageCount = 0;
      for (var pack of this.incompatiblePackages) {
        this.setPackageStatus(pack, REBUILDING);

        var _ref = yield pack.rebuild();

        var code = _ref.code;
        var stderr = _ref.stderr;

        if (code === 0) {
          this.setPackageStatus(pack, REBUILD_SUCCEEDED);
          rebuiltPackageCount++;
        } else {
          this.setRebuildFailureOutput(pack, stderr);
          this.setPackageStatus(pack, REBUILD_FAILED);
        }
      }
      this.rebuildInProgress = false;
      this.rebuiltPackageCount = rebuiltPackageCount;
      _etch2['default'].update(this);
    })
  }, {
    key: 'setPackageStatus',
    value: function setPackageStatus(pack, status) {
      this.rebuildStatuses.set(pack, status);
      _etch2['default'].update(this);
    }
  }, {
    key: 'setRebuildFailureOutput',
    value: function setRebuildFailureOutput(pack, output) {
      this.rebuildFailureOutputs.set(pack, output);
      _etch2['default'].update(this);
    }
  }, {
    key: 'getTitle',
    value: function getTitle() {
      return 'Incompatible Packages';
    }
  }, {
    key: 'getURI',
    value: function getURI() {
      return _viewUri2['default'];
    }
  }, {
    key: 'getIconName',
    value: function getIconName() {
      return 'package';
    }
  }, {
    key: 'serialize',
    value: function serialize() {
      return { deserializer: 'IncompatiblePackagesComponent' };
    }
  }]);

  return IncompatiblePackagesComponent;
})();

exports['default'] = IncompatiblePackagesComponent;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzguMi9vdXQvYXBwL25vZGVfbW9kdWxlcy9pbmNvbXBhdGlibGUtcGFja2FnZXMvbGliL2luY29tcGF0aWJsZS1wYWNrYWdlcy1jb21wb25lbnQuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7O29CQUdpQixNQUFNOzs7O3VCQUVGLFlBQVk7Ozs7QUFDakMsSUFBTSxVQUFVLEdBQUcsWUFBWSxDQUFBO0FBQy9CLElBQU0sY0FBYyxHQUFHLGdCQUFnQixDQUFBO0FBQ3ZDLElBQU0saUJBQWlCLEdBQUcsbUJBQW1CLENBQUE7O0lBRXhCLDZCQUE2QjtBQUNwQyxXQURPLDZCQUE2QixDQUNuQyxjQUFjLEVBQUU7OzswQkFEViw2QkFBNkI7O0FBRTlDLFFBQUksQ0FBQyxlQUFlLEdBQUcsSUFBSSxHQUFHLEVBQUUsQ0FBQTtBQUNoQyxRQUFJLENBQUMscUJBQXFCLEdBQUcsSUFBSSxHQUFHLEVBQUUsQ0FBQTtBQUN0QyxRQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFBO0FBQzlCLFFBQUksQ0FBQyxtQkFBbUIsR0FBRyxDQUFDLENBQUE7QUFDNUIsUUFBSSxDQUFDLGNBQWMsR0FBRyxjQUFjLENBQUE7QUFDcEMsUUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUE7QUFDbkIsc0JBQUssVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFBOztBQUVyQixRQUFJLElBQUksQ0FBQyxjQUFjLENBQUMsaUJBQWlCLEVBQUUsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFO0FBQ3RELFVBQUksQ0FBQyw0QkFBNEIsRUFBRSxDQUFBO0tBQ3BDLE1BQU07QUFDTCxZQUFNLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyw0QkFBNEIsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQTtLQUNsRTs7QUFFRCxRQUFJLENBQUMsT0FBTyxDQUFDLGdCQUFnQixDQUFDLE9BQU8sRUFBRSxVQUFBLEtBQUssRUFBSTtBQUM5QyxVQUFJLEtBQUssQ0FBQyxNQUFNLEtBQUssTUFBSyxJQUFJLENBQUMsYUFBYSxFQUFFO0FBQzVDLGNBQUssMkJBQTJCLEVBQUUsQ0FBQTtPQUNuQyxNQUFNLElBQUksS0FBSyxDQUFDLE1BQU0sS0FBSyxNQUFLLElBQUksQ0FBQyxZQUFZLEVBQUU7QUFDbEQsWUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFBO09BQ2QsTUFBTSxJQUFJLEtBQUssQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDLFFBQVEsQ0FBQyxlQUFlLENBQUMsRUFBRTtBQUMzRCxZQUFJLENBQUMsU0FBUyxDQUFDLElBQUksNkJBQ1MsS0FBSyxDQUFDLE1BQU0sV0FBUSxDQUFDLElBQUksQ0FDcEQsQ0FBQTtPQUNGO0tBQ0YsQ0FBQyxDQUFBO0dBQ0g7O2VBM0JrQiw2QkFBNkI7O1dBNkJ6QyxrQkFBRyxFQUFFOzs7V0FFTCxrQkFBRztBQUNSLFVBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFO0FBQ2hCLGVBQU87O1lBQUssU0FBUyxFQUFDLDhCQUE4Qjs7U0FBaUIsQ0FBQTtPQUN0RTs7QUFFRCxhQUNFOzs7QUFDRSxtQkFBUyxFQUFDLGtEQUFrRDtBQUM1RCxrQkFBUSxFQUFDLElBQUk7O1FBRVosSUFBSSxDQUFDLGFBQWEsRUFBRTtRQUNwQixJQUFJLENBQUMsNkJBQTZCLEVBQUU7T0FDakMsQ0FDUDtLQUNGOzs7V0FFYSx5QkFBRztBQUNmLFVBQUksSUFBSSxDQUFDLG9CQUFvQixDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUU7QUFDeEMsWUFBSSxJQUFJLENBQUMsbUJBQW1CLEdBQUcsQ0FBQyxFQUFFO0FBQ2hDLGNBQUksVUFBVSxHQUNaLElBQUksQ0FBQyxtQkFBbUIsS0FBSyxJQUFJLENBQUMsb0JBQW9CLENBQUMsTUFBTSxHQUN6RCwwQkFBMEIsR0FDMUIsd0JBQXdCLENBQUE7O0FBRTlCLGlCQUNFOztjQUFLLFNBQVMsRUFBRSxhQUFhLEdBQUcsVUFBVSxBQUFDO1lBQ3hDLElBQUksQ0FBQyxtQkFBbUI7O1lBQU0sSUFBSSxDQUFDLG9CQUFvQixDQUFDLE1BQU07WUFBRSxHQUFHOztZQUVwRTs7Z0JBQVEsR0FBRyxFQUFDLGNBQWMsRUFBQyxTQUFTLEVBQUMsZ0JBQWdCOzthQUU1QztXQUNMLENBQ1A7U0FDRixNQUFNO0FBQ0wsaUJBQ0U7O2NBQUssU0FBUyxFQUFDLGtDQUFrQzs7WUFHL0M7OztBQUNFLG1CQUFHLEVBQUMsZUFBZTtBQUNuQix5QkFBUyxFQUFDLGdCQUFnQjtBQUMxQix3QkFBUSxFQUFFLElBQUksQ0FBQyxpQkFBaUIsQUFBQzs7O2FBRzFCO1dBQ0wsQ0FDUDtTQUNGO09BQ0YsTUFBTTtBQUNMLGVBQ0U7O1lBQUssU0FBUyxFQUFDLHFDQUFxQzs7U0FFOUMsQ0FDUDtPQUNGO0tBQ0Y7OztXQUU2Qix5Q0FBRztBQUMvQixhQUNFOzs7UUFDRyxJQUFJLENBQUMsb0JBQW9CLENBQUMsR0FBRyxDQUM1QixJQUFJLENBQUMseUJBQXlCLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUMxQztPQUNHLENBQ1A7S0FDRjs7O1dBRXlCLG1DQUFDLElBQUksRUFBRTtBQUMvQixVQUFJLGFBQWEsR0FBRyxJQUFJLENBQUMsZUFBZSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsQ0FBQTs7QUFFbEQsYUFDRTs7VUFBSyxTQUFTLEVBQUUsc0JBQXNCLEFBQUM7UUFDcEMsSUFBSSxDQUFDLDRCQUE0QixDQUFDLGFBQWEsQ0FBQztRQUNqRDs7O0FBQ0UscUJBQVMsRUFBQyw2Q0FBNkM7QUFDdkQsdUJBQVMsSUFBSSxBQUFDOzs7U0FHUDtRQUNUOztZQUFJLFNBQVMsRUFBQyxTQUFTO1VBQ3BCLElBQUksQ0FBQyxJQUFJOztVQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsT0FBTztTQUMvQjtRQUNKLGFBQWEsR0FDVixJQUFJLENBQUMsbUJBQW1CLENBQUMsSUFBSSxDQUFDLEdBQzlCLElBQUksQ0FBQyx5QkFBeUIsQ0FBQyxJQUFJLENBQUM7T0FDcEMsQ0FDUDtLQUNGOzs7V0FFNEIsc0NBQUMsYUFBYSxFQUFFO0FBQzNDLFVBQUksYUFBYSxLQUFLLFVBQVUsRUFBRTtBQUNoQyxlQUNFOztZQUFLLFNBQVMsRUFBQyw0Q0FBNEM7O1NBRXJELENBQ1A7T0FDRixNQUFNLElBQUksYUFBYSxLQUFLLGlCQUFpQixFQUFFO0FBQzlDLGVBQ0U7O1lBQUssU0FBUyxFQUFDLGdEQUFnRDs7U0FFekQsQ0FDUDtPQUNGLE1BQU0sSUFBSSxhQUFhLEtBQUssY0FBYyxFQUFFO0FBQzNDLGVBQ0U7O1lBQUssU0FBUyxFQUFDLDBDQUEwQzs7U0FFbkQsQ0FDUDtPQUNGLE1BQU07QUFDTCxlQUFPLEVBQUUsQ0FBQTtPQUNWO0tBQ0Y7OztXQUVtQiw2QkFBQyxJQUFJLEVBQUU7QUFDekIsVUFBSSxJQUFJLENBQUMsZUFBZSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsS0FBSyxjQUFjLEVBQUU7QUFDckQsZUFBTzs7O1VBQU0sSUFBSSxDQUFDLHFCQUFxQixDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUM7U0FBTyxDQUFBO09BQ3pELE1BQU07QUFDTCxlQUFPLEVBQUUsQ0FBQTtPQUNWO0tBQ0Y7OztXQUV5QixtQ0FBQyxJQUFJLEVBQUU7QUFDL0IsYUFDRTs7O1FBQ0csSUFBSSxDQUFDLG1CQUFtQixDQUFDLEdBQUcsQ0FBQyxVQUFBLFlBQVk7aUJBQ3hDOzs7WUFDRTs7Z0JBQUssU0FBUyxFQUFDLHVCQUF1QjtjQUNuQyxZQUFZLENBQUMsSUFBSTs7Y0FBRyxZQUFZLENBQUMsT0FBTyxJQUFJLFNBQVM7O2NBQUksR0FBRztjQUM3RDs7a0JBQU0sU0FBUyxFQUFDLGNBQWM7Z0JBQUUsWUFBWSxDQUFDLEtBQUs7ZUFBUTthQUN0RDtXQUNIO1NBQ04sQ0FBQztPQUNDLENBQ047S0FDRjs7O1dBRTRCLHdDQUFHO0FBQzlCLFVBQUksQ0FBQyxvQkFBb0IsR0FBRyxJQUFJLENBQUMsY0FBYyxDQUM1QyxpQkFBaUIsRUFBRSxDQUNuQixNQUFNLENBQUMsVUFBQSxJQUFJO2VBQUksQ0FBQyxJQUFJLENBQUMsWUFBWSxFQUFFO09BQUEsQ0FBQyxDQUFBOztBQUV2QyxXQUFLLElBQUksSUFBSSxJQUFJLElBQUksQ0FBQyxvQkFBb0IsRUFBRTtBQUMxQyxZQUFJLGtCQUFrQixHQUFHLElBQUksQ0FBQyxxQkFBcUIsRUFBRSxDQUFBO0FBQ3JELFlBQUksa0JBQWtCLEVBQUU7QUFDdEIsY0FBSSxDQUFDLGdCQUFnQixDQUFDLElBQUksRUFBRSxjQUFjLENBQUMsQ0FBQTtBQUMzQyxjQUFJLENBQUMsdUJBQXVCLENBQUMsSUFBSSxFQUFFLGtCQUFrQixDQUFDLENBQUE7U0FDdkQ7T0FDRjs7QUFFRCxVQUFJLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQTtBQUNsQix3QkFBSyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUE7S0FDbEI7Ozs2QkFFaUMsYUFBRztBQUNuQyxVQUFJLENBQUMsaUJBQWlCLEdBQUcsSUFBSSxDQUFBO0FBQzdCLFVBQUksbUJBQW1CLEdBQUcsQ0FBQyxDQUFBO0FBQzNCLFdBQUssSUFBSSxJQUFJLElBQUksSUFBSSxDQUFDLG9CQUFvQixFQUFFO0FBQzFDLFlBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLEVBQUUsVUFBVSxDQUFDLENBQUE7O21CQUNoQixNQUFNLElBQUksQ0FBQyxPQUFPLEVBQUU7O1lBQXJDLElBQUksUUFBSixJQUFJO1lBQUUsTUFBTSxRQUFOLE1BQU07O0FBQ2xCLFlBQUksSUFBSSxLQUFLLENBQUMsRUFBRTtBQUNkLGNBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLEVBQUUsaUJBQWlCLENBQUMsQ0FBQTtBQUM5Qyw2QkFBbUIsRUFBRSxDQUFBO1NBQ3RCLE1BQU07QUFDTCxjQUFJLENBQUMsdUJBQXVCLENBQUMsSUFBSSxFQUFFLE1BQU0sQ0FBQyxDQUFBO0FBQzFDLGNBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLEVBQUUsY0FBYyxDQUFDLENBQUE7U0FDNUM7T0FDRjtBQUNELFVBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUE7QUFDOUIsVUFBSSxDQUFDLG1CQUFtQixHQUFHLG1CQUFtQixDQUFBO0FBQzlDLHdCQUFLLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQTtLQUNsQjs7O1dBRWdCLDBCQUFDLElBQUksRUFBRSxNQUFNLEVBQUU7QUFDOUIsVUFBSSxDQUFDLGVBQWUsQ0FBQyxHQUFHLENBQUMsSUFBSSxFQUFFLE1BQU0sQ0FBQyxDQUFBO0FBQ3RDLHdCQUFLLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQTtLQUNsQjs7O1dBRXVCLGlDQUFDLElBQUksRUFBRSxNQUFNLEVBQUU7QUFDckMsVUFBSSxDQUFDLHFCQUFxQixDQUFDLEdBQUcsQ0FBQyxJQUFJLEVBQUUsTUFBTSxDQUFDLENBQUE7QUFDNUMsd0JBQUssTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFBO0tBQ2xCOzs7V0FFUSxvQkFBRztBQUNWLGFBQU8sdUJBQXVCLENBQUE7S0FDL0I7OztXQUVNLGtCQUFHO0FBQ1Isa0NBQWU7S0FDaEI7OztXQUVXLHVCQUFHO0FBQ2IsYUFBTyxTQUFTLENBQUE7S0FDakI7OztXQUVTLHFCQUFHO0FBQ1gsYUFBTyxFQUFFLFlBQVksRUFBRSwrQkFBK0IsRUFBRSxDQUFBO0tBQ3pEOzs7U0FuT2tCLDZCQUE2Qjs7O3FCQUE3Qiw2QkFBNkIiLCJmaWxlIjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zOC4yL291dC9hcHAvbm9kZV9tb2R1bGVzL2luY29tcGF0aWJsZS1wYWNrYWdlcy9saWIvaW5jb21wYXRpYmxlLXBhY2thZ2VzLWNvbXBvbmVudC5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8qKiBAYmFiZWwgKi9cbi8qKiBAanN4IGV0Y2guZG9tICovXG5cbmltcG9ydCBldGNoIGZyb20gJ2V0Y2gnXG5cbmltcG9ydCBWSUVXX1VSSSBmcm9tICcuL3ZpZXctdXJpJ1xuY29uc3QgUkVCVUlMRElORyA9ICdyZWJ1aWxkaW5nJ1xuY29uc3QgUkVCVUlMRF9GQUlMRUQgPSAncmVidWlsZC1mYWlsZWQnXG5jb25zdCBSRUJVSUxEX1NVQ0NFRURFRCA9ICdyZWJ1aWxkLXN1Y2NlZWRlZCdcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgSW5jb21wYXRpYmxlUGFja2FnZXNDb21wb25lbnQge1xuICBjb25zdHJ1Y3RvciAocGFja2FnZU1hbmFnZXIpIHtcbiAgICB0aGlzLnJlYnVpbGRTdGF0dXNlcyA9IG5ldyBNYXAoKVxuICAgIHRoaXMucmVidWlsZEZhaWx1cmVPdXRwdXRzID0gbmV3IE1hcCgpXG4gICAgdGhpcy5yZWJ1aWxkSW5Qcm9ncmVzcyA9IGZhbHNlXG4gICAgdGhpcy5yZWJ1aWx0UGFja2FnZUNvdW50ID0gMFxuICAgIHRoaXMucGFja2FnZU1hbmFnZXIgPSBwYWNrYWdlTWFuYWdlclxuICAgIHRoaXMubG9hZGVkID0gZmFsc2VcbiAgICBldGNoLmluaXRpYWxpemUodGhpcylcblxuICAgIGlmICh0aGlzLnBhY2thZ2VNYW5hZ2VyLmdldEFjdGl2ZVBhY2thZ2VzKCkubGVuZ3RoID4gMCkge1xuICAgICAgdGhpcy5wb3B1bGF0ZUluY29tcGF0aWJsZVBhY2thZ2VzKClcbiAgICB9IGVsc2Uge1xuICAgICAgZ2xvYmFsLnNldEltbWVkaWF0ZSh0aGlzLnBvcHVsYXRlSW5jb21wYXRpYmxlUGFja2FnZXMuYmluZCh0aGlzKSlcbiAgICB9XG5cbiAgICB0aGlzLmVsZW1lbnQuYWRkRXZlbnRMaXN0ZW5lcignY2xpY2snLCBldmVudCA9PiB7XG4gICAgICBpZiAoZXZlbnQudGFyZ2V0ID09PSB0aGlzLnJlZnMucmVidWlsZEJ1dHRvbikge1xuICAgICAgICB0aGlzLnJlYnVpbGRJbmNvbXBhdGlibGVQYWNrYWdlcygpXG4gICAgICB9IGVsc2UgaWYgKGV2ZW50LnRhcmdldCA9PT0gdGhpcy5yZWZzLnJlbG9hZEJ1dHRvbikge1xuICAgICAgICBhdG9tLnJlbG9hZCgpXG4gICAgICB9IGVsc2UgaWYgKGV2ZW50LnRhcmdldC5jbGFzc0xpc3QuY29udGFpbnMoJ3ZpZXctc2V0dGluZ3MnKSkge1xuICAgICAgICBhdG9tLndvcmtzcGFjZS5vcGVuKFxuICAgICAgICAgIGBhdG9tOi8vY29uZmlnL3BhY2thZ2VzLyR7ZXZlbnQudGFyZ2V0LnBhY2thZ2UubmFtZX1gXG4gICAgICAgIClcbiAgICAgIH1cbiAgICB9KVxuICB9XG5cbiAgdXBkYXRlICgpIHt9XG5cbiAgcmVuZGVyICgpIHtcbiAgICBpZiAoIXRoaXMubG9hZGVkKSB7XG4gICAgICByZXR1cm4gPGRpdiBjbGFzc05hbWU9J2luY29tcGF0aWJsZS1wYWNrYWdlcyBwYWRkZWQnPkxvYWRpbmcuLi48L2Rpdj5cbiAgICB9XG5cbiAgICByZXR1cm4gKFxuICAgICAgPGRpdlxuICAgICAgICBjbGFzc05hbWU9J2luY29tcGF0aWJsZS1wYWNrYWdlcyBwYWRkZWQgbmF0aXZlLWtleS1iaW5kaW5ncydcbiAgICAgICAgdGFiSW5kZXg9Jy0xJ1xuICAgICAgPlxuICAgICAgICB7dGhpcy5yZW5kZXJIZWFkaW5nKCl9XG4gICAgICAgIHt0aGlzLnJlbmRlckluY29tcGF0aWJsZVBhY2thZ2VMaXN0KCl9XG4gICAgICA8L2Rpdj5cbiAgICApXG4gIH1cblxuICByZW5kZXJIZWFkaW5nICgpIHtcbiAgICBpZiAodGhpcy5pbmNvbXBhdGlibGVQYWNrYWdlcy5sZW5ndGggPiAwKSB7XG4gICAgICBpZiAodGhpcy5yZWJ1aWx0UGFja2FnZUNvdW50ID4gMCkge1xuICAgICAgICBsZXQgYWxlcnRDbGFzcyA9XG4gICAgICAgICAgdGhpcy5yZWJ1aWx0UGFja2FnZUNvdW50ID09PSB0aGlzLmluY29tcGF0aWJsZVBhY2thZ2VzLmxlbmd0aFxuICAgICAgICAgICAgPyAnYWxlcnQtc3VjY2VzcyBpY29uLWNoZWNrJ1xuICAgICAgICAgICAgOiAnYWxlcnQtd2FybmluZyBpY29uLWJ1ZydcblxuICAgICAgICByZXR1cm4gKFxuICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPXsnYWxlcnQgaWNvbiAnICsgYWxlcnRDbGFzc30+XG4gICAgICAgICAgICB7dGhpcy5yZWJ1aWx0UGFja2FnZUNvdW50fSBvZiB7dGhpcy5pbmNvbXBhdGlibGVQYWNrYWdlcy5sZW5ndGh9eycgJ31cbiAgICAgICAgICAgIHBhY2thZ2VzIHdlcmUgcmVidWlsdCBzdWNjZXNzZnVsbHkuIFJlbG9hZCBBdG9tIHRvIGFjdGl2YXRlIHRoZW0uXG4gICAgICAgICAgICA8YnV0dG9uIHJlZj0ncmVsb2FkQnV0dG9uJyBjbGFzc05hbWU9J2J0biBwdWxsLXJpZ2h0Jz5cbiAgICAgICAgICAgICAgUmVsb2FkIEF0b21cbiAgICAgICAgICAgIDwvYnV0dG9uPlxuICAgICAgICAgIDwvZGl2PlxuICAgICAgICApXG4gICAgICB9IGVsc2Uge1xuICAgICAgICByZXR1cm4gKFxuICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPSdhbGVydCBhbGVydC1kYW5nZXIgaWNvbiBpY29uLWJ1Zyc+XG4gICAgICAgICAgICBTb21lIGluc3RhbGxlZCBwYWNrYWdlcyBjb3VsZCBub3QgYmUgbG9hZGVkIGJlY2F1c2UgdGhleSBjb250YWluXG4gICAgICAgICAgICBuYXRpdmUgbW9kdWxlcyB0aGF0IHdlcmUgY29tcGlsZWQgZm9yIGFuIGVhcmxpZXIgdmVyc2lvbiBvZiBBdG9tLlxuICAgICAgICAgICAgPGJ1dHRvblxuICAgICAgICAgICAgICByZWY9J3JlYnVpbGRCdXR0b24nXG4gICAgICAgICAgICAgIGNsYXNzTmFtZT0nYnRuIHB1bGwtcmlnaHQnXG4gICAgICAgICAgICAgIGRpc2FibGVkPXt0aGlzLnJlYnVpbGRJblByb2dyZXNzfVxuICAgICAgICAgICAgPlxuICAgICAgICAgICAgICBSZWJ1aWxkIFBhY2thZ2VzXG4gICAgICAgICAgICA8L2J1dHRvbj5cbiAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgKVxuICAgICAgfVxuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gKFxuICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nYWxlcnQgYWxlcnQtc3VjY2VzcyBpY29uIGljb24tY2hlY2snPlxuICAgICAgICAgIE5vbmUgb2YgeW91ciBwYWNrYWdlcyBjb250YWluIGluY29tcGF0aWJsZSBuYXRpdmUgbW9kdWxlcy5cbiAgICAgICAgPC9kaXY+XG4gICAgICApXG4gICAgfVxuICB9XG5cbiAgcmVuZGVySW5jb21wYXRpYmxlUGFja2FnZUxpc3QgKCkge1xuICAgIHJldHVybiAoXG4gICAgICA8ZGl2PlxuICAgICAgICB7dGhpcy5pbmNvbXBhdGlibGVQYWNrYWdlcy5tYXAoXG4gICAgICAgICAgdGhpcy5yZW5kZXJJbmNvbXBhdGlibGVQYWNrYWdlLmJpbmQodGhpcylcbiAgICAgICAgKX1cbiAgICAgIDwvZGl2PlxuICAgIClcbiAgfVxuXG4gIHJlbmRlckluY29tcGF0aWJsZVBhY2thZ2UgKHBhY2spIHtcbiAgICBsZXQgcmVidWlsZFN0YXR1cyA9IHRoaXMucmVidWlsZFN0YXR1c2VzLmdldChwYWNrKVxuXG4gICAgcmV0dXJuIChcbiAgICAgIDxkaXYgY2xhc3NOYW1lPXsnaW5jb21wYXRpYmxlLXBhY2thZ2UnfT5cbiAgICAgICAge3RoaXMucmVuZGVyUmVidWlsZFN0YXR1c0luZGljYXRvcihyZWJ1aWxkU3RhdHVzKX1cbiAgICAgICAgPGJ1dHRvblxuICAgICAgICAgIGNsYXNzTmFtZT0nYnRuIHZpZXctc2V0dGluZ3MgaWNvbiBpY29uLWdlYXIgcHVsbC1yaWdodCdcbiAgICAgICAgICBwYWNrYWdlPXtwYWNrfVxuICAgICAgICA+XG4gICAgICAgICAgUGFja2FnZSBTZXR0aW5nc1xuICAgICAgICA8L2J1dHRvbj5cbiAgICAgICAgPGg0IGNsYXNzTmFtZT0naGVhZGluZyc+XG4gICAgICAgICAge3BhY2submFtZX0ge3BhY2subWV0YWRhdGEudmVyc2lvbn1cbiAgICAgICAgPC9oND5cbiAgICAgICAge3JlYnVpbGRTdGF0dXNcbiAgICAgICAgICA/IHRoaXMucmVuZGVyUmVidWlsZE91dHB1dChwYWNrKVxuICAgICAgICAgIDogdGhpcy5yZW5kZXJJbmNvbXBhdGlibGVNb2R1bGVzKHBhY2spfVxuICAgICAgPC9kaXY+XG4gICAgKVxuICB9XG5cbiAgcmVuZGVyUmVidWlsZFN0YXR1c0luZGljYXRvciAocmVidWlsZFN0YXR1cykge1xuICAgIGlmIChyZWJ1aWxkU3RhdHVzID09PSBSRUJVSUxESU5HKSB7XG4gICAgICByZXR1cm4gKFxuICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nYmFkZ2UgYmFkZ2UtaW5mbyBwdWxsLXJpZ2h0IGljb24gaWNvbi1nZWFyJz5cbiAgICAgICAgICBSZWJ1aWxkaW5nXG4gICAgICAgIDwvZGl2PlxuICAgICAgKVxuICAgIH0gZWxzZSBpZiAocmVidWlsZFN0YXR1cyA9PT0gUkVCVUlMRF9TVUNDRUVERUQpIHtcbiAgICAgIHJldHVybiAoXG4gICAgICAgIDxkaXYgY2xhc3NOYW1lPSdiYWRnZSBiYWRnZS1zdWNjZXNzIHB1bGwtcmlnaHQgaWNvbiBpY29uLWNoZWNrJz5cbiAgICAgICAgICBSZWJ1aWxkIFN1Y2NlZWRlZFxuICAgICAgICA8L2Rpdj5cbiAgICAgIClcbiAgICB9IGVsc2UgaWYgKHJlYnVpbGRTdGF0dXMgPT09IFJFQlVJTERfRkFJTEVEKSB7XG4gICAgICByZXR1cm4gKFxuICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nYmFkZ2UgYmFkZ2UtZXJyb3IgcHVsbC1yaWdodCBpY29uIGljb24teCc+XG4gICAgICAgICAgUmVidWlsZCBGYWlsZWRcbiAgICAgICAgPC9kaXY+XG4gICAgICApXG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiAnJ1xuICAgIH1cbiAgfVxuXG4gIHJlbmRlclJlYnVpbGRPdXRwdXQgKHBhY2spIHtcbiAgICBpZiAodGhpcy5yZWJ1aWxkU3RhdHVzZXMuZ2V0KHBhY2spID09PSBSRUJVSUxEX0ZBSUxFRCkge1xuICAgICAgcmV0dXJuIDxwcmU+e3RoaXMucmVidWlsZEZhaWx1cmVPdXRwdXRzLmdldChwYWNrKX08L3ByZT5cbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuICcnXG4gICAgfVxuICB9XG5cbiAgcmVuZGVySW5jb21wYXRpYmxlTW9kdWxlcyAocGFjaykge1xuICAgIHJldHVybiAoXG4gICAgICA8dWw+XG4gICAgICAgIHtwYWNrLmluY29tcGF0aWJsZU1vZHVsZXMubWFwKG5hdGl2ZU1vZHVsZSA9PiAoXG4gICAgICAgICAgPGxpPlxuICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9J2ljb24gaWNvbi1maWxlLWJpbmFyeSc+XG4gICAgICAgICAgICAgIHtuYXRpdmVNb2R1bGUubmFtZX1Ae25hdGl2ZU1vZHVsZS52ZXJzaW9uIHx8ICd1bmtub3duJ30g4oCTeycgJ31cbiAgICAgICAgICAgICAgPHNwYW4gY2xhc3NOYW1lPSd0ZXh0LXdhcm5pbmcnPntuYXRpdmVNb2R1bGUuZXJyb3J9PC9zcGFuPlxuICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgPC9saT5cbiAgICAgICAgKSl9XG4gICAgICA8L3VsPlxuICAgIClcbiAgfVxuXG4gIHBvcHVsYXRlSW5jb21wYXRpYmxlUGFja2FnZXMgKCkge1xuICAgIHRoaXMuaW5jb21wYXRpYmxlUGFja2FnZXMgPSB0aGlzLnBhY2thZ2VNYW5hZ2VyXG4gICAgICAuZ2V0TG9hZGVkUGFja2FnZXMoKVxuICAgICAgLmZpbHRlcihwYWNrID0+ICFwYWNrLmlzQ29tcGF0aWJsZSgpKVxuXG4gICAgZm9yIChsZXQgcGFjayBvZiB0aGlzLmluY29tcGF0aWJsZVBhY2thZ2VzKSB7XG4gICAgICBsZXQgYnVpbGRGYWlsdXJlT3V0cHV0ID0gcGFjay5nZXRCdWlsZEZhaWx1cmVPdXRwdXQoKVxuICAgICAgaWYgKGJ1aWxkRmFpbHVyZU91dHB1dCkge1xuICAgICAgICB0aGlzLnNldFBhY2thZ2VTdGF0dXMocGFjaywgUkVCVUlMRF9GQUlMRUQpXG4gICAgICAgIHRoaXMuc2V0UmVidWlsZEZhaWx1cmVPdXRwdXQocGFjaywgYnVpbGRGYWlsdXJlT3V0cHV0KVxuICAgICAgfVxuICAgIH1cblxuICAgIHRoaXMubG9hZGVkID0gdHJ1ZVxuICAgIGV0Y2gudXBkYXRlKHRoaXMpXG4gIH1cblxuICBhc3luYyByZWJ1aWxkSW5jb21wYXRpYmxlUGFja2FnZXMgKCkge1xuICAgIHRoaXMucmVidWlsZEluUHJvZ3Jlc3MgPSB0cnVlXG4gICAgbGV0IHJlYnVpbHRQYWNrYWdlQ291bnQgPSAwXG4gICAgZm9yIChsZXQgcGFjayBvZiB0aGlzLmluY29tcGF0aWJsZVBhY2thZ2VzKSB7XG4gICAgICB0aGlzLnNldFBhY2thZ2VTdGF0dXMocGFjaywgUkVCVUlMRElORylcbiAgICAgIGxldCB7IGNvZGUsIHN0ZGVyciB9ID0gYXdhaXQgcGFjay5yZWJ1aWxkKClcbiAgICAgIGlmIChjb2RlID09PSAwKSB7XG4gICAgICAgIHRoaXMuc2V0UGFja2FnZVN0YXR1cyhwYWNrLCBSRUJVSUxEX1NVQ0NFRURFRClcbiAgICAgICAgcmVidWlsdFBhY2thZ2VDb3VudCsrXG4gICAgICB9IGVsc2Uge1xuICAgICAgICB0aGlzLnNldFJlYnVpbGRGYWlsdXJlT3V0cHV0KHBhY2ssIHN0ZGVycilcbiAgICAgICAgdGhpcy5zZXRQYWNrYWdlU3RhdHVzKHBhY2ssIFJFQlVJTERfRkFJTEVEKVxuICAgICAgfVxuICAgIH1cbiAgICB0aGlzLnJlYnVpbGRJblByb2dyZXNzID0gZmFsc2VcbiAgICB0aGlzLnJlYnVpbHRQYWNrYWdlQ291bnQgPSByZWJ1aWx0UGFja2FnZUNvdW50XG4gICAgZXRjaC51cGRhdGUodGhpcylcbiAgfVxuXG4gIHNldFBhY2thZ2VTdGF0dXMgKHBhY2ssIHN0YXR1cykge1xuICAgIHRoaXMucmVidWlsZFN0YXR1c2VzLnNldChwYWNrLCBzdGF0dXMpXG4gICAgZXRjaC51cGRhdGUodGhpcylcbiAgfVxuXG4gIHNldFJlYnVpbGRGYWlsdXJlT3V0cHV0IChwYWNrLCBvdXRwdXQpIHtcbiAgICB0aGlzLnJlYnVpbGRGYWlsdXJlT3V0cHV0cy5zZXQocGFjaywgb3V0cHV0KVxuICAgIGV0Y2gudXBkYXRlKHRoaXMpXG4gIH1cblxuICBnZXRUaXRsZSAoKSB7XG4gICAgcmV0dXJuICdJbmNvbXBhdGlibGUgUGFja2FnZXMnXG4gIH1cblxuICBnZXRVUkkgKCkge1xuICAgIHJldHVybiBWSUVXX1VSSVxuICB9XG5cbiAgZ2V0SWNvbk5hbWUgKCkge1xuICAgIHJldHVybiAncGFja2FnZSdcbiAgfVxuXG4gIHNlcmlhbGl6ZSAoKSB7XG4gICAgcmV0dXJuIHsgZGVzZXJpYWxpemVyOiAnSW5jb21wYXRpYmxlUGFja2FnZXNDb21wb25lbnQnIH1cbiAgfVxufVxuIl19