"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareEmojiReactionsController = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _emojiReactionsView = _interopRequireDefault(require("../views/emoji-reactions-view"));

var _addReaction = _interopRequireDefault(require("../mutations/add-reaction"));

var _removeReaction = _interopRequireDefault(require("../mutations/remove-reaction"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareEmojiReactionsController extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "addReaction", async content => {
      try {
        await (0, _addReaction["default"])(this.props.relay.environment, this.props.reactable.id, content);
      } catch (err) {
        this.props.reportMutationErrors('Unable to add reaction emoji', err);
      }
    });

    _defineProperty(this, "removeReaction", async content => {
      try {
        await (0, _removeReaction["default"])(this.props.relay.environment, this.props.reactable.id, content);
      } catch (err) {
        this.props.reportMutationErrors('Unable to remove reaction emoji', err);
      }
    });
  }

  render() {
    return _react["default"].createElement(_emojiReactionsView["default"], _extends({
      addReaction: this.addReaction,
      removeReaction: this.removeReaction
    }, this.props));
  }

}

exports.BareEmojiReactionsController = BareEmojiReactionsController;

_defineProperty(BareEmojiReactionsController, "propTypes", {
  relay: _propTypes["default"].shape({
    environment: _propTypes["default"].object.isRequired
  }).isRequired,
  reactable: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired
  }).isRequired,
  // Atom environment
  tooltips: _propTypes["default"].object.isRequired,
  // Action methods
  reportMutationErrors: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareEmojiReactionsController, {
  reactable: function () {
    const node = require("./__generated__/emojiReactionsController_reactable.graphql");

    if (node.hash && node.hash !== "cfdd39cd7aa02bce0bdcd52bc0154223") {
      console.error("The definition of 'emojiReactionsController_reactable' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/emojiReactionsController_reactable.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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