/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.network;

import java.io.IOException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.ProtocolException;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zaproxy.zap.network.ZapHttpParser;

public class ZapHeadMethod
extends EntityEnclosingMethod {
    private static final Log LOG = LogFactory.getLog(HeadMethod.class);

    public ZapHeadMethod() {
    }

    public ZapHeadMethod(String uri) {
        super(uri);
    }

    public String getName() {
        return "HEAD";
    }

    protected void readResponseBody(HttpState state, HttpConnection conn) throws HttpException, IOException {
        LOG.trace((Object)"enter HeadMethod.readResponseBody(HttpState, HttpConnection)");
        int bodyCheckTimeout = this.getParams().getIntParameter("http.protocol.head-body-timeout", -1);
        if (bodyCheckTimeout < 0) {
            this.responseBodyConsumed();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Check for non-compliant response body. Timeout in " + bodyCheckTimeout + " ms"));
            }
            boolean responseAvailable = false;
            try {
                responseAvailable = conn.isResponseAvailable(bodyCheckTimeout);
            }
            catch (IOException e) {
                LOG.debug((Object)"An IOException occurred while testing if a response was available, we will assume one is not.", (Throwable)e);
                responseAvailable = false;
            }
            if (responseAvailable) {
                if (this.getParams().isParameterTrue("http.protocol.reject-head-body")) {
                    throw new ProtocolException("Body content may not be sent in response to HTTP HEAD request");
                }
                LOG.warn((Object)"Body content returned in response to HTTP HEAD");
                super.readResponseBody(state, conn);
            }
        }
    }

    protected void readResponseHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        this.getResponseHeaderGroup().clear();
        Header[] headers = ZapHttpParser.parseHeaders(conn.getResponseInputStream(), this.getParams().getHttpElementCharset());
        this.getResponseHeaderGroup().setHeaders(headers);
    }
}

