"use strict";
/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const ansiRegex = require("ansi-regex");
const fs = require("fs-extra");
const logdown = require("logdown");
const moment = require("moment");
const path = require("path");
class LogFactory {
    static getColor() {
        LogFactory.COLOR_CODE.R = (LogFactory.COLOR_CODE.R + LogFactory.COLOR_STEP.R) % 256;
        LogFactory.COLOR_CODE.G = (LogFactory.COLOR_CODE.G + LogFactory.COLOR_STEP.G) % 256;
        LogFactory.COLOR_CODE.B = (LogFactory.COLOR_CODE.B + LogFactory.COLOR_STEP.B) % 256;
        const rHex = Number(LogFactory.COLOR_CODE.R)
            .toString(16)
            .padStart(2, '0');
        const gHex = LogFactory.COLOR_CODE.G.toString(16).padStart(2, '0');
        const bHex = LogFactory.COLOR_CODE.B.toString(16).padStart(2, '0');
        return `#${rHex}${gHex}${bHex}`;
    }
    static addTimestamp(logTransport) {
        if (this.namespace && ~logTransport.msg.indexOf(this.namespace)) {
            logTransport.args.unshift(`[${moment().format('YYYY-MM-DD HH:mm:ss')}]`);
        }
    }
    static writeTransport(logTransport) {
        return __awaiter(this, void 0, void 0, function* () {
            const [time] = logTransport.args;
            const logMessage = `${time} ${logTransport.msg}`;
            if (this.logFilePath) {
                yield LogFactory.writeMessage(logMessage, this.logFilePath);
            }
        });
    }
    static writeMessage(message, logFilePath) {
        return __awaiter(this, void 0, void 0, function* () {
            const withoutColor = message.replace(ansiRegex(), '');
            return fs.outputFile(logFilePath, `${withoutColor}\r\n`, {
                encoding: 'utf8',
                flag: 'a',
            });
        });
    }
    static createLoggerName(fileName, namespace, separator) {
        if (typeof window === 'undefined') {
            fileName = path.basename(fileName, path.extname(fileName));
        }
        return [namespace, fileName].filter(Boolean).join(separator);
    }
    static getLogger(name, options) {
        const defaults = {
            color: LogFactory.getColor(),
            forceEnable: false,
            logFilePath: '',
            namespace: typeof window === 'undefined' ? process.env.npm_package_name || '' : '',
            separator: '::',
        };
        const config = Object.assign({}, defaults, options);
        if (logdown.transports.length === 0) {
            logdown.transports.push(LogFactory.addTimestamp.bind({ namespace: config.namespace }));
            logdown.transports.push(LogFactory.writeTransport.bind({ logFilePath: config.logFilePath }));
        }
        const loggerName = this.createLoggerName(name, config.namespace, config.separator);
        const logger = logdown(loggerName, {
            logger: console,
            markdown: false,
            prefixColor: config.color,
        });
        if (config.forceEnable) {
            logger.state.isEnabled = true;
        }
        return logger;
    }
}
LogFactory.logFilePath = undefined;
LogFactory.namespace = undefined;
LogFactory.COLOR_STEP = {
    B: 97,
    G: 79,
    R: 31,
};
LogFactory.COLOR_CODE = {
    B: 0,
    G: 0,
    R: 0,
};
exports.LogFactory = LogFactory;
//# sourceMappingURL=LogFactory.js.map