"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var electron_1 = require("electron");
var Menu = electron_1.remote.Menu;
var eventType_1 = require("../../lib/eventType");
var locale = require("../../locale/locale");
var config = require("../../settings/config");
var textMenu;
var copyContext = '';
var defaultMenu = Menu.buildFromTemplate([
    {
        click: function () { return electron_1.clipboard.writeText(copyContext); },
        label: locale.getText('menuCopy'),
    },
]);
var textMenuTemplate = [
    {
        label: locale.getText('menuCut'),
        role: 'cut',
    },
    {
        label: locale.getText('menuCopy'),
        role: 'copy',
    },
    {
        label: locale.getText('menuPaste'),
        role: 'paste',
    },
    {
        type: 'separator',
    },
    {
        label: locale.getText('menuSelectAll'),
        role: 'selectall',
    },
];
var createTextMenu = function () {
    var template = textMenuTemplate.slice();
    textMenu = Menu.buildFromTemplate(template);
};
var imageMenu = Menu.buildFromTemplate([
    {
        click: function () { return savePicture(imageMenu.image || '', imageMenu.timestamp); },
        label: locale.getText('menuSavePictureAs'),
    },
]);
window.addEventListener('contextmenu', function (event) {
    var element = event.target;
    copyContext = '';
    if (element.nodeName === 'TEXTAREA' || element.nodeName === 'INPUT') {
        event.preventDefault();
        createTextMenu();
        textMenu.popup({ window: electron_1.remote.getCurrentWindow() });
    }
    else if (element.classList.contains('image-element') || element.classList.contains('detail-view-image')) {
        event.preventDefault();
        var elementSource = element.src;
        var parentElement = element.closest('.message-body');
        var timeElement = parentElement.getElementsByTagName('time')[0];
        if (timeElement) {
            var imageTimestamp = timeElement.dataset['timestamp'];
            imageMenu.timestamp = imageTimestamp;
        }
        imageMenu.image = elementSource;
        imageMenu.popup({ window: electron_1.remote.getCurrentWindow() });
    }
    else if (element.nodeName === 'A') {
        event.preventDefault();
        var elementHref = element.href;
        copyContext = elementHref.replace(/^mailto:/, '');
        defaultMenu.popup({ window: electron_1.remote.getCurrentWindow() });
    }
    else if (element.classList.contains('text')) {
        event.preventDefault();
        copyContext = window.getSelection().toString() || element.innerText.trim();
        defaultMenu.popup({ window: electron_1.remote.getCurrentWindow() });
    }
    else {
        var parentNode = element.parentNode;
        while (parentNode && parentNode !== document && !parentNode.classList.contains('text')) {
            parentNode = parentNode.parentNode;
        }
        if (parentNode !== document) {
            event.preventDefault();
            copyContext = window.getSelection().toString() || parentNode.innerText.trim();
            defaultMenu.popup({ window: electron_1.remote.getCurrentWindow() });
        }
    }
}, false);
var savePicture = function (url, timestamp) {
    return fetch(url, {
        headers: {
            'User-Agent': config.USER_AGENT,
        },
    })
        .then(function (response) { return response.arrayBuffer(); })
        .then(function (arrayBuffer) { return electron_1.ipcRenderer.send(eventType_1.EVENT_TYPE.ACTION.SAVE_PICTURE, new Uint8Array(arrayBuffer), timestamp); });
};
//# sourceMappingURL=context.js.map