/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration.configurators;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyDescriptor;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.Configurator;
import net.sf.sdedit.ui.components.configuration.DataObject;

public class ColorConfigurator<C extends DataObject>
extends Configurator<Color, C> {
    private static final long serialVersionUID = 5894127763719308668L;
    private JLabel label;
    private JLabel caption;

    public ColorConfigurator(Bean<C> bean, PropertyDescriptor property) {
        super(bean, property);
        this.setLayout(new GridLayout(1, 2));
        final String info = property.getWriteMethod().getAnnotation(Adjustable.class).info();
        this.caption = new JLabel(info);
        this.label = new JLabel();
        this.label.setOpaque(true);
        this.label.setBackground((Color)this.getValue());
        this.label.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Color color;
                if (ColorConfigurator.this.label.isEnabled() && SwingUtilities.isLeftMouseButton(e) && (color = JColorChooser.showDialog(ColorConfigurator.this, info, (Color)ColorConfigurator.this.getValue())) != null) {
                    ActionEvent event = new ActionEvent(ColorConfigurator.this.label, 1, "" + color.getRGB());
                    ColorConfigurator.this.actionPerformed(event);
                }
            }
        });
        this.add(this.caption);
        this.add(this.label);
    }

    @Override
    protected void _actionPerformed(ActionEvent evt) {
        int rgb = Integer.parseInt(evt.getActionCommand());
        this.applyValue(new Color(rgb));
    }

    @Override
    protected void _setEnabled(boolean enabled) {
        this.caption.setEnabled(enabled);
        this.label.setEnabled(enabled);
    }

    @Override
    protected void refresh(Color value) {
        this.label.setBackground(value);
    }

    @Override
    public void focus() {
    }
}

