/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.io;

import java.util.function.Consumer;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.support.io.FileType;
import org.pdfsam.support.params.SingleOutputTaskParametersBuilder;
import org.pdfsam.support.params.TaskParametersBuildStep;
import org.pdfsam.ui.io.BrowsableFileField;
import org.pdfsam.ui.io.RememberingLatestFileChooserWrapper;
import org.pdfsam.ui.support.FXValidationSupport;
import org.sejda.conversion.FileOutputAdapter;

public class BrowsablePdfOutputField
extends BrowsableFileField
implements TaskParametersBuildStep<SingleOutputTaskParametersBuilder<?>> {
    public BrowsablePdfOutputField() {
        super(FileType.PDF, RememberingLatestFileChooserWrapper.OpenType.SAVE);
        this.enforceValidation(false, false);
    }

    public void apply(SingleOutputTaskParametersBuilder<?> builder, Consumer<String> onError) {
        this.getTextField().validate();
        if (this.getTextField().getValidationState() == FXValidationSupport.ValidationState.VALID) {
            builder.output(new FileOutputAdapter(this.getTextField().getText()).getFileOutput());
        } else {
            onError.accept(DefaultI18nContext.getInstance().i18n("The selected PDF file is invalid"));
        }
    }
}

