/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.prefix.processor;

import java.util.regex.Pattern;
import org.sejda.core.support.prefix.processor.BasenamePrefixProcessor;
import org.sejda.core.support.prefix.processor.BookmarkPrefixProcessor;
import org.sejda.core.support.prefix.processor.CurrentPagePrefixProcessor;
import org.sejda.core.support.prefix.processor.FileNumberPrefixProcessor;
import org.sejda.core.support.prefix.processor.PrefixProcessor;
import org.sejda.core.support.prefix.processor.StrictBookmarkPrefixProcessor;
import org.sejda.core.support.prefix.processor.TextPrefixProcessor;
import org.sejda.core.support.prefix.processor.TimestampPrefixProcessor;

enum PrefixType {
    BASENAME(false, "\\[BASENAME\\]", new BasenamePrefixProcessor()),
    CURRENTPAGE(true, "\\[CURRENTPAGE(#*)(-?[0-9]*)\\]", new CurrentPagePrefixProcessor()),
    FILENUMBER(true, "\\[FILENUMBER(#*)(-?[0-9]*)\\]", new FileNumberPrefixProcessor()),
    TIMESTAMP(true, "\\[TIMESTAMP\\]", new TimestampPrefixProcessor()),
    BOOKMARK(true, "\\[BOOKMARK_NAME\\]", new BookmarkPrefixProcessor()),
    BOOKMARK_STRICT(true, "\\[BOOKMARK_NAME_STRICT\\]", new StrictBookmarkPrefixProcessor()),
    TEXT(true, "\\[TEXT\\]", new TextPrefixProcessor());

    private boolean ensureUniqueNames;
    private Pattern pattern;
    private PrefixProcessor processor;

    private PrefixType(boolean ensureUniqueNames, String matchingRegexp, PrefixProcessor processor) {
        this.ensureUniqueNames = ensureUniqueNames;
        this.pattern = Pattern.compile(matchingRegexp);
        this.processor = processor;
    }

    public boolean isEnsureUniqueNames() {
        return this.ensureUniqueNames;
    }

    public boolean isFoundIn(String toBeSearched) {
        return this.pattern.matcher(toBeSearched).find();
    }

    public PrefixProcessor getProcessor() {
        return this.processor;
    }
}

