# This file is a part of Julia. License is MIT: https://julialang.org/license

## generate repl-docs ##

function generate(io, command)
    println(io, """
    ```@raw html
    <section class="docstring">
    <div class="docstring-header">
        <a class="docstring-binding" id="repl-$(command)" href="#repl-$(command)">
            <code>$(replace(command, "-" => " "))</code>
        </a>
        —
        <span class="docstring-category">REPL command</span>
    .
    </div>
    ```
    ```@eval
    using Pkg
    Pkg.REPLMode.CommandSpec("$(command)").help
    ```
    ```@raw html
    </section>
    ```
    """)
end
function generate()
    io = IOBuffer()
    println(io, """
        # [**9.** REPL Mode Reference](@id REPL-Mode-Reference)

        This section describes available commands in the Pkg REPL.
        The REPL mode is mostly meant for interactive use,
        and for non-interactive use it is recommended to use the
        "API mode", see [API Reference](@ref API-Reference).
        """)
    # list commands
    println(io, "## `package` commands")
    foreach(command -> generate(io, command), ["add", "build", "develop", "free", "generate", "pin", "remove", "test", "update"])
    println(io, "## `registry` commands")
    foreach(command -> generate(io, command), ["registry-add", "registry-remove", "registry-status", "registry-update"])
    println(io, "## Other commands")
    foreach(command -> generate(io, command), ["activate", "gc", "help", "instantiate", "precompile", "resolve", "status"])
    # write to file
    write(joinpath(@__DIR__, "src", "repl.md"), seekstart(io))
    return
end

generate()
