/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.local.model.DefaultProjectDependencyMetadata;
import org.gradle.internal.component.model.AttributeConfigurationSelector;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.ForcingDependencyMetadata;
import org.gradle.internal.component.model.IvyArtifactName;

public class GradleDependencyMetadata
implements ModuleDependencyMetadata,
ForcingDependencyMetadata {
    private final ModuleComponentSelector selector;
    private final List<ExcludeMetadata> excludes;
    private final boolean constraint;
    private final String reason;
    private final boolean force;

    public GradleDependencyMetadata(ModuleComponentSelector selector, List<ExcludeMetadata> excludes, boolean constraint, String reason, boolean force) {
        this.selector = selector;
        this.excludes = excludes;
        this.reason = reason;
        this.constraint = constraint;
        this.force = force;
    }

    @Override
    public List<IvyArtifactName> getArtifacts() {
        return ImmutableList.of();
    }

    @Override
    public ModuleDependencyMetadata withRequestedVersion(VersionConstraint requestedVersion) {
        if (requestedVersion.equals(this.selector.getVersionConstraint())) {
            return this;
        }
        return new GradleDependencyMetadata(DefaultModuleComponentSelector.newSelector(this.selector.getModuleIdentifier(), requestedVersion, this.selector.getAttributes(), this.selector.getRequestedCapabilities()), this.excludes, this.constraint, this.reason, this.force);
    }

    @Override
    public ModuleDependencyMetadata withReason(String reason) {
        if (Objects.equal((Object)reason, (Object)this.reason)) {
            return this;
        }
        return new GradleDependencyMetadata(this.selector, this.excludes, this.constraint, reason, this.force);
    }

    @Override
    public DependencyMetadata withTarget(ComponentSelector target) {
        if (target instanceof ModuleComponentSelector) {
            return new GradleDependencyMetadata((ModuleComponentSelector)target, this.excludes, this.constraint, this.reason, this.force);
        }
        return new DefaultProjectDependencyMetadata((ProjectComponentSelector)target, this);
    }

    @Override
    public ModuleComponentSelector getSelector() {
        return this.selector;
    }

    @Override
    public List<ExcludeMetadata> getExcludes() {
        return this.excludes;
    }

    @Override
    public List<ConfigurationMetadata> selectConfigurations(ImmutableAttributes consumerAttributes, ComponentResolveMetadata targetComponent, AttributesSchemaInternal consumerSchema, Collection<? extends Capability> explicitRequestedCapabilities) {
        return ImmutableList.of((Object)AttributeConfigurationSelector.selectConfigurationUsingAttributeMatching(consumerAttributes, explicitRequestedCapabilities, targetComponent, consumerSchema, this.getArtifacts()));
    }

    @Override
    public boolean isChanging() {
        return false;
    }

    @Override
    public boolean isTransitive() {
        return true;
    }

    @Override
    public boolean isConstraint() {
        return this.constraint;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    public String toString() {
        return "GradleDependencyMetadata: " + this.selector.toString();
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public ForcingDependencyMetadata forced() {
        return new GradleDependencyMetadata(this.selector, this.excludes, this.constraint, this.reason, true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GradleDependencyMetadata that = (GradleDependencyMetadata)o;
        return this.constraint == that.constraint && this.force == that.force && Objects.equal((Object)this.selector, (Object)that.selector) && Objects.equal(this.excludes, that.excludes) && Objects.equal((Object)this.reason, (Object)that.reason);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.selector, this.excludes, this.constraint, this.reason, this.force});
    }
}

