/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.editor.impl;

import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.ArrayFactory;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AtomicFieldUpdater;

class LockFreeCOWSortedArray<T> {
    @NotNull
    private final Comparator<? super T> comparator;
    private final ArrayFactory<T> arrayFactory;
    @NotNull
    private volatile T[] listeners;
    private static final AtomicFieldUpdater<LockFreeCOWSortedArray, Object[]> UPDATER = AtomicFieldUpdater.forFieldOfType(LockFreeCOWSortedArray.class, Object[].class);

    LockFreeCOWSortedArray(@NotNull Comparator<? super T> comparator, @NotNull ArrayFactory<T> arrayFactory) {
        if (comparator == null) {
            LockFreeCOWSortedArray.$$$reportNull$$$0(0);
        }
        if (arrayFactory == null) {
            LockFreeCOWSortedArray.$$$reportNull$$$0(1);
        }
        this.comparator = comparator;
        this.arrayFactory = arrayFactory;
        this.listeners = arrayFactory.create(0);
    }

    void add(@NotNull T listener) {
        int i;
        T[] newListeners;
        T[] oldListeners;
        if (listener == null) {
            LockFreeCOWSortedArray.$$$reportNull$$$0(2);
        }
        while (!UPDATER.compareAndSet(this, oldListeners = this.listeners, newListeners = ArrayUtil.insert(oldListeners, i = this.insertionIndex(oldListeners, listener), listener))) {
        }
    }

    private int insertionIndex(@NotNull T[] elements, @NotNull T e) {
        if (elements == null) {
            LockFreeCOWSortedArray.$$$reportNull$$$0(4);
        }
        if (e == null) {
            LockFreeCOWSortedArray.$$$reportNull$$$0(5);
        }
        for (int i = 0; i < elements.length; ++i) {
            T element = elements[i];
            if (this.comparator.compare(e, element) >= 0) continue;
            return i;
        }
        return elements.length;
    }

    @NotNull
    T[] getArray() {
        if (this.listeners == null) {
            LockFreeCOWSortedArray.$$$reportNull$$$0(6);
        }
        return this.listeners;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/LockFreeCOWSortedArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/LockFreeCOWSortedArray";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insertionIndex";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

