/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.change;

import java.util.ArrayList;
import java.util.List;
import org.gradle.internal.change.Change;
import org.gradle.internal.change.ChangeContainer;
import org.gradle.internal.change.ChangeVisitor;

public class CachingChangeContainer
implements ChangeContainer {
    private final ChangeContainer delegate;
    private final List<Change> cache = new ArrayList<Change>();
    private final int maxCachedChanges;
    private boolean cached;
    private boolean overrun;

    public CachingChangeContainer(int maxCachedChanges, ChangeContainer delegate) {
        this.maxCachedChanges = maxCachedChanges;
        this.delegate = delegate;
    }

    @Override
    public boolean accept(ChangeVisitor visitor) {
        if (this.overrun) {
            return this.delegate.accept(visitor);
        }
        if (this.cached) {
            for (Change change : this.cache) {
                if (visitor.visitChange(change)) continue;
                return false;
            }
            return true;
        }
        this.cache.clear();
        boolean acceptedAllChanges = this.delegate.accept(new CachingVisitor(visitor));
        this.cached = acceptedAllChanges && !this.overrun;
        return acceptedAllChanges;
    }

    private class CachingVisitor
    implements ChangeVisitor {
        private final ChangeVisitor delegate;
        private int numChanges;

        public CachingVisitor(ChangeVisitor delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean visitChange(Change change) {
            if (this.numChanges < CachingChangeContainer.this.maxCachedChanges) {
                ++this.numChanges;
                CachingChangeContainer.this.cache.add(change);
            } else {
                CachingChangeContainer.this.overrun = true;
                CachingChangeContainer.this.cache.clear();
            }
            return this.delegate.visitChange(change);
        }
    }
}

