/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import java.util.IllegalFormatException;
import java.util.List;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.tasks.UndoableBackgroundTask;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class RemoveImagesTask
extends UndoableBackgroundTask<ImageInfo> {
    private static final I18n i18n = I18nFactory.getI18n(RemoveImagesTask.class);
    private int currentProgress = 0;
    private ImagesTableModel imagesTableModel;
    private List<ImageInfo> imageInfos;

    public RemoveImagesTask(String group, String name, ImagesTableModel imagesTableModel, List<ImageInfo> imageInfos) {
        super(group, name);
        this.imageInfos = imageInfos;
        this.imagesTableModel = imagesTableModel;
    }

    @Override
    public int getCurrentProgress() {
        return this.currentProgress;
    }

    @Override
    public int getMaxProgress() {
        return this.imageInfos.size();
    }

    @Override
    public int getMinProgress() {
        return 1;
    }

    @Override
    protected String doInBackground() throws Exception {
        for (ImageInfo imageInfo : this.imageInfos) {
            if (this.interruptRequested()) break;
            ++this.currentProgress;
            this.setProgressMessage();
            try {
                this.publish(imageInfo);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        String result = null;
        if (this.currentProgress == 1) {
            result = i18n.tr("One image removed");
        } else {
            try {
                result = String.format(i18n.tr("%d images removed"), this.currentProgress);
            }
            catch (IllegalFormatException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    protected void process(List<ImageInfo> images) {
        for (ImageInfo imageInfo : images) {
            int row = this.imagesTableModel.getRow(imageInfo);
            this.imagesTableModel.removeRow(row);
        }
        this.imagesTableModel.fireTableDataChanged();
    }

    @Override
    protected void done() {
        this.imagesTableModel.sortRows();
        super.done();
    }

    @Override
    public void undo() {
        super.undo();
        for (ImageInfo imageInfo : this.imageInfos) {
            this.imagesTableModel.addImageInfo(imageInfo);
        }
        this.imagesTableModel.fireTableDataChanged();
    }

    @Override
    public void redo() {
        super.redo();
        for (ImageInfo imageInfo : this.imageInfos) {
            int row = this.imagesTableModel.getRow(imageInfo);
            this.imagesTableModel.removeRow(row);
        }
        this.imagesTableModel.fireTableDataChanged();
    }
}

