/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.controller.Controller;
import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.modes.LineAdapter;
import freemind.modes.MindMapEdge;
import freemind.modes.MindMapNode;
import freemind.preferences.FreemindPropertyListener;
import java.awt.Color;

public abstract class EdgeAdapter
extends LineAdapter
implements MindMapEdge {
    public static final String EDGE_WIDTH_THIN_STRING = "thin";
    private static Color standardColor = null;
    private static String standardStyle = null;
    private static EdgeAdapterListener listener = null;
    public static final int WIDTH_PARENT = -1;
    public static final int WIDTH_THIN = 0;
    public static final String EDGESTYLE_LINEAR = "linear";
    public static final String EDGESTYLE_BEZIER = "bezier";
    public static final String EDGESTYLE_SHARP_LINEAR = "sharp_linear";
    public static final String EDGESTYLE_SHARP_BEZIER = "sharp_bezier";
    public static final int INT_EDGESTYLE_LINEAR = 0;
    public static final int INT_EDGESTYLE_BEZIER = 1;
    public static final int INT_EDGESTYLE_SHARP_LINEAR = 2;
    public static final int INT_EDGESTYLE_SHARP_BEZIER = 3;

    public EdgeAdapter(MindMapNode target, FreeMindMain frame) {
        super(target, frame);
        this.NORMAL_WIDTH = -1;
        if (listener == null) {
            listener = new EdgeAdapterListener();
            Controller.addPropertyChangeListener(listener);
        }
    }

    @Override
    public Color getColor() {
        if (this.color == null) {
            if (this.getTarget().isRoot()) {
                return this.getStandardColor();
            }
            return this.getSource().getEdge().getColor();
        }
        return this.color;
    }

    public Color getRealColor() {
        return this.color;
    }

    @Override
    public int getWidth() {
        if (this.width == -1) {
            if (this.getTarget().isRoot()) {
                return 0;
            }
            return this.getSource().getEdge().getWidth();
        }
        return this.width;
    }

    @Override
    public int getRealWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public String getStyle() {
        if (this.style == null) {
            if (this.getTarget().isRoot()) {
                return this.getFrame().getProperty(this.getStandardStylePropertyString());
            }
            return this.getSource().getEdge().getStyle();
        }
        return this.style;
    }

    @Override
    public boolean hasStyle() {
        return this.style != null;
    }

    private MindMapNode getSource() {
        return this.target.getParentNode();
    }

    @Override
    public XMLElement save() {
        if (this.style != null || this.color != null || this.width != -1) {
            XMLElement edge = new XMLElement();
            edge.setName("edge");
            if (this.style != null) {
                edge.setAttribute("STYLE", this.style);
            }
            if (this.color != null) {
                edge.setAttribute("COLOR", Tools.colorToXml(this.color));
            }
            if (this.width != -1) {
                if (this.width == 0) {
                    edge.setAttribute("WIDTH", EDGE_WIDTH_THIN_STRING);
                } else {
                    edge.setAttribute("WIDTH", Integer.toString(this.width));
                }
            }
            return edge;
        }
        return null;
    }

    @Override
    protected Color getStandardColor() {
        return standardColor;
    }

    @Override
    protected void setStandardColor(Color standardColor) {
        EdgeAdapter.standardColor = standardColor;
    }

    @Override
    protected String getStandardStyle() {
        return standardStyle;
    }

    @Override
    protected void setStandardStyle(String standardStyle) {
        EdgeAdapter.standardStyle = standardStyle;
    }

    @Override
    protected String getStandardColorPropertyString() {
        return "standardedgecolor";
    }

    @Override
    protected String getStandardStylePropertyString() {
        return "standardedgestyle";
    }

    @Override
    public int getStyleAsInt() {
        String edgeStyle = this.getStyle();
        if (Tools.safeEquals(edgeStyle, EDGESTYLE_LINEAR)) {
            return 0;
        }
        if (Tools.safeEquals(edgeStyle, EDGESTYLE_BEZIER)) {
            return 1;
        }
        if (Tools.safeEquals(edgeStyle, EDGESTYLE_SHARP_LINEAR)) {
            return 2;
        }
        if (Tools.safeEquals(edgeStyle, EDGESTYLE_SHARP_BEZIER)) {
            return 3;
        }
        throw new IllegalArgumentException("Unknown Edge Style " + edgeStyle);
    }

    protected static class EdgeAdapterListener
    implements FreemindPropertyListener {
        protected EdgeAdapterListener() {
        }

        @Override
        public void propertyChanged(String propertyName, String newValue, String oldValue) {
            if (propertyName.equals("standardedgecolor")) {
                standardColor = Tools.xmlToColor(newValue);
            }
            if (propertyName.equals("standardedgestyle")) {
                standardStyle = newValue;
            }
        }
    }
}

