/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.ingest.common.IngestCommonPlugin;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class GrokProcessorGetAction
extends Action<Response> {
    static final GrokProcessorGetAction INSTANCE = new GrokProcessorGetAction();
    static final String NAME = "cluster:admin/ingest/processor/grok/get";

    private GrokProcessorGetAction() {
        super(NAME);
    }

    public Response newResponse() {
        return new Response(null);
    }

    public static class RestAction
    extends BaseRestHandler {
        RestAction(Settings settings, RestController controller) {
            super(settings);
            controller.registerHandler(RestRequest.Method.GET, "/_ingest/processor/grok", (RestHandler)this);
        }

        public String getName() {
            return "ingest_processor_grok_get";
        }

        protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
            return channel -> client.executeLocally((Action)INSTANCE, (ActionRequest)new Request(), (ActionListener)new RestToXContentListener(channel));
        }
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        @Inject
        public TransportAction(TransportService transportService, ActionFilters actionFilters) {
            super(GrokProcessorGetAction.NAME, transportService, actionFilters, Request::new);
        }

        protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
            try {
                listener.onResponse((Object)new Response(IngestCommonPlugin.GROK_PATTERNS));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private Map<String, String> grokPatterns;

        Response(Map<String, String> grokPatterns) {
            this.grokPatterns = grokPatterns;
        }

        public Map<String, String> getGrokPatterns() {
            return this.grokPatterns;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("patterns");
            builder.map(this.grokPatterns);
            builder.endObject();
            return builder;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.grokPatterns = in.readMap(StreamInput::readString, StreamInput::readString);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeMap(this.grokPatterns, StreamOutput::writeString, StreamOutput::writeString);
        }
    }

    public static class Request
    extends ActionRequest {
        public ActionRequestValidationException validate() {
            return null;
        }
    }
}

