/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditor;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditorSite;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageGeneral;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageNetwork;
import org.jkiss.utils.CommonUtils;

public abstract class ConnectionPageAbstract
extends DialogPage
implements IDataSourceConnectionEditor {
    protected IDataSourceConnectionEditorSite site;
    protected Text driverText;
    protected Button savePasswordCheck;

    public IDataSourceConnectionEditorSite getSite() {
        return this.site;
    }

    public void dispose() {
        super.dispose();
    }

    public void setSite(IDataSourceConnectionEditorSite site) {
        this.site = site;
    }

    protected boolean isCustomURL() {
        return false;
    }

    public void loadSettings() {
        DBPDriver driver = this.site.getDriver();
        if (driver != null && this.driverText != null) {
            this.driverText.setText(CommonUtils.toString((Object)driver.getFullName()));
        }
        if (this.savePasswordCheck != null) {
            DataSourceDescriptor dataSource = (DataSourceDescriptor)this.getSite().getActiveDataSource();
            if (dataSource != null) {
                this.savePasswordCheck.setSelection(dataSource.isSavePassword());
            } else {
                this.savePasswordCheck.setSelection(true);
            }
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        this.saveConnectionURL(dataSource.getConnectionConfiguration());
        if (this.savePasswordCheck != null) {
            DataSourceDescriptor descriptor = (DataSourceDescriptor)dataSource;
            descriptor.setSavePassword(this.savePasswordCheck.getSelection());
            if (!descriptor.isSavePassword()) {
                descriptor.resetPassword();
            }
        }
    }

    protected void saveConnectionURL(DBPConnectionConfiguration connectionInfo) {
        if (!this.isCustomURL()) {
            connectionInfo.setUrl(this.site.getDriver().getDataSourceProvider().getConnectionURL(this.site.getDriver(), connectionInfo));
        }
    }

    protected void createDriverPanel(Composite parent) {
        int numColumns = ((GridLayout)parent.getLayout()).numColumns;
        Composite panel = UIUtils.createPlaceholder((Composite)parent, (int)4, (int)5);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = numColumns;
        panel.setLayoutData((Object)gd);
        Composite placeholder = UIUtils.createPlaceholder((Composite)panel, (int)1, (int)5);
        gd = new GridData(808);
        gd.horizontalSpan = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        placeholder.setLayoutData((Object)gd);
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("database.connect.processEnvVars")) {
            CLabel infoLabel = UIUtils.createInfoLabel((Composite)placeholder, (String)CoreMessages.dialog_connection_edit_connection_settings_variables_hint_label);
            gd = new GridData(808);
            infoLabel.setLayoutData((Object)gd);
            infoLabel.setToolTipText(CoreMessages.dialog_connection_env_variables_hint);
        }
        if (this.site.isNew()) {
            Button netConfigLink;
            Label divLabel = new Label(placeholder, 258);
            divLabel.setLayoutData((Object)new GridData(768));
            Composite linksComposite = UIUtils.createPlaceholder((Composite)placeholder, (int)2, (int)2);
            linksComposite.setLayoutData((Object)new GridData(768));
            Label advancedLabel = UIUtils.createControlLabel((Composite)linksComposite, (String)CoreMessages.dialog_connection_advanced_settings);
            advancedLabel.setLayoutData((Object)new GridData(768));
            if (!this.site.getDriver().isEmbedded()) {
                netConfigLink = new Button(linksComposite, 8);
                netConfigLink.setText(CoreMessages.dialog_connection_edit_wizard_conn_conf_network_link);
                netConfigLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ConnectionPageAbstract.this.site.openSettingsPage(ConnectionPageNetwork.PAGE_NAME);
                    }
                });
                netConfigLink.setLayoutData((Object)new GridData(128));
            }
            if (!this.site.getDriver().isEmbedded()) {
                UIUtils.createEmptyLabel((Composite)linksComposite, (int)1, (int)1);
            }
            netConfigLink = new Button(linksComposite, 8);
            netConfigLink.setText(CoreMessages.dialog_connection_edit_wizard_conn_conf_general_link);
            netConfigLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionPageAbstract.this.site.openSettingsPage(ConnectionPageGeneral.PAGE_NAME);
                }
            });
            netConfigLink.setLayoutData((Object)new GridData(128));
        }
        Label divLabel = new Label(panel, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 4;
        divLabel.setLayoutData((Object)gd);
        Label driverLabel = new Label(panel, 0);
        driverLabel.setText(CoreMessages.dialog_connection_driver);
        gd = new GridData(128);
        driverLabel.setLayoutData((Object)gd);
        this.driverText = new Text(panel, 8);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.driverText.setLayoutData((Object)gd);
        Button driverButton = new Button(panel, 8);
        driverButton.setText(CoreMessages.dialog_connection_edit_driver_button);
        gd = new GridData(128);
        driverButton.setLayoutData((Object)gd);
        driverButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ConnectionPageAbstract.this.site.openDriverEditor()) {
                    ConnectionPageAbstract.this.updateDriverInfo(ConnectionPageAbstract.this.site.getDriver());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void updateDriverInfo(DBPDriver driver) {
    }

    protected void createSavePasswordButton(Composite parent) {
        this.createSavePasswordButton(parent, 1);
    }

    protected void createSavePasswordButton(Composite parent, int hSpan) {
        DataSourceDescriptor dataSource = (DataSourceDescriptor)this.getSite().getActiveDataSource();
        this.savePasswordCheck = UIUtils.createCheckbox((Composite)parent, (String)CoreMessages.dialog_connection_wizard_final_checkbox_save_password_locally, (dataSource == null || dataSource.isSavePassword() ? 1 : 0) != 0);
        GridData gd = new GridData(32);
        if (hSpan > 1) {
            gd.horizontalSpan = hSpan;
        }
        this.savePasswordCheck.setLayoutData((Object)gd);
    }
}

