/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core.application;

import java.util.StringJoiner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.core.application.ApplicationActionBarAdvisor;
import org.jkiss.dbeaver.core.application.ApplicationCSSManager;
import org.jkiss.dbeaver.core.application.DBeaverApplication;
import org.jkiss.dbeaver.core.application.DBeaverCommandLine;
import org.jkiss.dbeaver.model.app.DBPProjectListener;
import org.jkiss.dbeaver.registry.ProjectRegistry;
import org.jkiss.dbeaver.registry.WorkbenchHandlerRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IWorkbenchWindowInitializer;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.perspective.AbstractPageListener;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor
implements DBPProjectListener {
    private static final Log log = Log.getLog(ApplicationWorkbenchWindowAdvisor.class);

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
        if (DBeaverApplication.WORKSPACE_MIGRATED) {
            this.refreshProjects();
        }
        DBWorkbench.getPlatform().getProjectManager().addProjectListener((DBPProjectListener)this);
    }

    private void refreshProjects() {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                log.error((Object)("Error refreshing project '" + project.getName() + "'"), (Throwable)e);
            }
            ++n2;
        }
    }

    public void dispose() {
        ProjectRegistry projectRegistry;
        DBeaverCore core = DBeaverCore.getInstance();
        if (core != null && (projectRegistry = core.getProjectRegistry()) != null) {
            projectRegistry.removeProjectListener((DBPProjectListener)this);
        }
        super.dispose();
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        log.debug((Object)"Create actions");
        return new ApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        log.debug((Object)"Configure workbench window");
        super.preWindowOpen();
        ProgressManagerUtil.SHORT_OPERATION_TIME = 100L;
        Rectangle displaySize = Display.getCurrent().getPrimaryMonitor().getBounds();
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setInitialSize(new Point(displaySize.width * 3 / 4, displaySize.height * 3 / 4));
        configurer.setShowCoolBar(true);
        configurer.setShowStatusLine(true);
        configurer.setShowPerspectiveBar(true);
        configurer.setShowProgressIndicator(true);
        configurer.configureEditorAreaDropListener((DropTargetListener)new EditorAreaDropAdapter());
        configurer.addEditorAreaTransfer((Transfer)EditorInputTransfer.getInstance());
        configurer.addEditorAreaTransfer((Transfer)ResourceTransfer.getInstance());
        configurer.addEditorAreaTransfer((Transfer)FileTransfer.getInstance());
        configurer.addEditorAreaTransfer((Transfer)MarkerTransfer.getInstance());
        configurer.configureEditorAreaDropListener((DropTargetListener)new org.eclipse.ui.internal.ide.EditorAreaDropAdapter(configurer.getWindow()));
        this.hookTitleUpdateListeners(configurer);
        DBeaverUI.getInstance();
    }

    private void hookTitleUpdateListeners(IWorkbenchWindowConfigurer configurer) {
        configurer.getWindow().addPageListener((IPageListener)new AbstractPageListener(){

            public void pageActivated(IWorkbenchPage page) {
                ApplicationWorkbenchWindowAdvisor.this.recomputeTitle();
            }

            public void pageClosed(IWorkbenchPage page) {
                ApplicationWorkbenchWindowAdvisor.this.recomputeTitle();
            }
        });
        configurer.getWindow().addPerspectiveListener((IPerspectiveListener)new PerspectiveAdapter(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                ApplicationWorkbenchWindowAdvisor.this.recomputeTitle();
            }

            public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
                ApplicationWorkbenchWindowAdvisor.this.recomputeTitle();
            }

            public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                ApplicationWorkbenchWindowAdvisor.this.recomputeTitle();
            }
        });
        configurer.getWindow().getPartService().addPartListener(new IPartListener2(){

            public void partActivated(IWorkbenchPartReference ref) {
                if (ref instanceof IEditorReference) {
                    ApplicationWorkbenchWindowAdvisor.this.recomputeTitle();
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference ref) {
                if (ref instanceof IEditorReference) {
                    ApplicationWorkbenchWindowAdvisor.this.recomputeTitle();
                }
            }

            public void partClosed(IWorkbenchPartReference ref) {
                ApplicationWorkbenchWindowAdvisor.this.recomputeTitle();
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference ref) {
                ApplicationWorkbenchWindowAdvisor.this.recomputeTitle();
            }

            public void partVisible(IWorkbenchPartReference ref) {
                ApplicationWorkbenchWindowAdvisor.this.recomputeTitle();
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }
        });
    }

    public void postWindowCreate() {
        log.debug((Object)"Initialize workbench window");
        super.postWindowCreate();
        this.recomputeTitle();
        try {
            DBeaverCommandLine.executeCommandLineCommands(DBeaverCommandLine.getCommandLine(), DBeaverApplication.getInstance().getInstanceServer(), true);
        }
        catch (Exception e) {
            log.error((Object)"Error processing command line", (Throwable)e);
        }
    }

    public void postWindowOpen() {
        log.debug((Object)"Finish initialization");
        super.postWindowOpen();
        UIUtils.asyncExec(() -> {});
        try {
            ApplicationCSSManager.updateApplicationCSS(Display.getCurrent());
        }
        catch (Throwable e) {
            log.warn((Object)e);
        }
        if (this.isRunWorkbenchInitializers()) {
            UIUtils.asyncExec(() -> {
                for (IWorkbenchWindowInitializer wwInit : WorkbenchHandlerRegistry.getInstance().getWorkbenchWindowInitializers()) {
                    wwInit.initializeWorkbenchWindow(this.getWindowConfigurer().getWindow());
                }
            });
        }
    }

    protected boolean isRunWorkbenchInitializers() {
        return true;
    }

    public void handleActiveProjectChange(IProject oldValue, IProject newValue) {
        UIUtils.asyncExec(this::recomputeTitle);
    }

    private void recomputeTitle() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        String oldTitle = configurer.getTitle();
        String newTitle = this.computeTitle();
        if (!newTitle.equals(oldTitle)) {
            configurer.setTitle(newTitle);
        }
    }

    private String computeTitle() {
        IEditorPart activeEditor;
        IWorkbenchPage activePage;
        IWorkbenchWindow window;
        IProject activeProject;
        String workspaceName;
        IPreferenceStore ps = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        StringJoiner sj = new StringJoiner(" - ");
        if (ps.getBoolean("SHOW_LOCATION_NAME") && (workspaceName = ps.getString("WORKSPACE_NAME")) != null && workspaceName.length() > 0) {
            sj.add(workspaceName);
        }
        if (ps.getBoolean("SHOW_LOCATION")) {
            String workspaceLocation = Platform.getLocation().toOSString();
            sj.add(workspaceLocation);
        }
        if (ps.getBoolean("SHOW_PERSPECTIVE_IN_TITLE") && (activeProject = DBWorkbench.getPlatform().getProjectManager().getActiveProject()) != null) {
            sj.add(activeProject.getName());
        }
        if (ps.getBoolean("SHOW_PRODUCT_IN_TITLE")) {
            sj.add(GeneralUtils.getProductTitle());
        }
        if ((window = this.getWindowConfigurer().getWindow()) != null && (activePage = window.getActivePage()) != null && (activeEditor = activePage.getActiveEditor()) != null) {
            sj.add(activeEditor.getTitle());
        }
        return sj.toString();
    }

    public class EditorAreaDropAdapter
    extends DropTargetAdapter {
    }
}

