/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.sjavac.Package;
import com.sun.tools.sjavac.Source;
import com.sun.tools.sjavac.pubapi.PubApi;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Module
implements Comparable<Module> {
    private String name;
    private String dirname;
    private Map<String, Package> packages = new HashMap<String, Package>();
    private Map<String, Source> sources = new HashMap<String, Source>();
    private Map<String, File> artifacts = new HashMap<String, File>();

    public Module(String string, String string2) {
        this.name = string;
        this.dirname = string;
    }

    public String name() {
        return this.name;
    }

    public String dirname() {
        return this.dirname;
    }

    public Map<String, Package> packages() {
        return this.packages;
    }

    public Map<String, Source> sources() {
        return this.sources;
    }

    public Map<String, File> artifacts() {
        return this.artifacts;
    }

    public boolean equals(Object object) {
        return object instanceof Module && this.name.equals(((Module)object).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(Module module) {
        return this.name.compareTo(module.name);
    }

    public void save(StringBuilder stringBuilder) {
        stringBuilder.append("M ").append(this.name).append(":").append("\n");
        Package.savePackages(this.packages, stringBuilder);
    }

    public static Module load(String string) {
        int n = string.indexOf(58, 2);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(2, n);
        return new Module(string2, "");
    }

    public static void saveModules(Map<String, Module> map, StringBuilder stringBuilder) {
        for (Module module : map.values()) {
            module.save(stringBuilder);
        }
    }

    public void addPackage(Package package_) {
        this.packages.put(package_.name(), package_);
    }

    public Package lookupPackage(String string) {
        Package package_ = this.packages.get(string);
        if (package_ == null) {
            package_ = new Package(this, string);
            this.packages.put(string, package_);
        }
        return package_;
    }

    public void addSource(String string, Source source) {
        Package package_ = this.lookupPackage(string);
        source.setPackage(package_);
        package_.addSource(source);
        this.sources.put(source.file().getPath(), source);
    }

    public Source lookupSource(String string) {
        return this.sources.get(string);
    }

    public void addArtifacts(String string, Set<URI> set) {
        Package package_ = this.lookupPackage(string);
        for (URI uRI : set) {
            package_.addArtifact(new File(uRI));
        }
    }

    public void setDependencies(String string, Map<String, Set<String>> map, boolean bl) {
        this.lookupPackage(string).setDependencies(map, bl);
    }

    public void setPubapi(String string, PubApi pubApi) {
        Package package_ = this.lookupPackage(string);
        package_.setPubapi(pubApi);
    }

    public boolean hasPubapiChanged(String string, PubApi pubApi) {
        Package package_ = this.lookupPackage(string);
        return package_.hasPubApiChanged(pubApi);
    }
}

