Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/** @babel */

var _atom = require('atom');

var _symbolsView = require('./symbols-view');

var _symbolsView2 = _interopRequireDefault(_symbolsView);

var _tagGenerator = require('./tag-generator');

var _tagGenerator2 = _interopRequireDefault(_tagGenerator);

var _fuzzaldrin = require('fuzzaldrin');

var FileView = (function (_SymbolsView) {
  _inherits(FileView, _SymbolsView);

  function FileView(stack) {
    var _this = this;

    _classCallCheck(this, FileView);

    _get(Object.getPrototypeOf(FileView.prototype), 'constructor', this).call(this, stack);
    this.cachedTags = {};
    this.watchedEditors = new WeakSet();

    this.editorsSubscription = atom.workspace.observeTextEditors(function (editor) {
      if (_this.watchedEditors.has(editor)) return;

      var removeFromCache = function removeFromCache() {
        delete _this.cachedTags[editor.getPath()];
      };
      var editorSubscriptions = new _atom.CompositeDisposable();
      editorSubscriptions.add(editor.onDidChangeGrammar(removeFromCache));
      editorSubscriptions.add(editor.onDidSave(removeFromCache));
      editorSubscriptions.add(editor.onDidChangePath(removeFromCache));
      editorSubscriptions.add(editor.getBuffer().onDidReload(removeFromCache));
      editorSubscriptions.add(editor.getBuffer().onDidDestroy(removeFromCache));
      editor.onDidDestroy(function () {
        _this.watchedEditors['delete'](editor);
        editorSubscriptions.dispose();
      });

      _this.watchedEditors.add(editor);
    });
  }

  _createClass(FileView, [{
    key: 'destroy',
    value: function destroy() {
      this.editorsSubscription.dispose();
      return _get(Object.getPrototypeOf(FileView.prototype), 'destroy', this).call(this);
    }
  }, {
    key: 'elementForItem',
    value: function elementForItem(_ref) {
      var position = _ref.position;
      var name = _ref.name;

      // Style matched characters in search results
      var matches = (0, _fuzzaldrin.match)(name, this.selectListView.getFilterQuery());

      var li = document.createElement('li');
      li.classList.add('two-lines');

      var primaryLine = document.createElement('div');
      primaryLine.classList.add('primary-line');
      primaryLine.appendChild(_symbolsView2['default'].highlightMatches(this, name, matches));
      li.appendChild(primaryLine);

      var secondaryLine = document.createElement('div');
      secondaryLine.classList.add('secondary-line');
      secondaryLine.textContent = 'Line ' + (position.row + 1);
      li.appendChild(secondaryLine);

      return li;
    }
  }, {
    key: 'didChangeSelection',
    value: function didChangeSelection(item) {
      if (atom.config.get('symbols-view.quickJumpToFileSymbol') && item) {
        this.openTag(item);
      }
    }
  }, {
    key: 'didCancelSelection',
    value: _asyncToGenerator(function* () {
      yield this.cancel();
      var editor = this.getEditor();
      if (this.initialState && editor) {
        this.deserializeEditorState(editor, this.initialState);
      }
      this.initialState = null;
    })
  }, {
    key: 'toggle',
    value: _asyncToGenerator(function* () {
      if (this.panel.isVisible()) {
        yield this.cancel();
      }
      var filePath = this.getPath();
      if (filePath) {
        var editor = this.getEditor();
        if (atom.config.get('symbols-view.quickJumpToFileSymbol') && editor) {
          this.initialState = this.serializeEditorState(editor);
        }
        this.populate(filePath);
        this.attach();
      }
    })
  }, {
    key: 'serializeEditorState',
    value: function serializeEditorState(editor) {
      var editorElement = atom.views.getView(editor);
      var scrollTop = editorElement.getScrollTop();

      return {
        bufferRanges: editor.getSelectedBufferRanges(),
        scrollTop: scrollTop
      };
    }
  }, {
    key: 'deserializeEditorState',
    value: function deserializeEditorState(editor, _ref2) {
      var bufferRanges = _ref2.bufferRanges;
      var scrollTop = _ref2.scrollTop;

      var editorElement = atom.views.getView(editor);

      editor.setSelectedBufferRanges(bufferRanges);
      editorElement.setScrollTop(scrollTop);
    }
  }, {
    key: 'getEditor',
    value: function getEditor() {
      return atom.workspace.getActiveTextEditor();
    }
  }, {
    key: 'getPath',
    value: function getPath() {
      if (this.getEditor()) {
        return this.getEditor().getPath();
      }
      return undefined;
    }
  }, {
    key: 'getScopeName',
    value: function getScopeName() {
      if (this.getEditor() && this.getEditor().getGrammar()) {
        return this.getEditor().getGrammar().scopeName;
      }
      return undefined;
    }
  }, {
    key: 'populate',
    value: _asyncToGenerator(function* (filePath) {
      var tags = this.cachedTags[filePath];
      if (tags) {
        yield this.selectListView.update({ items: tags });
      } else {
        yield this.selectListView.update({
          items: [],
          loadingMessage: 'Generating symbols…'
        });
        yield this.selectListView.update({
          items: yield this.generateTags(filePath),
          loadingMessage: null
        });
      }
    })
  }, {
    key: 'generateTags',
    value: _asyncToGenerator(function* (filePath) {
      var generator = new _tagGenerator2['default'](filePath, this.getScopeName());
      this.cachedTags[filePath] = yield generator.generate();
      return this.cachedTags[filePath];
    })
  }]);

  return FileView;
})(_symbolsView2['default']);

exports['default'] = FileView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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