"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WholeFileDiscardHistory = exports.PartialFileDiscardHistory = void 0;

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class PartialFileDiscardHistory {
  constructor(maxHistoryLength) {
    this.blobHistoryByFilePath = {};
    this.maxHistoryLength = maxHistoryLength || 60;
  }

  getHistoryForPath(filePath) {
    const history = this.blobHistoryByFilePath[filePath];

    if (history) {
      return history;
    } else {
      this.setHistoryForPath(filePath, []);
      return this.blobHistoryByFilePath[filePath];
    }
  }

  setHistoryForPath(filePath, history) {
    this.blobHistoryByFilePath[filePath] = history;
  }

  getHistory() {
    return this.blobHistoryByFilePath;
  }

  setHistory(history) {
    this.blobHistoryByFilePath = history;
  }

  popHistoryForPath(filePath) {
    return this.getHistoryForPath(filePath).pop();
  }

  addHistory(filePath, snapshots) {
    const history = this.getHistoryForPath(filePath);
    history.push(snapshots);

    if (history.length >= this.maxHistoryLength) {
      this.setHistoryForPath(filePath, history.slice(Math.ceil(this.maxHistoryLength / 2)));
    }
  }

  getLastSnapshotsForPath(filePath) {
    const history = this.getHistoryForPath(filePath);
    const snapshots = history[history.length - 1];

    if (!snapshots) {
      return null;
    }

    return _objectSpread({
      filePath
    }, snapshots);
  }

  clearHistoryForPath(filePath) {
    this.setHistoryForPath(filePath, []);
  }

}

exports.PartialFileDiscardHistory = PartialFileDiscardHistory;

class WholeFileDiscardHistory {
  constructor(maxHistoryLength) {
    this.blobHistory = [];
    this.maxHistoryLength = maxHistoryLength || 60;
  }

  getHistory() {
    return this.blobHistory;
  }

  setHistory(history) {
    this.blobHistory = history;
  }

  popHistory() {
    return this.getHistory().pop();
  }

  addHistory(snapshotsByPath) {
    const history = this.getHistory();
    history.push(snapshotsByPath);

    if (history.length >= this.maxHistoryLength) {
      this.setHistory(history.slice(Math.ceil(this.maxHistoryLength / 2)));
    }
  }

  getLastSnapshots() {
    const history = this.getHistory();
    const snapshotsByPath = history[history.length - 1] || {};
    return Object.keys(snapshotsByPath).map(p => {
      return _objectSpread({
        filePath: p
      }, snapshotsByPath[p]);
    });
  }

  clearHistory() {
    this.setHistory([]);
  }

}

exports.WholeFileDiscardHistory = WholeFileDiscardHistory;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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