/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.prism.sw;

import com.sun.glass.ui.Screen;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.Image;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.scenario.effect.impl.HeapImage;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import java.nio.IntBuffer;
import java.util.Arrays;

public class PSWDrawable
extends PrDrawable
implements HeapImage {
    private RTTexture rtt;
    private Image image;
    private boolean heapDirty;
    private boolean vramDirty;

    private PSWDrawable(RTTexture rtt, boolean isDirty) {
        super(rtt);
        this.rtt = rtt;
        this.vramDirty = isDirty;
    }

    public static PSWDrawable create(RTTexture rtt) {
        return new PSWDrawable(rtt, true);
    }

    static int getCompatibleWidth(Screen screen, int w) {
        ResourceFactory factory = GraphicsPipeline.getPipeline().getResourceFactory(screen);
        return factory.getRTTWidth(w, Texture.WrapMode.CLAMP_TO_ZERO);
    }

    static int getCompatibleHeight(Screen screen, int h) {
        ResourceFactory factory = GraphicsPipeline.getPipeline().getResourceFactory(screen);
        return factory.getRTTHeight(h, Texture.WrapMode.CLAMP_TO_ZERO);
    }

    static PSWDrawable create(Screen screen, int width, int height) {
        ResourceFactory factory = GraphicsPipeline.getPipeline().getResourceFactory(screen);
        RTTexture rtt = factory.createRTTexture(width, height, Texture.WrapMode.CLAMP_TO_ZERO);
        return new PSWDrawable(rtt, false);
    }

    @Override
    public boolean isLost() {
        return this.rtt == null || this.rtt.isSurfaceLost();
    }

    @Override
    public void flush() {
        if (this.rtt != null) {
            this.rtt.dispose();
            this.rtt = null;
            this.image = null;
        }
    }

    @Override
    public Object getData() {
        return this;
    }

    @Override
    public int getContentWidth() {
        return this.rtt.getContentWidth();
    }

    @Override
    public int getContentHeight() {
        return this.rtt.getContentHeight();
    }

    @Override
    public int getMaxContentWidth() {
        return this.rtt.getMaxContentWidth();
    }

    @Override
    public int getMaxContentHeight() {
        return this.rtt.getMaxContentHeight();
    }

    @Override
    public void setContentWidth(int contentW) {
        this.rtt.setContentWidth(contentW);
    }

    @Override
    public void setContentHeight(int contentH) {
        this.rtt.setContentHeight(contentH);
    }

    @Override
    public int getPhysicalWidth() {
        return this.rtt.getContentWidth();
    }

    @Override
    public int getPhysicalHeight() {
        return this.rtt.getContentHeight();
    }

    @Override
    public int getScanlineStride() {
        return this.rtt.getContentWidth();
    }

    @Override
    public int[] getPixelArray() {
        int[] pixels = this.rtt.getPixels();
        if (pixels != null) {
            return pixels;
        }
        if (this.image == null) {
            int width = this.rtt.getContentWidth();
            int height = this.rtt.getContentHeight();
            pixels = new int[width * height];
            this.image = Image.fromIntArgbPreData(pixels, width, height);
        }
        IntBuffer buf = (IntBuffer)this.image.getPixelBuffer();
        if (this.vramDirty) {
            this.rtt.readPixels(buf);
            this.vramDirty = false;
        }
        this.heapDirty = true;
        return buf.array();
    }

    @Override
    public RTTexture getTextureObject() {
        if (this.heapDirty) {
            int width = this.rtt.getContentWidth();
            int height = this.rtt.getContentHeight();
            Screen screen = this.rtt.getAssociatedScreen();
            ResourceFactory factory = GraphicsPipeline.getPipeline().getResourceFactory(screen);
            Texture tex = factory.createTexture(this.image, Texture.Usage.DEFAULT, Texture.WrapMode.CLAMP_TO_EDGE);
            Graphics g = this.createGraphics();
            g.drawTexture(tex, 0.0f, 0.0f, width, height);
            g.sync();
            tex.dispose();
            this.heapDirty = false;
        }
        return this.rtt;
    }

    @Override
    public Graphics createGraphics() {
        this.vramDirty = true;
        return this.rtt.createGraphics();
    }

    @Override
    public void clear() {
        Graphics g = this.createGraphics();
        g.clear();
        if (this.image != null) {
            IntBuffer buf = (IntBuffer)this.image.getPixelBuffer();
            Arrays.fill(buf.array(), 0);
        }
        this.heapDirty = false;
        this.vramDirty = false;
    }
}

