/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.prism.ps;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.Texture;
import com.sun.prism.ps.Shader;
import com.sun.prism.ps.ShaderGraphics;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.prism.PrTexture;
import com.sun.scenario.effect.impl.prism.ps.PPSDrawable;
import com.sun.scenario.effect.impl.prism.ps.PPSEffectPeer;
import com.sun.scenario.effect.impl.prism.ps.PPSRenderer;
import com.sun.scenario.effect.impl.state.RenderState;

public abstract class PPSOneSamplerPeer<T extends RenderState>
extends PPSEffectPeer<T> {
    private Shader shader;

    protected PPSOneSamplerPeer(FilterContext fctx, Renderer r, String shaderName) {
        super(fctx, r, shaderName);
    }

    @Override
    public void dispose() {
        if (this.shader != null) {
            this.shader.dispose();
        }
    }

    @Override
    ImageData filterImpl(ImageData ... inputs) {
        Filterable srcF = inputs[0].getUntransformedImage();
        PrTexture srcTex = (PrTexture)((Object)srcF);
        Rectangle srcBounds = inputs[0].getUntransformedBounds();
        Rectangle dstBounds = this.getDestBounds();
        int dstw = dstBounds.width;
        int dsth = dstBounds.height;
        PPSRenderer renderer = this.getRenderer();
        PPSDrawable dst = renderer.getCompatibleImage(dstw, dsth);
        if (dst == null) {
            renderer.markLost();
            return new ImageData(this.getFilterContext(), dst, dstBounds);
        }
        this.setDestNativeBounds(dst.getPhysicalWidth(), dst.getPhysicalHeight());
        BaseTransform srcTransform = inputs[0].getTransform();
        this.setInputBounds(0, srcBounds);
        this.setInputTransform(0, srcTransform);
        this.setInputNativeBounds(0, srcTex.getNativeBounds());
        float[] srcRect = new float[8];
        int srcCoords = this.getTextureCoordinates(0, srcRect, srcBounds.x, srcBounds.y, srcF.getPhysicalWidth(), srcF.getPhysicalHeight(), dstBounds, srcTransform);
        ShaderGraphics g = dst.createGraphics();
        if (g == null) {
            renderer.markLost();
            return new ImageData(this.getFilterContext(), dst, dstBounds);
        }
        if (this.shader == null) {
            this.shader = this.createShader();
        }
        if (this.shader == null || !this.shader.isValid()) {
            renderer.markLost();
            return new ImageData(this.getFilterContext(), dst, dstBounds);
        }
        g.setExternalShader(this.shader);
        this.updateShader(this.shader);
        float dx1 = 0.0f;
        float dy1 = 0.0f;
        float dx2 = dstw;
        float dy2 = dsth;
        Object ptex = srcTex.getTextureObject();
        if (ptex == null) {
            renderer.markLost();
            return new ImageData(this.getFilterContext(), dst, dstBounds);
        }
        float txoff = (float)ptex.getContentX() / (float)ptex.getPhysicalWidth();
        float tyoff = (float)ptex.getContentY() / (float)ptex.getPhysicalHeight();
        float tx11 = txoff + srcRect[0];
        float ty11 = tyoff + srcRect[1];
        float tx22 = txoff + srcRect[2];
        float ty22 = tyoff + srcRect[3];
        if (srcCoords < 8) {
            g.drawTextureRaw((Texture)ptex, dx1, dy1, dx2, dy2, tx11, ty11, tx22, ty22);
        } else {
            float tx21 = txoff + srcRect[4];
            float ty21 = tyoff + srcRect[5];
            float tx12 = txoff + srcRect[6];
            float ty12 = tyoff + srcRect[7];
            g.drawMappedTextureRaw((Texture)ptex, dx1, dy1, dx2, dy2, tx11, ty11, tx21, ty21, tx12, ty12, tx22, ty22);
        }
        g.setExternalShader(null);
        return new ImageData(this.getFilterContext(), dst, dstBounds);
    }
}

