#ifndef _EFL_TEXT_FORMAT_EO_H_
#define _EFL_TEXT_FORMAT_EO_H_

#ifndef _EFL_TEXT_FORMAT_EO_CLASS_TYPE
#define _EFL_TEXT_FORMAT_EO_CLASS_TYPE

typedef Eo Efl_Text_Format;

#endif

#ifndef _EFL_TEXT_FORMAT_EO_TYPES
#define _EFL_TEXT_FORMAT_EO_TYPES

#ifdef EFL_BETA_API_SUPPORT
/** Wrap mode of the text (not in effect if not multiline)
 *
 * @ingroup Efl
 */
typedef enum
{
  EFL_TEXT_FORMAT_WRAP_NONE = 0, /**< No wrapping */
  EFL_TEXT_FORMAT_WRAP_CHAR, /**< Wrap mode character */
  EFL_TEXT_FORMAT_WRAP_WORD, /**< Wrap mode word */
  EFL_TEXT_FORMAT_WRAP_MIXED, /**< Wrap mode mixed */
  EFL_TEXT_FORMAT_WRAP_HYPHENATION /**< Wrap mode hyphenation */
} Efl_Text_Format_Wrap;
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/** Auto-horizontal alignment of the text
 *
 * @ingroup Efl
 */
typedef enum
{
  EFL_TEXT_FORMAT_HORIZONTAL_ALIGNMENT_AUTO_TYPE_NONE = 0, /**< No
                                                            * auto-alignment
                                                            * rule */
  EFL_TEXT_FORMAT_HORIZONTAL_ALIGNMENT_AUTO_TYPE_NORMAL, /**< Respects LTR/RTL
                                                          * (bidirectional)
                                                          * settings */
  EFL_TEXT_FORMAT_HORIZONTAL_ALIGNMENT_AUTO_TYPE_LOCALE, /**< Respects locale's
                                                          * langauge settings
                                                          */
  EFL_TEXT_FORMAT_HORIZONTAL_ALIGNMENT_AUTO_TYPE_END /**< Text is places at
                                                      * opposite side of
                                                      * LTR/RTL (bidirectional)
                                                      * settings */
} Efl_Text_Format_Horizontal_Alignment_Auto_Type;
#endif /* EFL_BETA_API_SUPPORT */


#endif
#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief The look and layout of the text
 *
 * The text format can affect the geometry of the text object, as well as how
 * characters are presented.
 *
 * @ingroup Efl_Text_Format
 */
#define EFL_TEXT_FORMAT_INTERFACE efl_text_format_interface_get()

EWAPI const Efl_Class *efl_text_format_interface_get(void);

/**
 * @brief Ellipsis value (number from -1.0 to 1.0)
 *
 * @param[in] obj The object.
 * @param[in] value Ellipsis value
 *
 * @ingroup Efl_Text_Format
 */
EOAPI void efl_text_ellipsis_set(Eo *obj, double value);

/**
 * @brief Ellipsis value (number from -1.0 to 1.0)
 *
 * @param[in] obj The object.
 *
 * @return Ellipsis value
 *
 * @ingroup Efl_Text_Format
 */
EOAPI double efl_text_ellipsis_get(const Eo *obj);

/**
 * @brief Wrap mode for use in the text
 *
 * @param[in] obj The object.
 * @param[in] wrap Wrap mode
 *
 * @ingroup Efl_Text_Format
 */
EOAPI void efl_text_wrap_set(Eo *obj, Efl_Text_Format_Wrap wrap);

/**
 * @brief Wrap mode for use in the text
 *
 * @param[in] obj The object.
 *
 * @return Wrap mode
 *
 * @ingroup Efl_Text_Format
 */
EOAPI Efl_Text_Format_Wrap efl_text_wrap_get(const Eo *obj);

/**
 * @brief Multiline is enabled or not
 *
 * @param[in] obj The object.
 * @param[in] enabled @c true if multiline is enabled, @c false otherwise
 *
 * @ingroup Efl_Text_Format
 */
EOAPI void efl_text_multiline_set(Eo *obj, Eina_Bool enabled);

/**
 * @brief Multiline is enabled or not
 *
 * @param[in] obj The object.
 *
 * @return @c true if multiline is enabled, @c false otherwise
 *
 * @ingroup Efl_Text_Format
 */
EOAPI Eina_Bool efl_text_multiline_get(const Eo *obj);

/**
 * @brief Horizontal alignment of text
 *
 * @param[in] obj The object.
 * @param[in] value Alignment type
 *
 * @ingroup Efl_Text_Format
 */
EOAPI void efl_text_halign_auto_type_set(Eo *obj, Efl_Text_Format_Horizontal_Alignment_Auto_Type value);

/**
 * @brief Horizontal alignment of text
 *
 * @param[in] obj The object.
 *
 * @return Alignment type
 *
 * @ingroup Efl_Text_Format
 */
EOAPI Efl_Text_Format_Horizontal_Alignment_Auto_Type efl_text_halign_auto_type_get(const Eo *obj);

/**
 * @brief Horizontal alignment of text
 *
 * @param[in] obj The object.
 * @param[in] value Horizontal alignment value
 *
 * @ingroup Efl_Text_Format
 */
EOAPI void efl_text_halign_set(Eo *obj, double value);

/**
 * @brief Horizontal alignment of text
 *
 * @param[in] obj The object.
 *
 * @return Horizontal alignment value
 *
 * @ingroup Efl_Text_Format
 */
EOAPI double efl_text_halign_get(const Eo *obj);

/**
 * @brief Vertical alignment of text
 *
 * @param[in] obj The object.
 * @param[in] value Vertical alignment value
 *
 * @ingroup Efl_Text_Format
 */
EOAPI void efl_text_valign_set(Eo *obj, double value);

/**
 * @brief Vertical alignment of text
 *
 * @param[in] obj The object.
 *
 * @return Vertical alignment value
 *
 * @ingroup Efl_Text_Format
 */
EOAPI double efl_text_valign_get(const Eo *obj);

/**
 * @brief Minimal line gap (top and bottom) for each line in the text
 *
 * @c value is absolute size.
 *
 * @param[in] obj The object.
 * @param[in] value Line gap value
 *
 * @ingroup Efl_Text_Format
 */
EOAPI void efl_text_linegap_set(Eo *obj, double value);

/**
 * @brief Minimal line gap (top and bottom) for each line in the text
 *
 * @c value is absolute size.
 *
 * @param[in] obj The object.
 *
 * @return Line gap value
 *
 * @ingroup Efl_Text_Format
 */
EOAPI double efl_text_linegap_get(const Eo *obj);

/**
 * @brief Relative line gap (top and bottom) for each line in the text
 *
 * The original line gap value is multiplied by @c value.
 *
 * @param[in] obj The object.
 * @param[in] value Relative line gap value
 *
 * @ingroup Efl_Text_Format
 */
EOAPI void efl_text_linerelgap_set(Eo *obj, double value);

/**
 * @brief Relative line gap (top and bottom) for each line in the text
 *
 * The original line gap value is multiplied by @c value.
 *
 * @param[in] obj The object.
 *
 * @return Relative line gap value
 *
 * @ingroup Efl_Text_Format
 */
EOAPI double efl_text_linerelgap_get(const Eo *obj);

/**
 * @brief Tabstops value
 *
 * @param[in] obj The object.
 * @param[in] value Tapstops value
 *
 * @ingroup Efl_Text_Format
 */
EOAPI void efl_text_tabstops_set(Eo *obj, int value);

/**
 * @brief Tabstops value
 *
 * @param[in] obj The object.
 *
 * @return Tapstops value
 *
 * @ingroup Efl_Text_Format
 */
EOAPI int efl_text_tabstops_get(const Eo *obj);

/**
 * @brief Whether text is a password
 *
 * @param[in] obj The object.
 * @param[in] enabled @c true if the text is a password, @c false otherwise
 *
 * @ingroup Efl_Text_Format
 */
EOAPI void efl_text_password_set(Eo *obj, Eina_Bool enabled);

/**
 * @brief Whether text is a password
 *
 * @param[in] obj The object.
 *
 * @return @c true if the text is a password, @c false otherwise
 *
 * @ingroup Efl_Text_Format
 */
EOAPI Eina_Bool efl_text_password_get(const Eo *obj);

/**
 * @brief The character used to replace characters that can't be displayed
 *
 * Currently only used to replace characters if @ref efl_text_password_get is
 * enabled.
 *
 * @param[in] obj The object.
 * @param[in] repch Replacement character
 *
 * @ingroup Efl_Text_Format
 */
EOAPI void efl_text_replacement_char_set(Eo *obj, const char *repch);

/**
 * @brief The character used to replace characters that can't be displayed
 *
 * Currently only used to replace characters if @ref efl_text_password_get is
 * enabled.
 *
 * @param[in] obj The object.
 *
 * @return Replacement character
 *
 * @ingroup Efl_Text_Format
 */
EOAPI const char *efl_text_replacement_char_get(const Eo *obj);
#endif /* EFL_BETA_API_SUPPORT */

#endif
