/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.system;

public class Timer {
    private long startTime = 0L;
    private long endTime = 0L;

    public void start() {
        this.startTime = this.endTime = System.nanoTime();
    }

    public void end() {
        this.endTime = System.nanoTime();
    }

    public long nanos() {
        return this.endTime - this.startTime;
    }

    public double seconds() {
        return (double)(this.endTime - this.startTime) * 1.0E-9;
    }

    public static String toString(long l) {
        Timer timer = new Timer();
        timer.endTime = l;
        return timer.toString();
    }

    public static String toString(double d) {
        Timer timer = new Timer();
        timer.endTime = (long)(d * 1.0E9);
        return timer.toString();
    }

    public String toString() {
        long l = this.nanos() / 1000000L;
        if (l < 10000L) {
            return String.format("%dms", l);
        }
        long l2 = l / 3600000L;
        long l3 = (l -= l2 * 60L * 60L * 1000L) / 60000L;
        long l4 = (l -= l3 * 60L * 1000L) / 1000L;
        return String.format("%d:%02d:%02d.%1d", l2, l3, l4, (l -= l4 * 1000L) / 100L);
    }
}

