/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.primitive;

import org.sunflow.SunflowAPI;
import org.sunflow.core.Instance;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.ShadingState;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.MathUtils;
import org.sunflow.math.Matrix4;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;

public class SphereFlake
implements PrimitiveList {
    private static final int MAX_LEVEL = 20;
    private static final float[] boundingRadiusOffset;
    private static final float[] recursivePattern;
    private int level = 2;
    private Vector3 axis = new Vector3(0.0f, 0.0f, 1.0f);
    private float baseRadius = 1.0f;

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.level = MathUtils.clamp(parameterList.getInt("level", this.level), 0, 20);
        this.axis = parameterList.getVector("axis", this.axis);
        this.axis.normalize();
        this.baseRadius = Math.abs(parameterList.getFloat("radius", this.baseRadius));
        return true;
    }

    public BoundingBox getWorldBounds(Matrix4 matrix4) {
        BoundingBox boundingBox = new BoundingBox(this.getPrimitiveBound(0, 1));
        if (matrix4 != null) {
            boundingBox = matrix4.transform(boundingBox);
        }
        return boundingBox;
    }

    public float getPrimitiveBound(int n, int n2) {
        float f = 1.0f + boundingRadiusOffset[this.level];
        return (n2 & 1) == 0 ? -f : f;
    }

    public int getNumPrimitives() {
        return 1;
    }

    public void prepareShadingState(ShadingState shadingState) {
        shadingState.init();
        shadingState.getRay().getPoint(shadingState.getPoint());
        Instance instance = shadingState.getInstance();
        Point3 point3 = shadingState.transformWorldToObject(shadingState.getPoint());
        float f = shadingState.getU();
        float f2 = shadingState.getV();
        float f3 = shadingState.getW();
        shadingState.getNormal().set(point3.x - f, point3.y - f2, point3.z - f3);
        shadingState.getNormal().normalize();
        float f4 = (float)Math.atan2(shadingState.getNormal().y, shadingState.getNormal().x);
        if (f4 < 0.0f) {
            f4 = (float)((double)f4 + Math.PI * 2);
        }
        float f5 = (float)Math.acos(shadingState.getNormal().z);
        shadingState.getUV().y = f5 / (float)Math.PI;
        shadingState.getUV().x = f4 / ((float)Math.PI * 2);
        Vector3 vector3 = new Vector3();
        vector3.x = (float)Math.PI * -2 * shadingState.getNormal().y;
        vector3.y = (float)Math.PI * 2 * shadingState.getNormal().x;
        vector3.z = 0.0f;
        shadingState.setShader(instance.getShader(0));
        shadingState.setModifier(instance.getModifier(0));
        Vector3 vector32 = shadingState.transformNormalObjectToWorld(shadingState.getNormal());
        vector3 = shadingState.transformVectorObjectToWorld(vector3);
        shadingState.getNormal().set(vector32);
        shadingState.getNormal().normalize();
        shadingState.getGeoNormal().set(shadingState.getNormal());
        shadingState.setBasis(OrthoNormalBasis.makeFromWV(shadingState.getNormal(), vector3));
    }

    public void intersectPrimitive(Ray ray, int n, IntersectionState intersectionState) {
        float f = ray.dx * ray.dx + ray.dy * ray.dy + ray.dz * ray.dz;
        this.intersectFlake(ray, intersectionState, this.level, f, 1.0f / f, 0.0f, 0.0f, 0.0f, this.axis.x, this.axis.y, this.axis.z, this.baseRadius);
    }

    private void intersectFlake(Ray ray, IntersectionState intersectionState, int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (n <= 0) {
            float f10 = f3 - ray.ox;
            float f11 = f4 - ray.oy;
            float f12 = f5 - ray.oz;
            float f13 = ray.dx * f10 + ray.dy * f11 + ray.dz * f12;
            float f14 = f13 * f13 - f * (f10 * f10 + f11 * f11 + f12 * f12 - f9 * f9);
            if (f14 > 0.0f) {
                float f15 = (float)Math.sqrt(f14);
                float f16 = (f13 - f15) * f2;
                float f17 = (f13 + f15) * f2;
                if (f16 >= ray.getMax() || f17 <= ray.getMin()) {
                    return;
                }
                if (f16 > ray.getMin()) {
                    ray.setMax(f16);
                } else {
                    ray.setMax(f17);
                }
                intersectionState.setIntersection(0, f3, f4, f5);
            }
        } else {
            float f18 = f3 - ray.ox;
            float f19 = f4 - ray.oy;
            float f20 = f5 - ray.oz;
            float f21 = ray.dx * f18 + ray.dy * f19 + ray.dz * f20;
            float f22 = f18 * f18 + f19 * f19 + f20 * f20;
            float f23 = f9 * (1.0f + boundingRadiusOffset[n]);
            float f24 = f21 * f21 - f * (f22 - f23 * f23);
            if (f24 > 0.0f) {
                float f25;
                float f26;
                float f27;
                float f28 = (float)Math.sqrt(f24);
                float f29 = (f21 - f28) * f2;
                float f30 = (f21 + f28) * f2;
                if (f29 >= ray.getMax() || f30 <= ray.getMin()) {
                    return;
                }
                f24 = f21 * f21 - f * (f22 - f9 * f9);
                if (f24 > 0.0f) {
                    f28 = (float)Math.sqrt(f24);
                    f29 = (f21 - f28) * f2;
                    f30 = (f21 + f28) * f2;
                    if (!(f29 >= ray.getMax()) && !(f30 <= ray.getMin())) {
                        if (f29 > ray.getMin()) {
                            ray.setMax(f29);
                        } else {
                            ray.setMax(f30);
                        }
                        intersectionState.setIntersection(0, f3, f4, f5);
                    }
                }
                if (f6 * f6 < f7 * f7 && f6 * f6 < f8 * f8) {
                    f27 = 0.0f;
                    f26 = f8;
                    f25 = -f7;
                } else if (f7 * f7 < f8 * f8) {
                    f27 = f8;
                    f26 = 0.0f;
                    f25 = -f6;
                } else {
                    f27 = f7;
                    f26 = -f6;
                    f25 = 0.0f;
                }
                float f31 = 1.0f / (float)Math.sqrt(f27 * f27 + f26 * f26 + f25 * f25);
                float f32 = f7 * (f25 *= f31) - f8 * (f26 *= f31);
                float f33 = f8 * (f27 *= f31) - f6 * f25;
                float f34 = f6 * f26 - f7 * f27;
                f27 = f7 * f34 - f8 * f33;
                f26 = f8 * f32 - f6 * f34;
                f25 = f6 * f33 - f7 * f32;
                float f35 = f9 * 0.33333334f;
                float f36 = f9 + f35;
                for (int i = 0; i < 27; i += 3) {
                    float f37 = recursivePattern[i] * f6 + recursivePattern[i + 1] * f27 + recursivePattern[i + 2] * f32;
                    float f38 = recursivePattern[i] * f7 + recursivePattern[i + 1] * f26 + recursivePattern[i + 2] * f33;
                    float f39 = recursivePattern[i] * f8 + recursivePattern[i + 1] * f25 + recursivePattern[i + 2] * f34;
                    this.intersectFlake(ray, intersectionState, n - 1, f, f2, f3 + f36 * f37, f4 + f36 * f38, f5 + f36 * f39, f37, f38, f39, f35);
                }
            }
        }
    }

    public PrimitiveList getBakingPrimitives() {
        return null;
    }

    static {
        int n;
        boundingRadiusOffset = new float[21];
        recursivePattern = new float[27];
        int n2 = 0;
        int n3 = 3;
        while (n2 < boundingRadiusOffset.length) {
            SphereFlake.boundingRadiusOffset[n2] = ((float)n3 - 3.0f) / (float)n3;
            ++n2;
            n3 *= 3;
        }
        double d = 0.0;
        double d2 = 1.0471975511965976;
        double d3 = 2.0943951023931953;
        for (n = 0; n < 6; ++n) {
            SphereFlake.recursivePattern[3 * n + 0] = -0.3f;
            SphereFlake.recursivePattern[3 * n + 1] = (float)Math.sin(d);
            SphereFlake.recursivePattern[3 * n + 2] = (float)Math.cos(d);
            d += d2;
        }
        d -= d2 / 2.0;
        for (n = 6; n < 9; ++n) {
            SphereFlake.recursivePattern[3 * n + 0] = 0.7f;
            SphereFlake.recursivePattern[3 * n + 1] = (float)Math.sin(d);
            SphereFlake.recursivePattern[3 * n + 2] = (float)Math.cos(d);
            d += d3;
        }
        for (n = 0; n < recursivePattern.length; n += 3) {
            float f = recursivePattern[n + 0];
            float f2 = recursivePattern[n + 1];
            float f3 = recursivePattern[n + 2];
            float f4 = 1.0f / (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
            SphereFlake.recursivePattern[n + 0] = f * f4;
            SphereFlake.recursivePattern[n + 1] = f2 * f4;
            SphereFlake.recursivePattern[n + 2] = f3 * f4;
        }
    }
}

