/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.obr.xml;

import java.text.ParseException;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.obr.filter.AndFilter;
import org.apache.ivy.osgi.obr.filter.CompareFilter;
import org.apache.ivy.osgi.obr.filter.NotFilter;
import org.apache.ivy.osgi.obr.xml.Requirement;
import org.apache.ivy.osgi.obr.xml.RequirementFilter;
import org.apache.ivy.osgi.obr.xml.UnsupportedFilterException;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.osgi.util.VersionRange;

public class RequirementAdapter {
    private Version startVersion = null;
    private boolean startExclusive = false;
    private Version endVersion = null;
    private boolean endExclusive = false;
    private String type = null;
    private String name = null;

    public static void adapt(BundleInfo bundleInfo, Requirement requirement) throws UnsupportedFilterException, ParseException {
        RequirementAdapter requirementAdapter = new RequirementAdapter();
        requirementAdapter.extractFilter(requirement.getFilter());
        requirementAdapter.adapt(bundleInfo, requirement.isOptional());
    }

    private void extractFilter(RequirementFilter requirementFilter) throws UnsupportedFilterException, ParseException {
        if (requirementFilter instanceof AndFilter) {
            AndFilter andFilter = (AndFilter)requirementFilter;
            for (RequirementFilter requirementFilter2 : andFilter.getSubFilters()) {
                this.extractFilter(requirementFilter2);
            }
        } else if (requirementFilter instanceof CompareFilter) {
            CompareFilter compareFilter = (CompareFilter)requirementFilter;
            this.parseCompareFilter(compareFilter, false);
        } else if (requirementFilter instanceof NotFilter) {
            NotFilter notFilter = (NotFilter)requirementFilter;
            if (notFilter.getSubFilter() instanceof CompareFilter) {
                CompareFilter compareFilter = (CompareFilter)notFilter.getSubFilter();
                this.parseCompareFilter(compareFilter, true);
            }
        } else {
            throw new UnsupportedFilterException("Unsupported filter: " + requirementFilter.getClass().getName());
        }
    }

    private void adapt(BundleInfo bundleInfo, boolean bl) throws ParseException {
        String string;
        VersionRange versionRange = this.getVersionRange();
        String string2 = string = bl ? "optional" : null;
        if (this.type == null) {
            throw new ParseException("No requirement actually specified", 0);
        }
        BundleRequirement bundleRequirement = new BundleRequirement(this.type, this.name, versionRange, string);
        bundleInfo.addRequirement(bundleRequirement);
    }

    private VersionRange getVersionRange() {
        VersionRange versionRange = null;
        if (this.startVersion != null || this.endVersion != null) {
            versionRange = new VersionRange(this.startExclusive, this.startVersion, this.endExclusive, this.endVersion);
        }
        return versionRange;
    }

    private void parseCompareFilter(CompareFilter compareFilter, boolean bl) throws UnsupportedFilterException, ParseException {
        String string = compareFilter.getLeftValue();
        if ("package".equals(string) || "bundle".equals(string) || "symbolicname".equals(string) || "service".equals(string)) {
            if (bl) {
                throw new UnsupportedFilterException("Not filter on requirement comparaison is not supported");
            }
            if (this.type != null) {
                throw new UnsupportedFilterException("Multiple requirement type are not supported");
            }
            this.type = "symbolicname".equals(string) ? "bundle" : string;
            if (compareFilter.getOperator() != CompareFilter.Operator.EQUALS) {
                throw new UnsupportedFilterException("Filtering is only supported with the operator '='");
            }
            this.name = compareFilter.getRightValue();
        } else if ("version".equals(string)) {
            Version version;
            String string2 = compareFilter.getRightValue();
            try {
                version = new Version(string2);
            }
            catch (ParseException parseException) {
                throw new ParseException("Ill formed version: " + string2, 0);
            }
            CompareFilter.Operator operator = compareFilter.getOperator();
            if (bl) {
                if (operator == CompareFilter.Operator.EQUALS) {
                    throw new UnsupportedFilterException("Not filter on equals comparaison is not supported");
                }
                if (operator == CompareFilter.Operator.GREATER_OR_EQUAL) {
                    operator = CompareFilter.Operator.LOWER_THAN;
                } else if (operator == CompareFilter.Operator.GREATER_THAN) {
                    operator = CompareFilter.Operator.LOWER_OR_EQUAL;
                } else if (operator == CompareFilter.Operator.LOWER_OR_EQUAL) {
                    operator = CompareFilter.Operator.GREATER_THAN;
                } else if (operator == CompareFilter.Operator.LOWER_THAN) {
                    operator = CompareFilter.Operator.GREATER_OR_EQUAL;
                }
            }
            if (operator == CompareFilter.Operator.EQUALS) {
                if (this.startVersion != null || this.endVersion != null) {
                    throw new UnsupportedFilterException("Multiple version matching is not supported");
                }
                this.startVersion = version;
                this.startExclusive = false;
                this.endVersion = version;
                this.endExclusive = false;
            } else if (operator == CompareFilter.Operator.GREATER_OR_EQUAL) {
                if (this.startVersion != null) {
                    throw new UnsupportedFilterException("Multiple version matching is not supported");
                }
                this.startVersion = version;
                this.startExclusive = false;
            } else if (operator == CompareFilter.Operator.GREATER_THAN) {
                if (this.startVersion != null) {
                    throw new UnsupportedFilterException("Multiple version matching is not supported");
                }
                this.startVersion = version;
                this.startExclusive = true;
            } else if (operator == CompareFilter.Operator.LOWER_OR_EQUAL) {
                if (this.endVersion != null) {
                    throw new UnsupportedFilterException("Multiple version matching is not supported");
                }
                this.endVersion = version;
                this.endExclusive = false;
            } else if (operator == CompareFilter.Operator.LOWER_THAN) {
                if (this.endVersion != null) {
                    throw new UnsupportedFilterException("Multiple version matching is not supported");
                }
                this.endVersion = version;
                this.endExclusive = true;
            }
        } else {
            throw new UnsupportedFilterException("Unsupported attribute: " + string);
        }
    }
}

