S2 = Manifold(2, 'S^2')
U = S2.open_subset('U')
XS = U.chart(r'th:(0,pi):\theta ph:(0,2*pi):\phi')
th, ph = XS[:]
R3 = Manifold(3, 'R^3')
X3 = R3.chart('x y z')
F = S2.diff_map(R3, {(XS, X3): [sin(th)*cos(ph), sin(th)*sin(ph),
                                cos(th)]}, name='F')
p = U.point((pi/4, 7*pi/4), name='p')
v = XS.frame()[1].at(p)
graph_v = v.plot(mapping=F)
graph_S2 = XS.plot(chart=X3, mapping=F, number_values=9)
sphinx_plot(graph_v + graph_S2)