/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.codeInsight.PyCustomMemberUtils;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyResolveResultRater;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.impl.references.PyReferenceImpl;
import com.jetbrains.python.psi.resolve.CompletionVariantsProcessor;
import com.jetbrains.python.psi.resolve.ImportedResolveResult;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveProcessor;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassMembersProvider;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyOverridingAncestorsClassMembersProvider;
import com.jetbrains.python.psi.types.PyOverridingClassMembersProvider;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.toolbox.Maybe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyClassTypeImpl
extends UserDataHolderBase
implements PyClassType {
    @NotNull
    protected final PyClass myClass;
    protected final boolean myIsDefinition;
    private static final ThreadLocal<Set<Pair<PyClass, String>>> ourResolveMemberStack = ThreadLocal.withInitial(() -> new HashSet());
    private static final Key<Set<PyClassType>> CTX_VISITED = Key.create((String)"PyClassType.Visited");
    public static final Key<Boolean> CTX_SUPPRESS_PARENTHESES = Key.create((String)"PyFunction.SuppressParentheses");

    public PyClassTypeImpl(@NotNull PyClass source, boolean isDefinition) {
        if (source == null) {
            PyClassTypeImpl.$$$reportNull$$$0(0);
        }
        PyClass originalElement = (PyClass)CompletionUtil.getOriginalElement((PsiElement)source);
        this.myClass = originalElement != null ? originalElement : source;
        this.myIsDefinition = isDefinition;
    }

    public <T> PyClassTypeImpl withUserData(Key<T> key, T value) {
        this.putUserData(key, value);
        return this;
    }

    @Override
    @NotNull
    public PyClass getPyClass() {
        PyClass pyClass = this.myClass;
        if (pyClass == null) {
            PyClassTypeImpl.$$$reportNull$$$0(1);
        }
        return pyClass;
    }

    @Override
    @NotNull
    public PyQualifiedNameOwner getDeclarationElement() {
        PyClass pyClass = this.getPyClass();
        if (pyClass == null) {
            PyClassTypeImpl.$$$reportNull$$$0(2);
        }
        return pyClass;
    }

    @Override
    public boolean isDefinition() {
        return this.myIsDefinition;
    }

    @Override
    @NotNull
    public PyClassType toInstance() {
        PyClassTypeImpl pyClassTypeImpl = this.myIsDefinition ? this.withUserDataCopy(new PyClassTypeImpl(this.myClass, false)) : this;
        if (pyClassTypeImpl == null) {
            PyClassTypeImpl.$$$reportNull$$$0(3);
        }
        return pyClassTypeImpl;
    }

    @Override
    @NotNull
    public PyClassLikeType toClass() {
        PyClassTypeImpl pyClassTypeImpl = this.myIsDefinition ? this : new PyClassTypeImpl(this.myClass, true);
        if (pyClassTypeImpl == null) {
            PyClassTypeImpl.$$$reportNull$$$0(4);
        }
        return pyClassTypeImpl;
    }

    @NotNull
    final <T extends PyClassTypeImpl> T withUserDataCopy(@NotNull T newInstance) {
        if (newInstance == null) {
            PyClassTypeImpl.$$$reportNull$$$0(5);
        }
        newInstance.setUserMap(this.getUserMap());
        T t = newInstance;
        if (t == null) {
            PyClassTypeImpl.$$$reportNull$$$0(6);
        }
        return t;
    }

    @Override
    @Nullable
    public String getClassQName() {
        return this.myClass.getQualifiedName();
    }

    @Override
    @NotNull
    public List<PyClassLikeType> getSuperClassTypes(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(7);
        }
        List<PyClassLikeType> list = this.myClass.getSuperClassTypes(context);
        if (list == null) {
            PyClassTypeImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        if (name == null) {
            PyClassTypeImpl.$$$reportNull$$$0(9);
        }
        if (direction == null) {
            PyClassTypeImpl.$$$reportNull$$$0(10);
        }
        if (resolveContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(11);
        }
        return this.resolveMember(name, location, direction, resolveContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext, boolean inherited) {
        Pair key;
        Set<Pair<PyClass, String>> resolving;
        if (name == null) {
            PyClassTypeImpl.$$$reportNull$$$0(12);
        }
        if (direction == null) {
            PyClassTypeImpl.$$$reportNull$$$0(13);
        }
        if (resolveContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(14);
        }
        if ((resolving = ourResolveMemberStack.get()).contains(key = Pair.create((Object)this.myClass, (Object)name))) {
            return Collections.emptyList();
        }
        resolving.add((Pair<PyClass, String>)key);
        try {
            List<? extends RatedResolveResult> list = this.doResolveMember(name, location, direction, resolveContext, inherited);
            return list;
        }
        finally {
            resolving.remove(key);
        }
    }

    @Nullable
    private List<? extends RatedResolveResult> doResolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext, boolean inherited) {
        List<? extends RatedResolveResult> typeMembers;
        PyType first_arg_type;
        PyExpression first_arg;
        Ref<ResolveResultList> resultRef;
        if (name == null) {
            PyClassTypeImpl.$$$reportNull$$$0(15);
        }
        if (direction == null) {
            PyClassTypeImpl.$$$reportNull$$$0(16);
        }
        if (resolveContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(17);
        }
        TypeEvalContext context = resolveContext.getTypeEvalContext();
        PsiElement classMember = PyClassTypeImpl.resolveByOverridingMembersProviders(this, name, (PsiElement)location, resolveContext);
        if (classMember != null) {
            return ResolveResultList.to(classMember);
        }
        if (resolveContext.allowProperties() && (resultRef = this.findProperty(name, direction, true, resolveContext.getTypeEvalContext())) != null) {
            return (List)resultRef.get();
        }
        if ("super".equals(this.getClassQName()) && this.isBuiltin() && location instanceof PyCallExpression && (first_arg = ((PyCallExpression)location).getArgument(0, PyExpression.class)) != null && (first_arg_type = context.getType(first_arg)) instanceof PyClassType) {
            PyClass derived_class = ((PyClassType)first_arg_type).getPyClass();
            Iterator<PyClass> base_it = derived_class.getAncestorClasses(context).iterator();
            if (base_it.hasNext()) {
                return new PyClassTypeImpl(base_it.next(), true).resolveMember(name, location, direction, resolveContext);
            }
            return null;
        }
        List<? extends RatedResolveResult> classMembers = PyClassTypeImpl.resolveInner(this.myClass, this.myIsDefinition, name, location, context);
        if ("__class__".equals(name)) {
            return this.resolveDunderClass(context, classMembers);
        }
        if (!classMembers.isEmpty()) {
            return classMembers;
        }
        if ("__doc__".equals(name)) {
            return Optional.ofNullable(PyBuiltinCache.getInstance((PsiElement)this.myClass).getObjectType()).map(type -> type.resolveMember(name, location, direction, resolveContext)).orElse(Collections.emptyList());
        }
        classMember = PyClassTypeImpl.resolveByOverridingAncestorsMembersProviders(this, name, location, resolveContext);
        if (classMember != null) {
            ResolveResultList list = new ResolveResultList();
            int rate = 0;
            for (PyResolveResultRater rater : PyResolveResultRater.EP_NAME.getExtensionList()) {
                rate += rater.getMemberRate(classMember, this, context);
            }
            list.poke(classMember, rate);
            return list;
        }
        if (inherited) {
            for (PyClassLikeType type2 : this.myClass.getAncestorTypes(context)) {
                List<? extends RatedResolveResult> results;
                if (type2 instanceof PyClassType) {
                    List<? extends RatedResolveResult> superMembers;
                    if (!this.myIsDefinition) {
                        type2 = (PyClassLikeType)type2.toInstance();
                    }
                    if (!(superMembers = PyClassTypeImpl.resolveInner(((PyClassType)type2).getPyClass(), this.myIsDefinition, name, location, context)).isEmpty()) {
                        return superMembers;
                    }
                }
                if (type2 == null || (results = type2.resolveMember(name, location, direction, resolveContext, false)) == null || results.isEmpty()) continue;
                return results;
            }
        }
        if (inherited && !"__init__".equals(name) && !"__new__".equals(name) && (typeMembers = this.resolveMetaClassMember(name, location, direction, resolveContext)) != null) {
            return typeMembers;
        }
        if (inherited) {
            classMember = PyClassTypeImpl.resolveByMembersProviders(this, name, (PsiElement)location, resolveContext);
        }
        if (classMember != null) {
            return ResolveResultList.to(classMember);
        }
        if (inherited) {
            for (PyClassLikeType type2 : this.myClass.getAncestorTypes(context)) {
                PyClass pyClass;
                PsiElement superMember;
                if (!(type2 instanceof PyClassType) || (superMember = PyClassTypeImpl.resolveByMembersProviders(new PyClassTypeImpl(pyClass = ((PyClassType)type2).getPyClass(), this.isDefinition()), name, (PsiElement)location, resolveContext)) == null) continue;
                return ResolveResultList.to(superMember);
            }
        }
        return Collections.emptyList();
    }

    @Nullable
    private List<? extends RatedResolveResult> resolveMetaClassMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        List typeInstanceAttributesWithSpecifiedName;
        List<PyTargetExpression> typeInstanceAttributes;
        TypeEvalContext context;
        if (name == null) {
            PyClassTypeImpl.$$$reportNull$$$0(18);
        }
        if (direction == null) {
            PyClassTypeImpl.$$$reportNull$$$0(19);
        }
        if (resolveContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(20);
        }
        if (!this.myClass.isNewStyleClass(context = resolveContext.getTypeEvalContext())) {
            return null;
        }
        PyClassLikeType typeType = this.getMetaClassType(context, true);
        if (typeType == null) {
            return null;
        }
        if (this.isDefinition()) {
            List<? extends RatedResolveResult> typeMembers = typeType.resolveMember(name, location, direction, resolveContext);
            if (!ContainerUtil.isEmpty(typeMembers)) {
                return typeMembers;
            }
            List<? extends RatedResolveResult> typeInstanceMembers = ((PyClassLikeType)typeType.toInstance()).resolveMember(name, location, direction, resolveContext);
            if (!ContainerUtil.isEmpty(typeInstanceMembers)) {
                return typeInstanceMembers;
            }
        } else if (typeType instanceof PyClassType && !ContainerUtil.isEmpty(typeInstanceAttributes = ((PyClassType)typeType).getPyClass().getInstanceAttributes()) && !(typeInstanceAttributesWithSpecifiedName = typeInstanceAttributes.stream().filter(member -> name.equals(member.getName())).map(member -> new RatedResolveResult(PyReferenceImpl.getRate(member, context), (PsiElement)member)).collect(Collectors.toList())).isEmpty()) {
            return typeInstanceAttributesWithSpecifiedName;
        }
        return null;
    }

    private Ref<ResolveResultList> findProperty(String name, AccessDirection direction, boolean inherited, @Nullable TypeEvalContext context) {
        Maybe<PyCallable> accessor;
        Ref resultRef = null;
        Property property = this.myClass.findProperty(name, inherited, context);
        if (property != null && (accessor = property.getByDirection(direction)).isDefined()) {
            PyTargetExpression site;
            PyCallable accessor_code = accessor.value();
            ResolveResultList ret = new ResolveResultList();
            if (accessor_code != null) {
                ret.poke((PsiElement)accessor_code, 0);
            }
            if ((site = property.getDefinitionSite()) != null) {
                ret.poke(site, -1000);
            }
            resultRef = ret.size() > 0 ? Ref.create((Object)ret) : Ref.create();
        }
        return resultRef;
    }

    @Nullable
    private List<? extends RatedResolveResult> resolveDunderClass(@NotNull TypeEvalContext context, @NotNull List<? extends RatedResolveResult> classMembers) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(21);
        }
        if (classMembers == null) {
            PyClassTypeImpl.$$$reportNull$$$0(22);
        }
        boolean newStyleClass = this.myClass.isNewStyleClass(context);
        if (!this.myIsDefinition) {
            if (newStyleClass && !classMembers.isEmpty()) {
                return classMembers;
            }
            return ResolveResultList.to(this.myClass.getAncestorClasses(context).stream().filter(cls -> !PyUtil.isObjectClass(cls)).map(cls -> cls.findClassAttribute("__class__", true, context)).filter(target -> target != null).findFirst().orElse((PsiElement)this.myClass));
        }
        if (LanguageLevel.forElement((PsiElement)this.myClass).isPython2() && !newStyleClass) {
            return classMembers;
        }
        return Optional.ofNullable(PyBuiltinCache.getInstance((PsiElement)this.myClass).getTypeType()).map(typeType -> ResolveResultList.to((PsiElement)typeType.getPyClass())).orElse(null);
    }

    @Override
    @Nullable
    public PyClassLikeType getMetaClassType(@NotNull TypeEvalContext context, boolean inherited) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(23);
        }
        return this.myClass.getMetaClassType(inherited, context);
    }

    @Override
    public boolean isCallable() {
        if (this.isDefinition()) {
            return true;
        }
        if (PyClassTypeImpl.isMethodType(this)) {
            return true;
        }
        PyClass cls = this.getPyClass();
        return PyABCUtil.isSubclass(cls, "Callable", null);
    }

    @Override
    @Nullable
    public List<PyCallableParameter> getParameters(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(24);
        }
        List<String> methodNames = this.isDefinition() ? Arrays.asList("__init__", "__new__") : Collections.singletonList("__call__");
        return StreamEx.of(methodNames).map(name -> this.getParametersOfMethod((String)name, context)).findFirst(Objects::nonNull).filter(parameters2 -> !parameters2.isEmpty()).map(parameters2 -> ContainerUtil.subList((List)parameters2, (int)1)).orElse(null);
    }

    @Nullable
    private List<PyCallableParameter> getParametersOfMethod(@NotNull String name, @NotNull TypeEvalContext context) {
        List<? extends RatedResolveResult> results;
        if (name == null) {
            PyClassTypeImpl.$$$reportNull$$$0(25);
        }
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(26);
        }
        if ((results = this.resolveMember(name, null, AccessDirection.READ, PyResolveContext.noImplicits().withTypeEvalContext(context), true)) != null) {
            return StreamEx.of(results).map(RatedResolveResult::getElement).select(PyCallable.class).map(func -> func.getParameters(context)).findFirst().orElse(null);
        }
        return null;
    }

    private static boolean isMethodType(@NotNull PyClassType type) {
        PyBuiltinCache builtinCache;
        if (type == null) {
            PyClassTypeImpl.$$$reportNull$$$0(27);
        }
        return type.equals((builtinCache = PyBuiltinCache.getInstance((PsiElement)type.getPyClass())).getClassMethodType()) || type.equals(builtinCache.getStaticMethodType()) || type.equals(builtinCache.getObjectType("function"));
    }

    @Override
    @Nullable
    public PyType getReturnType(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(28);
        }
        return this.getPossibleCallType(context, null);
    }

    @Override
    @Nullable
    public PyType getCallType(@NotNull TypeEvalContext context, @NotNull PyCallSiteExpression callSite) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(29);
        }
        if (callSite == null) {
            PyClassTypeImpl.$$$reportNull$$$0(30);
        }
        return this.getPossibleCallType(context, callSite);
    }

    @Nullable
    private PyType getPossibleCallType(@NotNull TypeEvalContext context, @Nullable PyCallSiteExpression callSite) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(31);
        }
        if (!this.isDefinition()) {
            return PyUtil.getReturnTypeOfMember(this, "__call__", callSite, context);
        }
        return this.withUserDataCopy(new PyClassTypeImpl(this.getPyClass(), false));
    }

    @Override
    @NotNull
    public List<PyClassLikeType> getAncestorTypes(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(32);
        }
        List list = this.myClass.getAncestorTypes(context);
        if (list == null) {
            PyClassTypeImpl.$$$reportNull$$$0(33);
        }
        return list;
    }

    @Nullable
    private static PsiElement resolveByMembersProviders(PyClassType aClass, String name, @Nullable PsiElement location, @NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(34);
        }
        for (PyClassMembersProvider provider : PyClassMembersProvider.EP_NAME.getExtensionList()) {
            PsiElement resolveResult = provider.resolveMember(aClass, name, location, resolveContext);
            if (resolveResult == null) continue;
            return resolveResult;
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveByOverridingMembersProviders(PyClassType aClass, String name, @Nullable PsiElement location, @NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(35);
        }
        for (PyClassMembersProvider provider : PyClassMembersProvider.EP_NAME.getExtensionList()) {
            PsiElement resolveResult;
            if (!(provider instanceof PyOverridingClassMembersProvider) || (resolveResult = provider.resolveMember(aClass, name, location, resolveContext)) == null) continue;
            return resolveResult;
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveByOverridingAncestorsMembersProviders(PyClassType type, String name, @Nullable PyExpression location, @NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(36);
        }
        for (PyClassMembersProvider provider : PyClassMembersProvider.EP_NAME.getExtensionList()) {
            PsiElement resolveResult;
            if (!(provider instanceof PyOverridingAncestorsClassMembersProvider) || (resolveResult = provider.resolveMember(type, name, (PsiElement)location, resolveContext)) == null) continue;
            return resolveResult;
        }
        return null;
    }

    @NotNull
    private static List<? extends RatedResolveResult> resolveInner(@NotNull PyClass cls, boolean isDefinition, @NotNull String name, @Nullable PyExpression location, @NotNull TypeEvalContext context) {
        Map<PsiElement, PyImportedNameDefiner> results;
        if (cls == null) {
            PyClassTypeImpl.$$$reportNull$$$0(37);
        }
        if (name == null) {
            PyClassTypeImpl.$$$reportNull$$$0(38);
        }
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(39);
        }
        PyResolveProcessor processor = new PyResolveProcessor(name);
        if (!isDefinition && !cls.processInstanceLevelDeclarations(processor, (PsiElement)location)) {
            results = processor.getResults();
        } else {
            cls.processClassLevelDeclarations(processor);
            results = processor.getResults();
        }
        List list = EntryStream.of(results).mapKeyValue((element, definer) -> {
            int rate = PyReferenceImpl.getRate(element, context);
            return definer != null ? new ImportedResolveResult((PsiElement)element, rate, (PyImportedNameDefiner)definer) : new RatedResolveResult(rate, (PsiElement)element);
        }).toList();
        if (list == null) {
            PyClassTypeImpl.$$$reportNull$$$0(40);
        }
        return list;
    }

    @Override
    @NotNull
    public Object[] getCompletionVariants(String prefix, PsiElement location, @NotNull ProcessingContext context) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(41);
        }
        if (this.isRecursive(context)) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                PyClassTypeImpl.$$$reportNull$$$0(42);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        Set<String> visited = PyClassTypeImpl.visitedNames(context);
        PsiFile origin = location != null ? CompletionUtil.getOriginalOrSelf((PsiElement)location).getContainingFile() : null;
        TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion(this.myClass.getProject(), origin);
        boolean withinOurClass = PyClassTypeImpl.withinClass(this.getPyClass(), location);
        Condition nameFilter = name -> {
            if (!withinOurClass && PyUtil.isClassPrivateName(name)) {
                return false;
            }
            if (!withinOurClass && PyClassTypeImpl.isClassProtected(name) && prefix == null) {
                return false;
            }
            return visited.add((String)name);
        };
        CompletionVariantsProcessor processor = new CompletionVariantsProcessor(location, null, (Condition<String>)nameFilter, false, context.get(CTX_SUPPRESS_PARENTHESES) != null);
        this.processMembers(processor, () -> processor.setAllowedNames(this.myClass.getSlots(typeEvalContext)));
        ArrayList<LookupElement> result = new ArrayList<LookupElement>(processor.getResultList());
        this.processOwnSlots((Processor<String>)((Processor)slot -> {
            if (visited.add((String)slot)) {
                result.add((LookupElement)LookupElementBuilder.create((String)slot));
            }
            return true;
        }), typeEvalContext);
        this.processProvidedMembers((Processor<PyCustomMember>)((Processor)member -> {
            if (visited.add(member.getName())) {
                result.add((LookupElement)PyCustomMemberUtils.toLookUpElement(member, this.getName()));
            }
            return true;
        }), location, typeEvalContext);
        this.prepareTypesForProcessingMembers(this.getSuperClassTypes(typeEvalContext)).flatArray(type -> type.getCompletionVariants(prefix, location, context)).into(result);
        this.processMetaClassMembers(typeType -> {
            List cfr_ignored_0 = (List)ContainerUtil.addAll((Collection)result, (Object[])typeType.getCompletionVariants(prefix, location, context));
        }, (Processor<? super PyTargetExpression>)((Processor)typeInstanceAttribute -> {
            result.add((LookupElement)LookupElementBuilder.create((PsiNamedElement)typeInstanceAttribute));
            return true;
        }), typeEvalContext);
        Object[] objectArray = result.toArray();
        if (objectArray == null) {
            PyClassTypeImpl.$$$reportNull$$$0(43);
        }
        return objectArray;
    }

    private boolean isRecursive(@NotNull ProcessingContext context) {
        HashSet<PyClassTypeImpl> types;
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(44);
        }
        if ((types = (HashSet<PyClassTypeImpl>)context.get(CTX_VISITED)) == null) {
            types = new HashSet<PyClassTypeImpl>();
            context.put(CTX_VISITED, types);
        }
        return !types.add(this);
    }

    @NotNull
    private static Set<String> visitedNames(@NotNull ProcessingContext context) {
        HashSet<String> names;
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(45);
        }
        if ((names = (HashSet<String>)context.get(CTX_NAMES)) == null) {
            names = new HashSet<String>();
            context.put(CTX_NAMES, names);
        }
        HashSet<String> hashSet = names;
        if (hashSet == null) {
            PyClassTypeImpl.$$$reportNull$$$0(46);
        }
        return hashSet;
    }

    private static boolean withinClass(@NotNull PyClass cls, @Nullable PsiElement location) {
        PyClass containingClass;
        if (cls == null) {
            PyClassTypeImpl.$$$reportNull$$$0(47);
        }
        if ((containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)location, PyClass.class)) != null) {
            containingClass = (PyClass)CompletionUtil.getOriginalElement((PsiElement)containingClass);
        }
        return containingClass == PyiUtil.getOriginalElementOrLeaveAsIs(cls, PyClass.class) || PyClassTypeImpl.isInSuperCall(location);
    }

    @Override
    public void visitMembers(@NotNull Processor<PsiElement> processor, boolean inherited, @NotNull TypeEvalContext context) {
        if (processor == null) {
            PyClassTypeImpl.$$$reportNull$$$0(48);
        }
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(49);
        }
        this.processMembers(processor);
        if (inherited) {
            this.prepareTypesForProcessingMembers(this.getAncestorTypes(context)).forEach(type -> type.visitMembers(processor, false, context));
            this.processMetaClassMembers(typeType -> typeType.visitMembers(processor, true, context), processor, context);
        }
    }

    @Override
    @NotNull
    public Set<String> getMemberNames(boolean inherited, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(50);
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        this.processMembers((Processor<PsiElement>)((Processor)element -> {
            if (element instanceof PsiNamedElement) {
                ContainerUtil.addIfNotNull((Collection)result, (Object)((PsiNamedElement)element).getName());
            }
            return true;
        }));
        this.processOwnSlots((Processor<String>)((Processor)slot -> {
            result.add((String)slot);
            return true;
        }), context);
        this.processProvidedMembers((Processor<PyCustomMember>)((Processor)member -> {
            result.add(member.getName());
            return true;
        }), null, context);
        if (inherited) {
            this.prepareTypesForProcessingMembers(this.getAncestorTypes(context)).flatCollection(type -> type.getMemberNames(false, context)).into(result);
            this.processMetaClassMembers(typeType -> result.addAll(typeType.getMemberNames(true, context)), (Processor<? super PyTargetExpression>)((Processor)instanceTypeAttribute -> {
                ContainerUtil.addIfNotNull((Collection)result, (Object)instanceTypeAttribute.getName());
                return true;
            }), context);
        }
        LinkedHashSet<String> linkedHashSet = result;
        if (linkedHashSet == null) {
            PyClassTypeImpl.$$$reportNull$$$0(51);
        }
        return linkedHashSet;
    }

    private void processMembers(final @NotNull Processor<PsiElement> processor) {
        if (processor == null) {
            PyClassTypeImpl.$$$reportNull$$$0(52);
        }
        PsiScopeProcessor scopeProcessor = new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return processor.process((Object)element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/psi/types/PyClassTypeImpl$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.processMembers(scopeProcessor, EmptyRunnable.getInstance());
    }

    private void processMembers(@NotNull PsiScopeProcessor scopeProcessor, @NotNull Runnable afterClassLevelBeforeInstanceLevel) {
        if (scopeProcessor == null) {
            PyClassTypeImpl.$$$reportNull$$$0(53);
        }
        if (afterClassLevelBeforeInstanceLevel == null) {
            PyClassTypeImpl.$$$reportNull$$$0(54);
        }
        this.myClass.processClassLevelDeclarations(scopeProcessor);
        afterClassLevelBeforeInstanceLevel.run();
        this.myClass.processInstanceLevelDeclarations(scopeProcessor, null);
    }

    private void processOwnSlots(@NotNull Processor<String> processor, @NotNull TypeEvalContext context) {
        if (processor == null) {
            PyClassTypeImpl.$$$reportNull$$$0(55);
        }
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(56);
        }
        if (this.myClass.isNewStyleClass(context)) {
            for (String slot : ContainerUtil.notNullize(this.myClass.getOwnSlots())) {
                if (processor.process((Object)slot)) continue;
                return;
            }
        }
    }

    private void processProvidedMembers(@NotNull Processor<PyCustomMember> processor, @Nullable PsiElement location, @NotNull TypeEvalContext context) {
        if (processor == null) {
            PyClassTypeImpl.$$$reportNull$$$0(57);
        }
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(58);
        }
        for (PyClassMembersProvider provider : PyClassMembersProvider.EP_NAME.getExtensionList()) {
            for (PyCustomMember member : provider.getMembers(this, location, context)) {
                if (processor.process((Object)member)) continue;
                return;
            }
        }
    }

    @NotNull
    private StreamEx<PyClassLikeType> prepareTypesForProcessingMembers(@NotNull List<PyClassLikeType> types) {
        if (types == null) {
            PyClassTypeImpl.$$$reportNull$$$0(59);
        }
        StreamEx streamEx = StreamEx.of(types).nonNull().map(type -> this.isDefinition() ? (PyClassLikeType)type.toClass() : (PyClassLikeType)type.toInstance());
        if (streamEx == null) {
            PyClassTypeImpl.$$$reportNull$$$0(60);
        }
        return streamEx;
    }

    private void processMetaClassMembers(@NotNull Consumer<PyClassLikeType> typeTypeConsumer, @NotNull Processor<? super PyTargetExpression> instanceTypeAttributesProcessor, @NotNull TypeEvalContext context) {
        if (typeTypeConsumer == null) {
            PyClassTypeImpl.$$$reportNull$$$0(61);
        }
        if (instanceTypeAttributesProcessor == null) {
            PyClassTypeImpl.$$$reportNull$$$0(62);
        }
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(63);
        }
        if (!this.myClass.isNewStyleClass(context)) {
            return;
        }
        PyClassLikeType typeType = this.getMetaClassType(context, true);
        if (typeType == null) {
            return;
        }
        if (this.isDefinition()) {
            typeTypeConsumer.accept(typeType);
        } else if (typeType instanceof PyClassType) {
            for (PyTargetExpression attribute : ((PyClassType)typeType).getPyClass().getInstanceAttributes()) {
                if (instanceTypeAttributesProcessor.process((Object)attribute)) continue;
                return;
            }
        }
    }

    private static boolean isInSuperCall(PsiElement hook) {
        if (hook instanceof PyReferenceExpression) {
            PyExpression qualifier = ((PyReferenceExpression)hook).getQualifier();
            return qualifier instanceof PyCallExpression && ((PyCallExpression)qualifier).isCalleeText("super");
        }
        return false;
    }

    private static boolean isClassProtected(@NotNull String lookupString) {
        if (lookupString == null) {
            PyClassTypeImpl.$$$reportNull$$$0(64);
        }
        return lookupString.startsWith("_") && !lookupString.startsWith("__");
    }

    @Override
    @Nullable
    public String getName() {
        return this.getPyClass().getName();
    }

    @Override
    public boolean isBuiltin() {
        return PyBuiltinCache.getInstance((PsiElement)this.myClass).isBuiltin((PsiElement)this.myClass);
    }

    @Override
    public void assertValid(String message) {
        if (!this.myClass.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)this.myClass, this.myClass.getClass().toString() + ": " + message);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyClassTypeImpl classType = (PyClassTypeImpl)o;
        if (this.myIsDefinition != classType.myIsDefinition) {
            return false;
        }
        return this.myClass.equals(classType.myClass);
    }

    public int hashCode() {
        int result = this.myClass.hashCode();
        result = 31 * result + (this.myIsDefinition ? 1 : 0);
        return result;
    }

    public String toString() {
        return (this.isValid() ? "" : "[INVALID] ") + "PyClassType: " + this.getClassQName();
    }

    @Override
    public boolean isValid() {
        return this.myClass.isValid();
    }

    @Override
    public boolean isAttributeWritable(@NotNull String name, @NotNull TypeEvalContext context) {
        if (name == null) {
            PyClassTypeImpl.$$$reportNull$$$0(65);
        }
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(66);
        }
        PyClass cls = this.getPyClass();
        if (this.isDefinition() || PyUtil.isObjectClass(cls)) {
            return true;
        }
        List<String> slots = cls.getSlots(context);
        Condition isDefinedTarget = target -> name.equals(target.getName()) && target.hasAssignedValue();
        return slots == null || slots.contains(name) && !ContainerUtil.exists(cls.getClassAttributesInherited(context), (Condition)isDefinedTarget) || cls.findProperty(name, true, context) != null;
    }

    @Nullable
    public static PyClassTypeImpl createTypeByQName(@NotNull PsiElement anchor, @NotNull String classQualifiedName, boolean isDefinition) {
        PyClass pyClass;
        if (anchor == null) {
            PyClassTypeImpl.$$$reportNull$$$0(67);
        }
        if (classQualifiedName == null) {
            PyClassTypeImpl.$$$reportNull$$$0(68);
        }
        if ((pyClass = PyPsiFacade.getInstance(anchor.getProject()).createClassByQName(classQualifiedName, anchor)) == null) {
            return null;
        }
        return new PyClassTypeImpl(pyClass, isDefinition);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 33: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 51: 
            case 60: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 33: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 51: 
            case 60: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 33: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 51: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyClassTypeImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInstance";
                break;
            }
            case 7: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 39: 
            case 41: 
            case 44: 
            case 45: 
            case 49: 
            case 50: 
            case 56: 
            case 58: 
            case 63: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 25: 
            case 38: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMembers";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 37: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 48: 
            case 52: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeProcessor";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterClassLevelBeforeInstanceLevel";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeTypeConsumer";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceTypeAttributesProcessor";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupString";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyClassTypeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPyClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toClass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withUserDataCopy";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClassTypes";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestorTypes";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionVariants";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "visitedNames";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberNames";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareTypesForProcessingMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 33: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 51: 
            case 60: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withUserDataCopy";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassTypes";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doResolveMember";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveMetaClassMember";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveDunderClass";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getMetaClassType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getParametersOfMethod";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isMethodType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleCallType";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getAncestorTypes";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "resolveByMembersProviders";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "resolveByOverridingMembersProviders";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "resolveByOverridingAncestorsMembersProviders";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "resolveInner";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionVariants";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isRecursive";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "visitedNames";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "withinClass";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "visitMembers";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getMemberNames";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "processMembers";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "processOwnSlots";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "processProvidedMembers";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "prepareTypesForProcessingMembers";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "processMetaClassMembers";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isClassProtected";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isAttributeWritable";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createTypeByQName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 33: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 51: 
            case 60: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

