/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.dvcs.DvcsRememberedInputs;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.AuthData;
import com.intellij.util.ObjectUtils;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import git4idea.DialogManager;
import git4idea.commands.GitAuthenticationGate;
import git4idea.commands.GitHttpAuthenticator;
import git4idea.commands.GitHttpLoginDialog;
import git4idea.remote.GitHttpAuthDataProvider;
import git4idea.remote.GitRememberedInputs;
import git4idea.remote.GitRepositoryHostingService;
import git4idea.remote.InteractiveGitHttpAuthDataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitHttpGuiAuthenticator
implements GitHttpAuthenticator {
    private static final Logger LOG = Logger.getInstance(GitHttpGuiAuthenticator.class);
    private static final Class<GitHttpAuthenticator> PASS_REQUESTER = GitHttpAuthenticator.class;
    public static final String HTTP_SCHEME_URL_PREFIX = "http://";
    @NotNull
    private final Project myProject;
    @Nullable
    private final String myPresetUrl;
    @NotNull
    private final GitAuthenticationGate myAuthenticationGate;
    private String myUnifiedUrl;
    private String myPassword;
    @NotNull
    private final PasswordSafeProvider myPasswordSafeProvider;
    @NotNull
    private final DialogProvider myDialogProvider;
    @NotNull
    private AuthDataProvider myCurrentProvider;

    GitHttpGuiAuthenticator(@NotNull Project project, @NotNull Collection<String> urls, @NotNull GitAuthenticationGate authenticationGate) {
        if (project == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(0);
        }
        if (urls == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(1);
        }
        if (authenticationGate == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(2);
        }
        this.myUnifiedUrl = null;
        this.myPassword = null;
        this.myProject = project;
        this.myPresetUrl = GitHttpGuiAuthenticator.findFirstHttpUrl(urls);
        this.myAuthenticationGate = authenticationGate;
        this.myPasswordSafeProvider = new PasswordSafeProvider(GitRememberedInputs.getInstance(), PasswordSafe.getInstance());
        this.myDialogProvider = new DialogProvider(this.myProject, this.myPasswordSafeProvider);
        this.myCurrentProvider = this.myPasswordSafeProvider;
    }

    @Nullable
    private static String findFirstHttpUrl(@NotNull Collection<String> urls) {
        if (urls == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(3);
        }
        return (String)ContainerUtil.find(urls, url -> ((String)UriUtil.splitScheme((String)url).getFirst()).startsWith("http"));
    }

    @Override
    @NotNull
    public String askPassword(@NotNull String url) {
        if (url == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(4);
        }
        if (this.wasCancelled()) {
            LOG.debug("askPassword. url=" + url + ", cancelled in askUsername");
            if ("" == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(5);
            }
            return "";
        }
        if (this.myPassword != null) {
            LOG.debug("askPassword. Data already filled in askUsername.");
            String string = (String)ObjectUtils.assertNotNull((Object)this.myPassword);
            if (string == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = this.myAuthenticationGate.waitAndCompute(() -> this.doAskPassword(url));
        if (string == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private String doAskPassword(@NotNull String url) {
        if (url == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(8);
        }
        Couple<String> usernameAndUrl = GitHttpGuiAuthenticator.splitToUsernameAndUnifiedUrl(this.getRequiredUrl(url));
        this.myUnifiedUrl = (String)usernameAndUrl.second;
        LOG.debug("askPassword. gitUrl=" + url + ", unifiedUrl=" + this.myUnifiedUrl);
        String login = (String)usernameAndUrl.first;
        if (login == null) {
            LOG.warn("askPassword. Could not find username");
            if ("" == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(9);
            }
            return "";
        }
        String password = null;
        for (AuthDataProvider delegate : this.getProviders()) {
            AuthData data = delegate.getDataForUser(this.myUnifiedUrl, login);
            if (data == null || data.getPassword() == null) continue;
            password = data.getPassword();
            this.myCurrentProvider = delegate;
            break;
        }
        LOG.debug("askPassword. provider=" + this.myCurrentProvider.getName() + ", login=" + login + ", passwordKnown=" + (password != null));
        if (this.wasCancelled()) {
            this.myAuthenticationGate.cancel();
        }
        String string = StringUtil.notNullize((String)password);
        if (string == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @NotNull
    public String askUsername(@NotNull String url) {
        if (url == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(11);
        }
        String string = this.myAuthenticationGate.waitAndCompute(() -> {
            this.myUnifiedUrl = (String)GitHttpGuiAuthenticator.splitToUsernameAndUnifiedUrl((String)this.getRequiredUrl((String)url)).second;
            LOG.debug("askUsername. gitUrl=" + url + ", unifiedUrl=" + this.myUnifiedUrl);
            String login = null;
            String password = null;
            for (AuthDataProvider provider : this.getProviders()) {
                AuthData data = provider.getData(this.myUnifiedUrl, login);
                if (data == null) continue;
                if (login == null) {
                    login = data.getLogin();
                    this.myCurrentProvider = provider;
                }
                if (data.getPassword() == null) continue;
                login = data.getLogin();
                password = data.getPassword();
                this.myCurrentProvider = provider;
                break;
            }
            LOG.debug("askUsername. provider=" + this.myCurrentProvider.getName() + ", login=" + login + ", passwordKnown=" + (password != null));
            if (login != null && password != null) {
                this.myPassword = password;
            }
            if (this.wasCancelled()) {
                this.myAuthenticationGate.cancel();
            }
            return StringUtil.notNullize((String)login);
        });
        if (string == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private List<AuthDataProvider> getProviders() {
        ArrayList<AuthDataProvider> delegates = new ArrayList<AuthDataProvider>();
        delegates.add(this.myPasswordSafeProvider);
        delegates.addAll(ContainerUtil.map((Object[])GitHttpAuthDataProvider.EP_NAME.getExtensions(), provider -> new ExtensionAdapterProvider(this.myProject, (GitHttpAuthDataProvider)provider)));
        delegates.add(this.myDialogProvider);
        ArrayList<AuthDataProvider> arrayList = delegates;
        if (arrayList == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Override
    public void saveAuthData() {
        if (this.myUnifiedUrl == null) {
            return;
        }
        LOG.debug("saveAuthData. provider=" + this.myCurrentProvider.getName() + ", unifiedUrl=" + this.myUnifiedUrl);
        this.myCurrentProvider.onAuthSuccess(this.myUnifiedUrl);
    }

    @Override
    public void forgetPassword() {
        if (this.myUnifiedUrl == null) {
            return;
        }
        LOG.debug("forgetPassword. provider=" + this.myCurrentProvider.getName() + ", unifiedUrl=" + this.myUnifiedUrl);
        this.myCurrentProvider.onAuthFailure(this.myUnifiedUrl);
    }

    @Override
    public boolean wasCancelled() {
        return this.myDialogProvider.isCancelled();
    }

    @NotNull
    private String getRequiredUrl(@Nullable String urlFromGit) {
        if (urlFromGit != null && !StringUtil.isEmptyOrSpaces((String)urlFromGit)) {
            String string = urlFromGit;
            if (string == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(14);
            }
            return string;
        }
        if (this.myPresetUrl == null) {
            throw new IllegalStateException("Invalid remote urls in handler");
        }
        String string = this.myPresetUrl;
        if (string == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static Couple<String> splitToUsernameAndUnifiedUrl(@NotNull String url) {
        if (url == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(16);
        }
        if (StringUtil.isEmptyOrSpaces((String)url)) {
            Couple couple = Couple.of(null, (Object)url);
            if (couple == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(17);
            }
            return couple;
        }
        Couple couple = UriUtil.splitScheme((String)url);
        String urlWithoutScheme = (String)couple.second;
        if (StringUtil.isEmptyOrSpaces((String)urlWithoutScheme)) {
            Couple couple2 = Couple.of(null, (Object)url);
            if (couple2 == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(18);
            }
            return couple2;
        }
        int i = urlWithoutScheme.indexOf(64);
        if (i <= 0) {
            Couple couple3 = Couple.of(null, (Object)(HTTP_SCHEME_URL_PREFIX + urlWithoutScheme));
            if (couple3 == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(19);
            }
            return couple3;
        }
        Couple couple4 = Couple.of((Object)urlWithoutScheme.substring(0, i), (Object)(HTTP_SCHEME_URL_PREFIX + urlWithoutScheme.substring(i + 1)));
        if (couple4 == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(20);
        }
        return couple4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticationGate";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitHttpGuiAuthenticator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitHttpGuiAuthenticator";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "askPassword";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doAskPassword";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "askUsername";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredUrl";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "splitToUsernameAndUnifiedUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFirstHttpUrl";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "askPassword";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doAskPassword";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "askUsername";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "splitToUsernameAndUnifiedUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PasswordSafeProvider
    implements AuthDataProvider {
        @NotNull
        private final DvcsRememberedInputs myRememberedInputs;
        @NotNull
        private final PasswordSafe myPasswordSafe;
        private AuthData myData;
        private boolean mySavePassword;

        PasswordSafeProvider(@NotNull DvcsRememberedInputs gitRememberedInputs, @NotNull PasswordSafe passwordSafe) {
            if (gitRememberedInputs == null) {
                PasswordSafeProvider.$$$reportNull$$$0(0);
            }
            if (passwordSafe == null) {
                PasswordSafeProvider.$$$reportNull$$$0(1);
            }
            this.mySavePassword = false;
            this.myRememberedInputs = gitRememberedInputs;
            this.myPasswordSafe = passwordSafe;
        }

        @Override
        @NotNull
        public String getName() {
            if ("Password Safe" == null) {
                PasswordSafeProvider.$$$reportNull$$$0(2);
            }
            return "Password Safe";
        }

        @Override
        @Nullable
        public AuthData getData(@NotNull String url, @Nullable String login) {
            if (url == null) {
                PasswordSafeProvider.$$$reportNull$$$0(3);
            }
            if (login == null) {
                String rememberedLogin = this.myRememberedInputs.getUserNameForUrl(url);
                if (rememberedLogin == null) {
                    return null;
                }
                return this.getDataForUser(url, rememberedLogin);
            }
            return this.getDataForUser(url, login);
        }

        @Override
        @Nullable
        public AuthData getDataForUser(@NotNull String url, @NotNull String login) {
            String key;
            Credentials credentials;
            if (url == null) {
                PasswordSafeProvider.$$$reportNull$$$0(4);
            }
            if (login == null) {
                PasswordSafeProvider.$$$reportNull$$$0(5);
            }
            String password = StringUtil.nullize((String)((credentials = CredentialAttributesKt.getAndMigrateCredentials((CredentialAttributes)PasswordSafeProvider.oldCredentialAttributes(key = PasswordSafeProvider.makeKey(url, login)), (CredentialAttributes)PasswordSafeProvider.credentialAttributes(key))) == null ? null : credentials.getPasswordAsString()));
            this.myData = new AuthData(login, password);
            return this.myData;
        }

        @Override
        public void onAuthSuccess(@NotNull String url) {
            if (url == null) {
                PasswordSafeProvider.$$$reportNull$$$0(6);
            }
        }

        @Override
        public void onAuthFailure(@NotNull String url) {
            if (url == null) {
                PasswordSafeProvider.$$$reportNull$$$0(7);
            }
            if (this.myData == null) {
                return;
            }
            String key = PasswordSafeProvider.makeKey(url, this.myData.getLogin());
            CredentialAttributes attributes = PasswordSafeProvider.credentialAttributes(key);
            LOG.debug("forgetPassword. key=" + attributes.getUserName());
            this.myPasswordSafe.set(attributes, null);
        }

        public void setData(@NotNull AuthData data) {
            if (data == null) {
                PasswordSafeProvider.$$$reportNull$$$0(8);
            }
            this.myData = data;
        }

        public void setRememberPassword(boolean remember) {
            this.mySavePassword = remember;
            this.myPasswordSafe.setRememberPasswordByDefault(remember);
        }

        public boolean isRememberPasswordByDefault() {
            return this.myPasswordSafe.isRememberPasswordByDefault();
        }

        public void savePassword(@NotNull String url) {
            if (url == null) {
                PasswordSafeProvider.$$$reportNull$$$0(9);
            }
            if (this.myData == null || this.myData.getPassword() == null) {
                return;
            }
            this.myRememberedInputs.addUrl(url, this.myData.getLogin());
            if (!this.mySavePassword) {
                return;
            }
            String key = PasswordSafeProvider.makeKey(url, this.myData.getLogin());
            Credentials credentials = new Credentials(key, this.myData.getPassword());
            this.myPasswordSafe.set(PasswordSafeProvider.credentialAttributes(key), credentials);
        }

        @NotNull
        private static CredentialAttributes credentialAttributes(@NotNull String key) {
            if (key == null) {
                PasswordSafeProvider.$$$reportNull$$$0(10);
            }
            CredentialAttributes credentialAttributes = new CredentialAttributes(CredentialAttributesKt.generateServiceName((String)"Git HTTP", (String)key), key, PASS_REQUESTER);
            if (credentialAttributes == null) {
                PasswordSafeProvider.$$$reportNull$$$0(11);
            }
            return credentialAttributes;
        }

        @NotNull
        private static CredentialAttributes oldCredentialAttributes(@NotNull String key) {
            if (key == null) {
                PasswordSafeProvider.$$$reportNull$$$0(12);
            }
            CredentialAttributes credentialAttributes = CredentialAttributesKt.CredentialAttributes((Class)PASS_REQUESTER, (String)key);
            if (credentialAttributes == null) {
                PasswordSafeProvider.$$$reportNull$$$0(13);
            }
            return credentialAttributes;
        }

        @NotNull
        private static String makeKey(@NotNull String url, @Nullable String login) {
            if (url == null) {
                PasswordSafeProvider.$$$reportNull$$$0(14);
            }
            if (login == null) {
                String string = url;
                if (string == null) {
                    PasswordSafeProvider.$$$reportNull$$$0(15);
                }
                return string;
            }
            Couple pair = UriUtil.splitScheme((String)url);
            String scheme = (String)pair.getFirst();
            if (!StringUtil.isEmpty((String)scheme)) {
                String string = scheme + "://" + login + "@" + (String)pair.getSecond();
                if (string == null) {
                    PasswordSafeProvider.$$$reportNull$$$0(16);
                }
                return string;
            }
            String string = login + "@" + url;
            if (string == null) {
                PasswordSafeProvider.$$$reportNull$$$0(17);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 11: 
                case 13: 
                case 15: 
                case 16: 
                case 17: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 11: 
                case 13: 
                case 15: 
                case 16: 
                case 17: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gitRememberedInputs";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "passwordSafe";
                    break;
                }
                case 2: 
                case 11: 
                case 13: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/commands/GitHttpGuiAuthenticator$PasswordSafeProvider";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "login";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/commands/GitHttpGuiAuthenticator$PasswordSafeProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "credentialAttributes";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "oldCredentialAttributes";
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "makeKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 11: 
                case 13: 
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataForUser";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "onAuthSuccess";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "onAuthFailure";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setData";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "savePassword";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "credentialAttributes";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "oldCredentialAttributes";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "makeKey";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 11: 
                case 13: 
                case 15: 
                case 16: 
                case 17: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DialogProvider
    implements AuthDataProvider {
        @NotNull
        private final Project myProject;
        @NotNull
        private final PasswordSafeProvider myPasswordSafeDelegate;
        private boolean myCancelled;
        private boolean myDataForSession;

        DialogProvider(@NotNull Project project, @NotNull PasswordSafeProvider passwordSafeDelegate) {
            if (project == null) {
                DialogProvider.$$$reportNull$$$0(0);
            }
            if (passwordSafeDelegate == null) {
                DialogProvider.$$$reportNull$$$0(1);
            }
            this.myDataForSession = false;
            this.myProject = project;
            this.myPasswordSafeDelegate = passwordSafeDelegate;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myDataForSession ? "Session Provider" : "Dialog";
            if (string == null) {
                DialogProvider.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @Nullable
        public AuthData getData(@NotNull String url, @Nullable String login) {
            if (url == null) {
                DialogProvider.$$$reportNull$$$0(3);
            }
            return this.getDataFromDialog(url, login, true);
        }

        @Override
        @Nullable
        public AuthData getDataForUser(@NotNull String url, @NotNull String login) {
            if (url == null) {
                DialogProvider.$$$reportNull$$$0(4);
            }
            if (login == null) {
                DialogProvider.$$$reportNull$$$0(5);
            }
            return this.getDataFromDialog(url, login, false);
        }

        @Override
        public void onAuthSuccess(@NotNull String url) {
            if (url == null) {
                DialogProvider.$$$reportNull$$$0(6);
            }
            if (this.myDataForSession) {
                return;
            }
            this.myPasswordSafeDelegate.onAuthSuccess(url);
        }

        @Override
        public void onAuthFailure(@NotNull String url) {
            if (url == null) {
                DialogProvider.$$$reportNull$$$0(7);
            }
            if (this.myDataForSession) {
                return;
            }
            this.myPasswordSafeDelegate.onAuthFailure(url);
        }

        @Nullable
        private AuthData getDataFromDialog(@NotNull String url, @Nullable String username, boolean editableUsername) {
            if (url == null) {
                DialogProvider.$$$reportNull$$$0(8);
            }
            HashMap<String, InteractiveGitHttpAuthDataProvider> providers = new HashMap<String, InteractiveGitHttpAuthDataProvider>();
            for (GitRepositoryHostingService service : (GitRepositoryHostingService[])GitRepositoryHostingService.EP_NAME.getExtensions()) {
                InteractiveGitHttpAuthDataProvider provider;
                InteractiveGitHttpAuthDataProvider interactiveGitHttpAuthDataProvider = provider = editableUsername || username == null ? service.getInteractiveAuthDataProvider(this.myProject, url) : service.getInteractiveAuthDataProvider(this.myProject, url, username);
                if (provider == null) continue;
                providers.put(service.getServiceDisplayName(), provider);
            }
            GitHttpLoginDialog dialog = this.showAuthDialog((String)UriUtil.splitScheme((String)url).second, username, editableUsername, providers);
            LOG.debug("Showed dialog:" + (dialog.isOK() ? "OK" : "Cancel"));
            if (!dialog.isOK()) {
                this.myCancelled = true;
                return null;
            }
            this.myPasswordSafeDelegate.setRememberPassword(dialog.getRememberPassword());
            AuthData sessionAuthData = dialog.getExternalAuthData();
            if (sessionAuthData != null) {
                this.myDataForSession = true;
                return sessionAuthData;
            }
            AuthData authData = new AuthData(dialog.getUsername(), dialog.getPassword());
            this.myPasswordSafeDelegate.setData(authData);
            this.myPasswordSafeDelegate.savePassword(url);
            return authData;
        }

        @NotNull
        private GitHttpLoginDialog showAuthDialog(@NotNull String url, @Nullable String username, boolean editableUsername, @NotNull Map<String, ? extends InteractiveGitHttpAuthDataProvider> interactiveProviders) {
            if (url == null) {
                DialogProvider.$$$reportNull$$$0(9);
            }
            if (interactiveProviders == null) {
                DialogProvider.$$$reportNull$$$0(10);
            }
            Ref dialogRef = Ref.create();
            ApplicationManager.getApplication().invokeAndWait(() -> {
                GitHttpLoginDialog dialog = new GitHttpLoginDialog(this.myProject, url, this.myPasswordSafeDelegate.isRememberPasswordByDefault(), username, editableUsername);
                dialog.setInteractiveDataProviders(interactiveProviders);
                dialogRef.set((Object)dialog);
                DialogManager.show(dialog);
            }, ModalityState.any());
            GitHttpLoginDialog gitHttpLoginDialog = (GitHttpLoginDialog)((Object)dialogRef.get());
            if (gitHttpLoginDialog == null) {
                DialogProvider.$$$reportNull$$$0(11);
            }
            return gitHttpLoginDialog;
        }

        public boolean isCancelled() {
            return this.myCancelled;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "passwordSafeDelegate";
                    break;
                }
                case 2: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/commands/GitHttpGuiAuthenticator$DialogProvider";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "login";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interactiveProviders";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/commands/GitHttpGuiAuthenticator$DialogProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "showAuthDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 11: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataForUser";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "onAuthSuccess";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "onAuthFailure";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataFromDialog";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "showAuthDialog";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ExtensionAdapterProvider
    implements AuthDataProvider {
        @NotNull
        private final Project myProject;
        @NotNull
        private final GitHttpAuthDataProvider myDelegate;
        private AuthData myData;

        ExtensionAdapterProvider(@NotNull Project project, @NotNull GitHttpAuthDataProvider provider) {
            if (project == null) {
                ExtensionAdapterProvider.$$$reportNull$$$0(0);
            }
            if (provider == null) {
                ExtensionAdapterProvider.$$$reportNull$$$0(1);
            }
            this.myData = null;
            this.myProject = project;
            this.myDelegate = provider;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myDelegate.getClass().getName();
            if (string == null) {
                ExtensionAdapterProvider.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public AuthData getData(@NotNull String url, @Nullable String suggestedLogin) {
            if (url == null) {
                ExtensionAdapterProvider.$$$reportNull$$$0(3);
            }
            this.myData = this.myDelegate.getAuthData(this.myProject, url);
            return this.myData;
        }

        @Override
        public AuthData getDataForUser(@NotNull String url, @NotNull String login) {
            if (url == null) {
                ExtensionAdapterProvider.$$$reportNull$$$0(4);
            }
            if (login == null) {
                ExtensionAdapterProvider.$$$reportNull$$$0(5);
            }
            this.myData = this.myDelegate.getAuthData(this.myProject, url, login);
            return this.myData;
        }

        @Override
        public void onAuthSuccess(@NotNull String url) {
            if (url == null) {
                ExtensionAdapterProvider.$$$reportNull$$$0(6);
            }
        }

        @Override
        public void onAuthFailure(@NotNull String url) {
            if (url == null) {
                ExtensionAdapterProvider.$$$reportNull$$$0(7);
            }
            if (this.myData != null) {
                this.myDelegate.forgetPassword(this.myProject, url, this.myData);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/commands/GitHttpGuiAuthenticator$ExtensionAdapterProvider";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "login";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/commands/GitHttpGuiAuthenticator$ExtensionAdapterProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataForUser";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "onAuthSuccess";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "onAuthFailure";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface AuthDataProvider {
        @NotNull
        public String getName();

        @Nullable
        public AuthData getData(@NotNull String var1, @Nullable String var2);

        @Nullable
        public AuthData getDataForUser(@NotNull String var1, @NotNull String var2);

        public void onAuthSuccess(@NotNull String var1);

        public void onAuthFailure(@NotNull String var1);
    }
}

