/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.indent.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.web.indent.api.embedding.JoinedTokenSequence;
import org.netbeans.modules.web.indent.api.embedding.VirtualSource;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public final class LexUtilities {
    private LexUtilities() {
    }

    public static <T extends TokenId> TokenSequence<T> getTokenSequence(BaseDocument doc, int offset, Language<T> language) {
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        return LexUtilities.getTokenSequence((TokenHierarchy<Document>)th, offset, language);
    }

    public static <T extends TokenId> TokenSequence<T> getTokenSequence(TokenHierarchy<Document> th, int offset, Language<T> language) {
        TokenSequence ts = th.tokenSequence(language);
        if (ts == null) {
            List list = th.embeddedTokenSequences(offset, true);
            for (TokenSequence t : list) {
                if (t.language() != language) continue;
                ts = t;
                break;
            }
            if (ts == null) {
                list = th.embeddedTokenSequences(offset, false);
                for (TokenSequence t : list) {
                    if (t.language() != language) continue;
                    ts = t;
                    break;
                }
            }
        }
        return ts;
    }

    public static Language<? extends TokenId> getLanguage(BaseDocument doc, int offset) {
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        return LexUtilities.getLanguage((TokenHierarchy<BaseDocument>)th, offset);
    }

    public static Language<? extends TokenId> getLanguage(TokenHierarchy<BaseDocument> th, int offset) {
        List list = th.embeddedTokenSequences(offset, true);
        if (list.isEmpty()) {
            return null;
        }
        return ((TokenSequence)list.get(list.size() - 1)).language();
    }

    public static <T extends TokenId> TokenSequence<T> getPositionedSequence(BaseDocument doc, int offset, Language<T> language) {
        return LexUtilities.getPositionedSequence(doc, offset, true, language);
    }

    public static <T extends TokenId> TokenSequence<T> getPositionedSequence(BaseDocument doc, int offset, boolean lookBack, Language<T> language) {
        TokenSequence<T> ts = LexUtilities.getTokenSequence(doc, offset, language);
        if (ts != null) {
            try {
                ts.move(offset);
            }
            catch (AssertionError e) {
                DataObject dobj = (DataObject)doc.getProperty((Object)"stream");
                if (dobj != null) {
                    Exceptions.attachMessage((Throwable)((Object)e), (String)FileUtil.getFileDisplayName((FileObject)dobj.getPrimaryFile()));
                }
                throw e;
            }
            if (!lookBack && !ts.moveNext()) {
                return null;
            }
            if (lookBack && !ts.moveNext() && !ts.movePrevious()) {
                return null;
            }
            return ts;
        }
        return null;
    }

    public static <T extends TokenId> Token<T> findNext(TokenSequence<T> ts, List<T> ignores) {
        if (ignores.contains(ts.token().id())) {
            while (ts.moveNext() && ignores.contains(ts.token().id())) {
            }
        }
        if (ts.token() == null || ignores.contains(ts.token().id())) {
            return null;
        }
        return ts.token();
    }

    public static <T extends TokenId> Token<T> findNext(JoinedTokenSequence<T> ts, List<T> ignores) {
        if (ignores.contains(ts.token().id())) {
            while (ts.moveNext() && ignores.contains(ts.token().id())) {
            }
        }
        if (ts.token() == null || ignores.contains(ts.token().id())) {
            return null;
        }
        return ts.token();
    }

    public static <T extends TokenId> Token<T> findPrevious(TokenSequence<T> ts, List<T> ignores) {
        if (ignores.contains(ts.token().id())) {
            while (ts.movePrevious() && ignores.contains(ts.token().id())) {
            }
        }
        if (ts.token() == null || ignores.contains(ts.token().id())) {
            return null;
        }
        return ts.token();
    }

    public static <T extends TokenId> Token<T> findPrevious(JoinedTokenSequence<T> ts, List<T> ignores) {
        if (ignores.contains(ts.token().id())) {
            while (ts.movePrevious() && ignores.contains(ts.token().id())) {
            }
        }
        if (ts.token() == null || ignores.contains(ts.token().id())) {
            return null;
        }
        return ts.token();
    }

    private static <T extends TokenId> TokenSequence<T> getVirtualTokens(VirtualSource virtualSource, int startOffset, int endOffset, Language<T> language) {
        if (virtualSource == null) {
            return null;
        }
        String source = virtualSource.getSource(startOffset, endOffset);
        if (source == null || source.length() == 0) {
            return null;
        }
        return TokenHierarchy.create((CharSequence)source, language).tokenSequence(language);
    }

    public static int getTokenSequenceEndOffset(TokenSequence<? extends TokenId> ts) {
        int currentIndex = ts.index();
        ts.moveEnd();
        ts.movePrevious();
        int offset = ts.offset() + ts.token().length();
        ts.moveIndex(currentIndex);
        return offset;
    }

    public static int getTokenSequenceEndOffset(JoinedTokenSequence<? extends TokenId> ts) {
        int[] currentIndex = ts.index();
        ts.moveEnd();
        ts.movePrevious();
        int offset = ts.offset() + ts.token().length();
        ts.moveIndex(currentIndex);
        return offset;
    }

    public static int getTokenSequenceStartOffset(TokenSequence<? extends TokenId> ts) {
        int currentIndex = ts.index();
        ts.moveStart();
        ts.moveNext();
        int offset = ts.offset();
        ts.moveIndex(currentIndex);
        return offset;
    }

    public static int getTokenSequenceStartOffset(JoinedTokenSequence<? extends TokenId> ts) {
        int[] currentIndex = ts.index();
        ts.moveStart();
        ts.moveNext();
        int offset = ts.offset();
        ts.moveIndex(currentIndex);
        return offset;
    }

    public static <T1 extends TokenId> Token<T1> getTokenAtOffset(JoinedTokenSequence<T1> ts, int offset) {
        int[] currentIndex = ts.index();
        ts.move(offset);
        ts.moveNext();
        Token<T1> t = ts.token();
        ts.moveIndex(currentIndex);
        return t;
    }

    public static <T1 extends TokenId> List<TokenSequence<T1>> getEmbeddedTokenSequences(BaseDocument doc, Language<T1> language, int start, int end) {
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        ArrayList<LanguagePath> lps = new ArrayList<LanguagePath>();
        for (LanguagePath lp : th.languagePaths()) {
            if (!lp.endsWith(LanguagePath.get(language))) continue;
            lps.add(lp);
        }
        ArrayList<TokenSequence<T1>> tss = new ArrayList<TokenSequence<T1>>();
        for (LanguagePath lp : lps) {
            List tss2 = th.tokenSequenceList(lp, start, end);
            if (tss2 == null) continue;
            for (TokenSequence ts2 : tss2) {
                ts2.moveStart();
                if (!ts2.moveNext()) continue;
                tss.add(ts2);
            }
        }
        Collections.sort(tss, new Comparator<TokenSequence<T1>>(){

            @Override
            public int compare(TokenSequence<T1> o1, TokenSequence<T1> o2) {
                assert (o1.offset() != o2.offset()) : "should never have two equal TokenSequence " + o1.toString() + " " + o2.language().toString();
                return o1.offset() - o2.offset();
            }
        });
        return tss;
    }

    private static <T1 extends TokenId> List<JoinedTokenSequence.CodeBlock<T1>> calculateCodeBlock(List<TokenSequence<T1>> tss, VirtualSource virtualSource) throws BadLocationException {
        ArrayList<JoinedTokenSequence.CodeBlock<T1>> blocks = new ArrayList<JoinedTokenSequence.CodeBlock<T1>>();
        for (int i = 0; i < tss.size(); ++i) {
            TokenSequence<T1> ts = tss.get(i);
            ArrayList tss2 = new ArrayList();
            tss2.add(new JoinedTokenSequence.TokenSequenceWrapper<T1>(ts, false));
            for (int j = i + 1; j < tss.size(); ++j) {
                TokenSequence<T1> prev = tss.get(j - 1);
                prev.moveEnd();
                prev.movePrevious();
                TokenSequence<T1> next = tss.get(j);
                next.moveStart();
                next.moveNext();
                TokenSequence tsVirtual = LexUtilities.getVirtualTokens(virtualSource, prev.offset() + prev.token().length(), next.offset(), ts.language());
                if (tsVirtual == null) break;
                tss2.add(new JoinedTokenSequence.TokenSequenceWrapper(tsVirtual, true));
                tss2.add(new JoinedTokenSequence.TokenSequenceWrapper<T1>(next, false));
                ++i;
            }
            blocks.add(new JoinedTokenSequence.CodeBlock(tss2));
        }
        return blocks;
    }

    public static <T1 extends TokenId> List<JoinedTokenSequence.CodeBlock<T1>> createCodeBlocks(BaseDocument doc, Language<T1> language, VirtualSource virtualSource) throws BadLocationException {
        List<TokenSequence<T1>> tss = LexUtilities.getEmbeddedTokenSequences(doc, language, 0, doc.getLength());
        if (tss.isEmpty()) {
            return null;
        }
        return LexUtilities.calculateCodeBlock(tss, virtualSource);
    }
}

