/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.chart;

import java.io.IOException;
import java.io.Writer;
import org.primefaces.model.chart.AxisType;
import org.primefaces.model.chart.ChartSeries;

public class LineChartSeries
extends ChartSeries {
    private String markerStyle = "filledCircle";
    private boolean showLine = true;
    private boolean showMarker = true;
    private boolean fill = false;
    private double fillAlpha = 1.0;
    private boolean disableStack;

    public LineChartSeries() {
    }

    public LineChartSeries(String title) {
        super(title);
    }

    public String getMarkerStyle() {
        return this.markerStyle;
    }

    public void setMarkerStyle(String markerStyle) {
        this.markerStyle = markerStyle;
    }

    public boolean isShowLine() {
        return this.showLine;
    }

    public void setShowLine(boolean showLine) {
        this.showLine = showLine;
    }

    public boolean isShowMarker() {
        return this.showMarker;
    }

    public void setShowMarker(boolean showMarker) {
        this.showMarker = showMarker;
    }

    public boolean isFill() {
        return this.fill;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
    }

    public double getFillAlpha() {
        return this.fillAlpha;
    }

    public void setFillAlpha(double fillAlpha) {
        this.fillAlpha = fillAlpha;
    }

    public boolean isDisableStack() {
        return this.disableStack;
    }

    public void setDisableStack(boolean disableStack) {
        this.disableStack = disableStack;
    }

    public String getRenderer() {
        return "LineRenderer";
    }

    public void encode(Writer writer) throws IOException {
        String renderer = this.getRenderer();
        AxisType xaxis = this.getXaxis();
        AxisType yaxis = this.getYaxis();
        writer.write("{");
        writer.write("label:'" + this.getLabel() + "'");
        writer.write(",renderer: $.jqplot." + renderer);
        if (xaxis != null) {
            writer.write(",xaxis:\"" + (Object)((Object)xaxis) + "\"");
        }
        if (yaxis != null) {
            writer.write(",yaxis:\"" + (Object)((Object)yaxis) + "\"");
        }
        if (this.disableStack) {
            writer.write(",disableStack:true");
        }
        if (this.fill) {
            writer.write(",fill:true");
            writer.write(",fillAlpha:" + this.getFillAlpha());
        }
        writer.write(",showLine:" + this.isShowLine());
        writer.write(",markerOptions:{show:" + this.isShowMarker() + ", style:'" + this.getMarkerStyle() + "'}");
        writer.write("}");
    }
}

