/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.apps.mailreader.dao.impl;

import java.util.HashMap;
import org.apache.struts.apps.mailreader.dao.Subscription;
import org.apache.struts.apps.mailreader.dao.User;
import org.apache.struts.apps.mailreader.dao.UserDatabase;
import org.apache.struts.apps.mailreader.dao.impl.AbstractSubscription;

public abstract class AbstractUser
implements User {
    private UserDatabase database = null;
    private HashMap subscriptions = new HashMap();
    private String username = null;
    private String fromAddress = null;
    private String fullName = null;
    private String password = null;
    private String replyToAddress = null;

    public AbstractUser(UserDatabase database, String username) {
        this.database = database;
        this.username = username;
    }

    public UserDatabase getDatabase() {
        return this.database;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getReplyToAddress() {
        return this.replyToAddress;
    }

    public void setReplyToAddress(String replyToAddress) {
        this.replyToAddress = replyToAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription[] getSubscriptions() {
        HashMap hashMap = this.subscriptions;
        synchronized (hashMap) {
            Subscription[] results = new Subscription[this.subscriptions.size()];
            return this.subscriptions.values().toArray(results);
        }
    }

    public String getUsername() {
        return this.username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription createSubscription(String host) {
        HashMap hashMap = this.subscriptions;
        synchronized (hashMap) {
            if (this.subscriptions.get(host) != null) {
                throw new IllegalArgumentException("Duplicate host '" + host + "' for user '" + this.username + "'");
            }
            AbstractSubscription subscription = new AbstractSubscription(this, host);
            HashMap hashMap2 = this.subscriptions;
            synchronized (hashMap2) {
                this.subscriptions.put(host, subscription);
            }
            return subscription;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription findSubscription(String host) {
        HashMap hashMap = this.subscriptions;
        synchronized (hashMap) {
            return (Subscription)this.subscriptions.get(host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(Subscription subscription) {
        if (this != subscription.getUser()) {
            throw new IllegalArgumentException("Subscription not associated with this user");
        }
        HashMap hashMap = this.subscriptions;
        synchronized (hashMap) {
            this.subscriptions.remove(subscription.getHost());
        }
    }
}

