/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.queries;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.GradleProjects;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class GradleSourceForRepository
implements SourceForBinaryQueryImplementation2,
JavadocForBinaryQueryImplementation {
    private final Map<URL, SrcRes> srcCache = Collections.synchronizedMap(new WeakHashMap());
    private final Map<URL, DocRes> docCache = Collections.synchronizedMap(new WeakHashMap());

    public SourceForBinaryQueryImplementation2.Result findSourceRoots2(URL binaryRoot) {
        SrcRes ret = this.srcCache.get(binaryRoot);
        if (ret == null && "jar".equals(binaryRoot.getProtocol())) {
            try {
                NbGradleProject project;
                File sources = null;
                File jar = FileUtil.normalizeFile((File)Utilities.toFile((URI)FileUtil.getArchiveFile((URL)binaryRoot).toURI()));
                Project owner = FileOwnerQuery.getOwner((URI)Utilities.toURI((File)jar));
                NbGradleProject nbGradleProject = project = owner != null ? (NbGradleProject)owner.getLookup().lookup(NbGradleProject.class) : null;
                if (project == null) {
                    sources = GradleProjects.getSources((File)jar);
                }
                if (sources != null) {
                    ret = new SrcRes(sources);
                    this.srcCache.put(binaryRoot, ret);
                }
            }
            catch (IllegalArgumentException | URISyntaxException exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        return this.findSourceRoots2(binaryRoot);
    }

    public JavadocForBinaryQuery.Result findJavadoc(URL binaryRoot) {
        DocRes ret = this.docCache.get(binaryRoot);
        if (ret == null && "jar".equals(binaryRoot.getProtocol())) {
            try {
                File jar = FileUtil.normalizeFile((File)Utilities.toFile((URI)FileUtil.getArchiveFile((URL)binaryRoot).toURI()));
                File doc = GradleProjects.getJavadoc((File)jar);
                if (doc != null) {
                    ret = new DocRes(doc);
                    this.docCache.put(binaryRoot, ret);
                }
            }
            catch (IllegalArgumentException | URISyntaxException exception) {
                // empty catch block
            }
        }
        return ret;
    }

    private static class DocRes
    implements JavadocForBinaryQuery.Result {
        private final File root;

        public DocRes(File root) {
            this.root = root;
        }

        public URL[] getRoots() {
            FileObject arch;
            URL[] ret = new URL[]{};
            FileObject fo = FileUtil.toFileObject((File)this.root);
            if (fo != null && (arch = FileUtil.getArchiveRoot((FileObject)fo)) != null) {
                ret = new URL[]{arch.toURL()};
            }
            return ret;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }

    private static class SrcRes
    implements SourceForBinaryQueryImplementation2.Result {
        private final File root;

        public SrcRes(File root) {
            this.root = root;
        }

        public boolean preferSources() {
            return false;
        }

        public FileObject[] getRoots() {
            FileObject[] ret = new FileObject[]{};
            FileObject fo = FileUtil.toFileObject((File)this.root);
            if (fo != null) {
                if (FileUtil.isArchiveFile((FileObject)fo)) {
                    FileObject arch = FileUtil.getArchiveRoot((FileObject)fo);
                    if (arch != null) {
                        ret = new FileObject[]{arch};
                    }
                } else {
                    ret = new FileObject[]{fo};
                }
            }
            return ret;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

