/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.openide.util.NbBundle;

public class Hk2DeploymentFactory
implements DeploymentFactory {
    private static Hk2DeploymentFactory preludeInstance;
    private static Hk2DeploymentFactory ee6Instance;
    private String[] uriFragments;
    private String version;
    private String displayName;
    private ServerUtilities su;

    private Hk2DeploymentFactory(String[] uriFragments, String version, String displayName) {
        this.uriFragments = uriFragments;
        this.version = version;
        this.displayName = displayName;
    }

    private void setServerUtilities(ServerUtilities su) {
        this.su = su;
    }

    public static synchronized DeploymentFactory createEe6() {
        if (ee6Instance == null) {
            ServerUtilities tmp = ServerUtilities.getEe6Utilities();
            ee6Instance = new Hk2DeploymentFactory(new String[]{"deployer:gfv3ee6:", "deployer:gfv3ee6wc:", "deployer:gfv3"}, "0.2", NbBundle.getMessage(Hk2DeploymentFactory.class, (String)"TXT_FactoryDisplayName"));
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)ee6Instance);
            ee6Instance.setServerUtilities(tmp);
        }
        return ee6Instance;
    }

    public boolean handlesURI(String uri) {
        if (uri == null) {
            return false;
        }
        if (uri.startsWith("[")) {
            for (String uriFragment : this.uriFragments) {
                if (uri.indexOf(uriFragment) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public DeploymentManager getDeploymentManager(String uri, String uname, String passwd) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException("Invalid URI:" + uri);
        }
        if (!this.su.isRegisteredUri(uri)) {
            throw new DeploymentManagerCreationException("Registry mismatch for " + uri);
        }
        return new Hk2DeploymentManager(uri, uname, passwd, this.su);
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException("Invalid URI:" + uri);
        }
        if (!this.su.isRegisteredUri(uri)) {
            throw new DeploymentManagerCreationException("Registry mismatch for " + uri);
        }
        return new Hk2DeploymentManager(uri, null, null, this.su);
    }

    public String getProductVersion() {
        return this.version;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

