/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.actions;

import java.awt.event.ActionEvent;
import org.netbeans.modules.glassfish.common.GlassFishState;
import org.netbeans.modules.glassfish.common.actions.AbstractOutputAction;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class StartServerAction
extends NodeAction {
    protected void performAction(Node[] activatedNodes) {
        for (Node node : activatedNodes) {
            GlassfishModule commonSupport = (GlassfishModule)node.getLookup().lookup(GlassfishModule.class);
            if (commonSupport == null) continue;
            StartServerAction.performActionImpl(commonSupport);
        }
    }

    private static void performActionImpl(GlassfishModule commonSupport) {
        commonSupport.setEnvironmentProperty("jvmMode", GlassfishModule.NORMAL_MODE, true);
        commonSupport.startServer(null, GlassfishModule.ServerState.RUNNING);
    }

    protected boolean enable(Node[] activatedNodes) {
        boolean result = false;
        if (activatedNodes != null && activatedNodes.length > 0) {
            Node node;
            GlassfishModule commonSupport;
            Node[] nodeArray = activatedNodes;
            int n = nodeArray.length;
            for (int i = 0; i < n && (result = (commonSupport = (GlassfishModule)(node = nodeArray[i]).getLookup().lookup(GlassfishModule.class)) != null ? StartServerAction.enableImpl(commonSupport) : false); ++i) {
            }
        }
        return result;
    }

    private static boolean enableImpl(GlassfishModule commonSupport) {
        GlassFishServer server = commonSupport.getInstance();
        return GlassFishState.canStart(server) && !server.isRemote();
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(StartServerAction.class, (String)"CTL_StartServerAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public static class OutputAction
    extends AbstractOutputAction {
        private static final String ICON = "org/netbeans/modules/glassfish/common/resources/start.png";

        public OutputAction(GlassfishModule commonSupport) {
            super(commonSupport, NbBundle.getMessage(StartServerAction.class, (String)"LBL_StartOutput"), NbBundle.getMessage(StartServerAction.class, (String)"LBL_StartOutputDesc"), ICON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StartServerAction.performActionImpl(this.commonSupport);
        }

        @Override
        public boolean isEnabled() {
            return StartServerAction.enableImpl(this.commonSupport);
        }
    }
}

