/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.gradle;

import java.io.File;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.internal.gradle.GradleProjectIdentity;

public class PartialBasicGradleProject
implements Serializable,
GradleProjectIdentity {
    private String name;
    private DefaultProjectIdentifier projectIdentifier;
    private PartialBasicGradleProject parent;
    private Set<PartialBasicGradleProject> children = new LinkedHashSet<PartialBasicGradleProject>();

    public String toString() {
        return "GradleProject{path='" + this.getPath() + "'}";
    }

    public String getPath() {
        return this.projectIdentifier.getProjectPath();
    }

    public PartialBasicGradleProject getParent() {
        return this.parent;
    }

    public PartialBasicGradleProject setParent(PartialBasicGradleProject parent) {
        this.parent = parent;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public PartialBasicGradleProject setName(String name) {
        this.name = name;
        return this;
    }

    public Set<? extends PartialBasicGradleProject> getChildren() {
        return this.children;
    }

    public PartialBasicGradleProject addChild(PartialBasicGradleProject child) {
        this.children.add(child);
        return this;
    }

    public DefaultProjectIdentifier getProjectIdentifier() {
        return this.projectIdentifier;
    }

    @Override
    public String getProjectPath() {
        return this.projectIdentifier.getProjectPath();
    }

    @Override
    public File getRootDir() {
        return this.projectIdentifier.getBuildIdentifier().getRootDir();
    }

    public PartialBasicGradleProject setProjectIdentifier(DefaultProjectIdentifier projectIdentifier) {
        this.projectIdentifier = projectIdentifier;
        return this;
    }
}

