/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.comet.concurrent;

import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.comet.CometEvent;
import com.sun.enterprise.web.connector.grizzly.comet.CometHandler;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultConcurrentCometHandler<E>
implements CometHandler<E> {
    protected static final Logger logger = SelectorThread.logger();
    private boolean shuttingDown;
    private final int messageQueueLimit;
    private int queueSize;
    private boolean readyForWork = true;
    protected final Queue<CometEvent> messageQueue = new LinkedList<CometEvent>();
    protected E attachment;

    public DefaultConcurrentCometHandler() {
        this(100);
    }

    public DefaultConcurrentCometHandler(int messageQueueLimit) {
        this.messageQueueLimit = messageQueueLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueEvent(CometEvent event) {
        Queue<CometEvent> queue = this.messageQueue;
        synchronized (queue) {
            if (!this.readyForWork) {
                if (!this.shuttingDown && this.queueSize < this.messageQueueLimit) {
                    this.messageQueue.add(event);
                    ++this.queueSize;
                }
                return;
            }
            this.readyForWork = false;
        }
        boolean queueFull = false;
        while (!this.shuttingDown) {
            Object var6_7;
            Object object;
            if (!event.getCometContext().isActive(this)) {
                this.shuttingDown = true;
                return;
            }
            try {
                try {
                    object = this;
                    synchronized (object) {
                        this.onEvent(event);
                    }
                    var6_7 = null;
                    if (this.shuttingDown) {
                        event.getCometContext().resumeCometHandler(this);
                        return;
                    }
                }
                catch (IOException ex) {
                    this.shuttingDown = true;
                    var6_7 = null;
                    if (this.shuttingDown) {
                        event.getCometContext().resumeCometHandler(this);
                        return;
                    }
                }
            }
            catch (Throwable throwable) {
                var6_7 = null;
                if (this.shuttingDown) {
                    event.getCometContext().resumeCometHandler(this);
                    return;
                }
                throw throwable;
            }
            object = this.messageQueue;
            synchronized (object) {
                if (this.queueSize == this.messageQueueLimit) {
                    queueFull = true;
                } else {
                    if (this.queueSize == 0) {
                        this.readyForWork = true;
                        return;
                    }
                    event = this.messageQueue.poll();
                    --this.queueSize;
                }
            }
            if (!queueFull) continue;
            this.shuttingDown = true;
            this.onQueueFull(event);
        }
    }

    public void onQueueFull(CometEvent event) {
        event.getCometContext().resumeCometHandler(this);
    }

    public E attachment() {
        return this.attachment;
    }

    @Override
    public void attach(E attachment) {
        this.attachment = attachment;
    }

    @Override
    public void onInterrupt(CometEvent event) throws IOException {
        this.terminate();
    }

    @Override
    public void onTerminate(CometEvent event) throws IOException {
        this.terminate();
    }

    protected void terminate() {
    }
}

