/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.DefaultReadTask;
import com.sun.enterprise.web.connector.grizzly.HtmlHelper;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class XAReadTask
extends DefaultReadTask {
    protected boolean inKeepAliveProcess = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doTask() throws IOException {
        int count = 0;
        Socket socket = null;
        SocketChannel socketChannel = null;
        boolean keepAlive = false;
        Exception exception = null;
        this.key.attach(null);
        if (this.byteBuffer == null) {
            this.byteBuffer = this.algorithm.allocate(this.useDirectByteBuffer, this.useByteBufferView, this.selectorThread.getBufferSize());
        }
        try {
            try {
                this.inKeepAliveProcess = true;
                socketChannel = (SocketChannel)this.key.channel();
                socket = socketChannel.socket();
                this.algorithm.setSocketChannel(socketChannel);
                int loop = 0;
                boolean bufferSize = false;
                while (socketChannel.isOpen() && (this.bytesAvailable || (count = socketChannel.read(this.byteBuffer)) > -1)) {
                    if (count == 0 && !this.bytesAvailable) {
                        if (++loop <= 2) continue;
                        break;
                    }
                    if (this.bytesAvailable) {
                        count = this.byteBuffer.position();
                    }
                    this.bytesAvailable = false;
                    this.byteBuffer = this.algorithm.preParse(this.byteBuffer);
                    this.inputStream.setByteBuffer(this.byteBuffer);
                    this.inputStream.setSelectionKey(this.key);
                    if (this.algorithm.parse(this.byteBuffer)) {
                        keepAlive = this.executeProcessorTask();
                        if (!keepAlive) {
                            this.inKeepAliveProcess = false;
                            break;
                        }
                    } else {
                        keepAlive = true;
                        this.inKeepAliveProcess = false;
                        break;
                    }
                    if (this.algorithm.contentLength() <= this.maxPostSize) continue;
                    this.cancelTask("Maximum POST size reached: " + this.maxPostSize, HtmlHelper.OK);
                    keepAlive = false;
                    break;
                }
            }
            catch (IOException ex) {
                exception = ex;
                Object var9_11 = null;
                this.manageKeepAlive(keepAlive, count, exception);
                return;
            }
            catch (RuntimeException ex) {
                exception = ex;
                Object var9_12 = null;
                this.manageKeepAlive(keepAlive, count, exception);
                return;
            }
            Object var9_10 = null;
            this.manageKeepAlive(keepAlive, count, exception);
            return;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            this.manageKeepAlive(keepAlive, count, exception);
            throw throwable;
        }
    }

    protected void manageKeepAlive(boolean keepAlive, int count, Exception exception) {
        boolean attached;
        if (count == -1 || !this.key.isValid() || exception != null) {
            this.inKeepAliveProcess = false;
            keepAlive = false;
            if (exception != null) {
                this.detachProcessor();
                SelectorThread.logger().log(Level.FINEST, "SocketChannel Read Exception: ", exception);
            }
        }
        boolean bl = attached = !this.inKeepAliveProcess;
        if (keepAlive) {
            if (this.inKeepAliveProcess) {
                this.key.attach(null);
            } else {
                this.key.attach(this);
            }
            this.registerKey();
            if (attached) {
                return;
            }
            if (this.inKeepAliveProcess) {
                this.terminate(keepAlive);
            }
        } else {
            this.terminate(keepAlive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeProcessorTask() throws IOException {
        boolean registerKey = false;
        if (SelectorThread.logger().isLoggable(Level.FINEST)) {
            SelectorThread.logger().log(Level.FINEST, "executeProcessorTask");
        }
        if (this.algorithm.getHandler() != null && this.algorithm.getHandler().handle(null, 2) == 1) {
            return true;
        }
        if (this.processorTask == null) {
            this.attachProcessor(this.selectorThread.getProcessorTask());
        }
        try {
            try {
                registerKey = this.processorTask.process(this.inputStream, null);
            }
            catch (Exception e) {
                SelectorThread.logger().log(Level.SEVERE, "readTask.processException", e);
                registerKey = true;
                Object var4_3 = null;
                if (registerKey && this.processorTask.isError()) {
                    this.byteBuffer = this.algorithm.rollbackParseState(this.byteBuffer);
                    this.inKeepAliveProcess = false;
                    return registerKey;
                }
            }
            Object var4_2 = null;
            if (registerKey && this.processorTask.isError()) {
                this.byteBuffer = this.algorithm.rollbackParseState(this.byteBuffer);
                this.inKeepAliveProcess = false;
                return registerKey;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (registerKey && this.processorTask.isError()) {
                this.byteBuffer = this.algorithm.rollbackParseState(this.byteBuffer);
                this.inKeepAliveProcess = false;
                return registerKey;
            }
            throw throwable;
        }
        this.detachProcessor();
        return registerKey;
    }

    public void terminate(boolean keepAlive) {
        super.terminate(keepAlive);
    }

    public void recycle() {
        this.byteBuffer = this.algorithm.postParse(this.byteBuffer);
        this.byteBuffer.clear();
        this.inputStream.recycle();
        this.algorithm.recycle();
        this.key = null;
        this.inputStream.setSelectionKey(null);
    }
}

