/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.xml.parsers;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.NbBundle;

class Util {
    public static final Util THIS = new Util();
    private static final Logger LOG = Logger.getLogger(Util.class.getName());
    private static final Level DEBUG_SEVERITY = Level.INFO;

    private Util() {
    }

    public final String getString(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    public final String getString(String key, Object param) {
        if (key == null) {
            throw new NullPointerException();
        }
        return NbBundle.getMessage(this.getClass(), (String)key, (Object)param);
    }

    public final String getString(String key, Object param1, Object param2) {
        if (key == null) {
            throw new NullPointerException();
        }
        return NbBundle.getMessage(this.getClass(), (String)key, (Object)param1, (Object)param2);
    }

    public final char getChar(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return NbBundle.getMessage(this.getClass(), (String)key).charAt(0);
    }

    public final boolean isLoggable() {
        return this.isLoggable(DEBUG_SEVERITY);
    }

    public final boolean isLoggable(Level level) {
        return LOG.isLoggable(level);
    }

    public final void debug(String message) {
        this.debug(DEBUG_SEVERITY, message);
    }

    public final void debug(Level level, String message) {
        if (message == null) {
            return;
        }
        LOG.log(level, message);
    }

    public final void debug(Throwable ex) {
        if (ex == null) {
            return;
        }
        LOG.log(DEBUG_SEVERITY, null, ex);
    }

    public final void debug(String message, Throwable ex) {
        if (ex == null) {
            return;
        }
        LOG.log(DEBUG_SEVERITY, message, ex);
    }
}

