/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.api;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.libraries.LibraryFactory;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation3;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.Parameters;

public class JsfComponentUtils {
    private JsfComponentUtils() {
    }

    public static Library enhanceLibraryWithPomContent(final Library library, final List<URI> poms) throws IOException {
        Parameters.notNull((CharSequence)"library", (Object)library);
        Parameters.notNull((CharSequence)"poms", poms);
        List mavenContent = library.getContent("maven-pom");
        String name = library.getName();
        if (mavenContent == null || mavenContent.isEmpty()) {
            Runnable call = new Runnable(){

                @Override
                public void run() {
                    String type = library.getType();
                    String name = library.getName();
                    String displayName = library.getDisplayName();
                    String desc = library.getDescription();
                    HashMap<String, List> content = new HashMap<String, List>();
                    content.put("classpath", library.getURIContent("classpath"));
                    content.put("src", library.getURIContent("src"));
                    content.put("javadoc", library.getURIContent("javadoc"));
                    content.put("maven-pom", poms);
                    try {
                        LibraryManager.getDefault().removeLibrary(library);
                        LibraryManager.getDefault().createURILibrary(type, name, displayName, desc, content);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    catch (IllegalArgumentException iae) {
                        Exceptions.printStackTrace((Throwable)iae);
                    }
                }
            };
            Mutex.EVENT.writeAccess(call);
        }
        return LibraryManager.getDefault().getLibrary(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reformat(@NonNull DataObject dob) {
        Parameters.notNull((CharSequence)"dob", (Object)dob);
        try {
            EditorCookie ec = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
            if (ec == null) {
                return;
            }
            final StyledDocument doc = ec.openDocument();
            final Reformat reformat = Reformat.get((Document)doc);
            reformat.lock();
            try {
                NbDocument.runAtomicAsUser((StyledDocument)doc, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            reformat.reformat(0, doc.getLength());
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                reformat.unlock();
                ec.saveDocument();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enhanceFileBody(@NonNull DataObject dob, final @NonNull String find, final @NonNull String enhanceBy) {
        Parameters.notNull((CharSequence)"dob", (Object)dob);
        Parameters.notNull((CharSequence)"find", (Object)find);
        Parameters.notNull((CharSequence)"enhanceBy", (Object)enhanceBy);
        try {
            EditorCookie ec = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
            if (ec == null) {
                return;
            }
            final StyledDocument doc = ec.openDocument();
            try {
                NbDocument.runAtomicAsUser((StyledDocument)doc, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int position = doc.getText(0, doc.getLength()).indexOf(find);
                            if (position >= 0) {
                                doc.insertString(position, enhanceBy + "\n", null);
                            }
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                ec.saveDocument();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static boolean isMavenBased(@NonNull WebModule webModule) {
        Project project;
        AntArtifactProvider antArtifactProvider;
        FileObject[] sources;
        Parameters.notNull((CharSequence)"webModule", (Object)webModule);
        FileObject fo = webModule.getDocumentBase();
        if (fo == null && (sources = webModule.getJavaSources()).length > 0) {
            fo = sources[0];
        }
        return (antArtifactProvider = (AntArtifactProvider)(project = FileOwnerQuery.getOwner((FileObject)fo)).getLookup().lookup(AntArtifactProvider.class)) == null;
    }

    public static Library createMavenDependencyLibrary(@NonNull String name, @NonNull String[] mavenDeps, @NonNull String[] mavenRepos) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"mavenDeps", (Object)mavenDeps);
        Parameters.notNull((CharSequence)"mavenRepos", (Object)mavenRepos);
        LibraryImplementation3 libImpl = CommonProjectUtils.createJavaLibraryImplementation((String)name, (URL[])new URL[0], (URL[])new URL[0], (URL[])new URL[0], (String[])mavenDeps, (String[])mavenRepos);
        return LibraryFactory.createLibrary((LibraryImplementation)libImpl);
    }
}

