/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.Bundle;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

public class ShowOppositeProfilingPointAction
extends SystemAction
implements ContextAwareAction {
    public ShowOppositeProfilingPointAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.setEnabled(false);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ShowOppositeProfilingPointAction.class);
    }

    public String getName() {
        return Bundle.ShowOppositeProfilingPointAction_NoDataString();
    }

    public void actionPerformed(ActionEvent ae) {
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        Collection anns;
        InvocationLocationDescriptor desc;
        if (!ProfilingPointsManager.getDefault().isProfilingSessionInProgress() && (desc = this.getCurrentLocationDescriptor(anns = actionContext.lookupAll(CodeProfilingPoint.Annotation.class))) != null) {
            String name = desc.isStartLocation() ? Bundle.ShowOppositeProfilingPointAction_EndActionName() : Bundle.ShowOppositeProfilingPointAction_StartActionName();
            return new AbstractAction(name){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CodeProfilingPoint.Location oppositeLocation = desc.getOppositeLocation();
                    if (oppositeLocation != null) {
                        Utils.openLocation(oppositeLocation);
                    } else {
                        ProfilerDialogs.displayWarning((String)Bundle.ShowOppositeProfilingPointAction_NoEndDefinedMsg());
                    }
                }
            };
        }
        return this;
    }

    private InvocationLocationDescriptor getCurrentLocationDescriptor(Collection<? extends CodeProfilingPoint.Annotation> anns) {
        if (anns.size() == 1) {
            CodeProfilingPoint pp = anns.iterator().next().profilingPoint();
            CodeProfilingPoint.Location currentLocation = Utils.getCurrentLocation(0);
            if (pp instanceof CodeProfilingPoint.Paired) {
                return new InvocationLocationDescriptor((CodeProfilingPoint.Paired)pp, currentLocation);
            }
        }
        return null;
    }

    private static class InvocationLocationDescriptor {
        private CodeProfilingPoint.Location location;
        private CodeProfilingPoint.Location oppositeLocation;
        private boolean isStartLocation;

        InvocationLocationDescriptor(CodeProfilingPoint.Paired profilingPoint, CodeProfilingPoint.Location location) {
            this.location = location;
            this.computeOppositeLocation(profilingPoint);
        }

        CodeProfilingPoint.Location getLocation() {
            return this.location;
        }

        CodeProfilingPoint.Location getOppositeLocation() {
            return this.oppositeLocation;
        }

        boolean isStartLocation() {
            return this.isStartLocation;
        }

        private void computeOppositeLocation(CodeProfilingPoint.Paired profilingPoint) {
            CodeProfilingPoint.Location startLocation = profilingPoint.getStartLocation();
            if (new File(startLocation.getFile()).equals(new File(this.location.getFile())) && startLocation.getLine() == this.location.getLine()) {
                this.oppositeLocation = profilingPoint.getEndLocation();
                this.isStartLocation = true;
            } else {
                this.oppositeLocation = profilingPoint.getStartLocation();
                this.isStartLocation = false;
            }
        }
    }
}

