/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Binding;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.customization.multiview.ExternalBindingTablePanel;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

public class ExternalBindingPanel
extends SaveableSectionInnerPanel {
    private ExternalBindingTablePanel panel;
    private Node node;
    private boolean jaxwsIsDirty;

    public ExternalBindingPanel(SectionView sectionView, Node node) {
        super(sectionView);
        this.node = node;
        ExternalBindingTablePanel.EBTableModel model = new ExternalBindingTablePanel.EBTableModel();
        this.panel = new ExternalBindingTablePanel(model, node);
        this.panel.populateModel();
        this.initComponents2();
    }

    public JComponent getErrorComponent(String errorId) {
        return null;
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
    }

    public void setValue(JComponent source, Object value) {
    }

    private void initComponents2() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)((Object)this.panel), -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent((Component)((Object)this.panel), -2, -1, -2).addContainerGap(19, Short.MAX_VALUE)));
    }

    @Override
    public boolean wsdlIsDirty() {
        return false;
    }

    @Override
    public boolean jaxwsIsDirty() {
        return this.jaxwsIsDirty;
    }

    @Override
    public void save() {
        JAXWSClientSupport support;
        FileObject srcRoot = (FileObject)this.node.getLookup().lookup(FileObject.class);
        FileObject bindingsFolder = null;
        if (this.isClient()) {
            support = JAXWSClientSupport.getJaxWsClientSupport((FileObject)srcRoot);
            bindingsFolder = support.getBindingsFolderForClient(this.node.getName(), true);
        } else {
            support = JAXWSSupport.getJAXWSSupport((FileObject)srcRoot);
            bindingsFolder = support.getBindingsFolderForService(this.node.getName(), true);
        }
        assert (srcRoot != null) : "Cannot find srcRoot";
        Client client = (Client)this.node.getLookup().lookup(Client.class);
        Service service = (Service)this.node.getLookup().lookup(Service.class);
        Map<String, FileObject> addedBindings = this.panel.getAddedBindings();
        Set<String> removedBindings = this.panel.getRemovedBindings();
        if (addedBindings.size() > 0 || removedBindings.size() > 0) {
            this.jaxwsIsDirty = true;
        }
        for (Map.Entry<String, FileObject> bindingEntrySet : addedBindings.entrySet()) {
            Binding binding;
            String bindingName = bindingEntrySet.getKey();
            FileObject bindingFO = bindingEntrySet.getValue();
            if (bindingFO != null) {
                String normalizedBindingName = bindingName;
                String ext = bindingFO.getExt();
                if (!ext.equals("")) {
                    int index = normalizedBindingName.indexOf(ext);
                    normalizedBindingName = normalizedBindingName.substring(0, index - 1);
                }
                try {
                    SaveCookie sc;
                    FileObject copiedBinding = FileUtil.copyFile((FileObject)bindingFO, (FileObject)bindingsFolder, (String)normalizedBindingName, (String)bindingFO.getExt());
                    DataObject dobj = DataObject.find((FileObject)copiedBinding);
                    String relativePath = this.panel.getRelativePathToWsdl();
                    boolean changed = JaxWsUtils.addRelativeWsdlLocation((FileObject)copiedBinding, (String)relativePath);
                    if (changed && dobj != null && (sc = (SaveCookie)dobj.getCookie(SaveCookie.class)) != null) {
                        sc.save();
                    }
                    if (dobj != null) {
                        EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
                        ec.open();
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
            if (client != null) {
                binding = client.newBinding();
                binding.setFileName(bindingName);
                client.addBinding(binding);
                continue;
            }
            if (service == null) continue;
            binding = service.newBinding();
            binding.setFileName(bindingName);
            service.addBinding(binding);
        }
        for (String removedBinding : removedBindings) {
            Binding binding;
            if (client != null) {
                binding = client.getBindingByFileName(removedBinding);
                if (binding == null) continue;
                client.removeBinding(binding);
                continue;
            }
            if (service == null || (binding = service.getBindingByFileName(removedBinding)) == null) continue;
            service.removeBinding(binding);
        }
    }

    private boolean isClient() {
        Client client = (Client)this.node.getLookup().lookup(Client.class);
        return client != null;
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

